/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class FilterComponent
implements CommonConstants {
    public static FilterComponent create(boolean createDefaultFilters, boolean toLowerCase) {
        return new Impl(createDefaultFilters, toLowerCase);
    }

    public abstract JComponent getComponent();

    public abstract void setFilterValue(String var1);

    public abstract String getFilterValue();

    public abstract void addFilterType(String var1, int var2);

    public abstract void setFilterType(int var1);

    public abstract int getFilterType();

    public abstract void setFilter(String var1, int var2);

    public abstract void setHint(String var1);

    public abstract String getHint();

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    public static String[] getFilterValues(String filterValue) {
        return filterValue == null ? null : filterValue.trim().split(" +");
    }

    protected FilterComponent() {
    }

    private static class Impl
    extends FilterComponent {
        private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.components.Bundle");
        private static final String STRING_FILTER_CONTAINS = messages.getString("FilterComponent_FilterContains");
        private static final String STRING_FILTER_NOT_CONTAINS = messages.getString("FilterComponent_FilterNotContains");
        private static final String STRING_FILTER_REGEXP = messages.getString("FilterComponent_FilterRegexp");
        private static final String FILTER_TYPE_TOOLTIP = messages.getString("FilterComponent_FilterTypeToolTip");
        private static final String FILTER_TOOLTIP = messages.getString("FilterComponent_FilterValueToolTip");
        private static final String SUBMIT_TOOLTIP = messages.getString("FilterComponent_SetFilterButtonToolTip");
        private static final String CLEAR_TOOLTIP = messages.getString("FilterComponent_ClearFilterButtonToolTip");
        private static final String ACCESS_NAME = messages.getString("FilterComponent_AccessName");
        private static final String ACCESS_DESCR = messages.getString("FilterComponent_AccessDescr");
        private static final String FILTER_HINT = messages.getString("FilterComponent_FilterHint");
        private static final String FILTER_EMPTY = "";
        private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
        private final List<String> filterTypeNames = new ArrayList<String>();
        private final List<Integer> filterTypes = new ArrayList<Integer>();
        private final boolean toLowerCase;
        private String filterValue = "";
        private int filterType = 0;
        private String filterHint;
        private final JComponent component;
        private final FilterCombo filterCombo;
        private boolean suppressEvents = false;

        Impl(boolean createDefaultFilters, boolean lowerCase) {
            this.toLowerCase = lowerCase;
            this.filterCombo = new FilterCombo();
            this.filterCombo.setToolTipText(FILTER_TOOLTIP);
            this.component = new JPanel(new BorderLayout()){

                @Override
                public void setBounds(int x, int y, int w, int h) {
                    if (UIUtils.isAquaLookAndFeel()) {
                        w += 2;
                    }
                    super.setBounds(x, y, w, h);
                }
            };
            this.component.setOpaque(false);
            if (UIUtils.isWindowsLookAndFeel() || UIUtils.isMetalLookAndFeel()) {
                Insets i = this.filterCombo.getInsets();
                this.component.setBorder(BorderFactory.createEmptyBorder(0, -i.left, 0, -i.right));
            } else if (UIUtils.isGTKLookAndFeel()) {
                this.component.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
            }
            this.component.add((Component)this.filterCombo, "Center");
            if (createDefaultFilters) {
                this.addFilterType(STRING_FILTER_CONTAINS, 20);
                this.addFilterType(STRING_FILTER_NOT_CONTAINS, 25);
                this.addFilterType(STRING_FILTER_REGEXP, 50);
            }
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public void setFilterValue(String value) {
            String string = value = value == null ? value : value.trim();
            if (this.filterValue.equals(value)) {
                return;
            }
            this.filterValue = value;
            this.filterCombo.setText(value);
        }

        @Override
        public String getFilterValue() {
            return this.toLowerCase && this.isCaseInsensitiveFilter() ? this.filterValue.toLowerCase() : this.filterValue;
        }

        private boolean isCaseInsensitiveFilter() {
            return this.filterType == 20 || this.filterType == 25;
        }

        @Override
        public void addFilterType(String name, int type) {
            this.filterTypeNames.add(name);
            this.filterTypes.add(type);
            if (this.filterType == 0) {
                this.setFilterType(type);
            }
        }

        @Override
        public void setFilterType(int type) {
            if (type != 0) {
                this.filterTypeChanged(type);
            }
        }

        @Override
        public int getFilterType() {
            return this.getFilterValue().isEmpty() ? 0 : this.filterType;
        }

        @Override
        public void setFilter(String value, int type) {
            if (this.filterValue.equals(value) && this.filterType == type) {
                return;
            }
            this.suppressEvents = true;
            try {
                this.setFilterType(type);
                this.setFilterValue(value);
            }
            finally {
                this.suppressEvents = false;
            }
            this.fireChange();
        }

        @Override
        public void setHint(String hint) {
            if (this.filterHint != null && this.filterHint.equals(hint)) {
                return;
            }
            this.filterHint = hint;
            this.setHintImpl();
        }

        private void setHintImpl() {
            String type = this.filterTypeNames.get(this.filterTypes.indexOf(this.filterType));
            this.filterCombo.setHint(MessageFormat.format(FILTER_HINT, this.filterHint, type));
        }

        @Override
        public String getHint() {
            return this.filterHint;
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.listeners.remove(listener);
        }

        private void filterValueChanged(String newFilter) {
            if (this.filterValue.equals(newFilter)) {
                return;
            }
            this.filterValue = newFilter;
            this.fireChange();
        }

        private void filterTypeChanged(int newType) {
            if (this.filterType == newType) {
                return;
            }
            this.filterType = newType;
            this.setHintImpl();
            this.fireChange();
        }

        private void fireChange() {
            if (this.suppressEvents) {
                return;
            }
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(event);
            }
        }

        private void submitFilter() {
            String filter = this.filterCombo.getText();
            this.filterCombo.addItem(filter);
            this.filterCombo.setSelectedItem(filter);
        }

        private void clearFilter() {
            this.filterCombo.setSelectedItem(FILTER_EMPTY);
        }

        private void showPopup() {
            JPopupMenu menu = new JPopupMenu();
            for (int i = 0; i < this.filterTypeNames.size(); ++i) {
                final int type = this.filterTypes.get(i);
                JRadioButtonMenuItem m = new JRadioButtonMenuItem(this.filterTypeNames.get(i)){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        Impl.this.setFilterType(type);
                    }
                };
                m.setSelected(type == this.filterType);
                menu.add(m);
            }
            menu.show(this.filterCombo, 0, this.filterCombo.getHeight() - this.filterCombo.getInsets().bottom);
        }

        private static class IconButton
        extends JButton {
            public IconButton(Icon icon) {
                super(icon);
                this.setOpaque(false);
                this.setRolloverEnabled(true);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorderPainted(false);
                this.setContentAreaFilled(false);
                this.setRequestFocusEnabled(false);
                this.setDefaultCapable(false);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        private final class FilterComboEditor
        extends JTextField
        implements ComboBoxEditor {
            private final IconButton filterButton;
            private final IconButton confirmButton;
            private final IconButton clearButton;
            private final JPanel buttonsPanel;
            private final JLabel hintLabel;

            public FilterComboEditor(ComboBoxEditor impl2) {
                this.filterButton = new IconButton(Icons.getIcon((String)"GeneralIcons.Filter")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        Impl.this.showPopup();
                    }

                    @Override
                    public String getToolTipText() {
                        int filterIndex = Impl.this.filterTypes.indexOf(Impl.this.filterType);
                        return filterIndex != -1 ? MessageFormat.format(FILTER_TYPE_TOOLTIP, Impl.this.filterTypeNames.get(filterIndex)) : null;
                    }
                };
                this.filterButton.setRolloverIcon(Icons.getIcon((String)"GeneralIcons.FilterHighl"));
                this.filterButton.setToolTipText(Impl.FILTER_EMPTY);
                this.confirmButton = new IconButton(Icons.getIcon((String)"GeneralIcons.SetFilter")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        Impl.this.submitFilter();
                    }
                };
                this.confirmButton.setRolloverIcon(Icons.getIcon((String)"GeneralIcons.SetFilterHighl"));
                this.confirmButton.setToolTipText(SUBMIT_TOOLTIP);
                this.clearButton = new IconButton(Icons.getIcon((String)"GeneralIcons.ClearFilter")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        Impl.this.clearFilter();
                    }
                };
                this.clearButton.setRolloverIcon(Icons.getIcon((String)"GeneralIcons.ClearFilterHighl"));
                this.clearButton.setToolTipText(CLEAR_TOOLTIP);
                this.buttonsPanel = new JPanel(new BorderLayout(0, 0));
                this.buttonsPanel.setOpaque(false);
                this.buttonsPanel.add((Component)this.confirmButton, "West");
                this.buttonsPanel.add((Component)this.clearButton, "East");
                this.getAccessibleContext().setAccessibleName(ACCESS_NAME);
                this.getAccessibleContext().setAccessibleDescription(ACCESS_DESCR);
                this.setLayout(null);
                this.add(this.filterButton);
                this.add(this.buttonsPanel);
                this.tweakAppearance((JComponent)impl2.getEditorComponent());
                this.hintLabel = new JLabel(){

                    @Override
                    protected void paintBorder(Graphics g) {
                    }
                };
                this.hintLabel.setOpaque(false);
                this.hintLabel.setEnabled(false);
                this.hintLabel.setBorder(this.getBorder());
                this.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        FilterComboEditor.this.textChanged();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        FilterComboEditor.this.textChanged();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        FilterComboEditor.this.textChanged();
                    }
                });
                this.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        FilterComboEditor.this.repaint();
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        FilterComboEditor.this.repaint();
                    }
                });
                this.textChanged();
            }

            private void tweakAppearance(JComponent impl) {
                this.setName("ComboBox.textField");
                if (UIUtils.isNimbusLookAndFeel() || UIUtils.isAquaLookAndFeel()) {
                    this.filterButton.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 4));
                } else if (UIUtils.isWindowsLookAndFeel()) {
                    this.filterButton.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 1));
                } else {
                    this.filterButton.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 2));
                }
                this.confirmButton.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
                this.clearButton.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
                int leftMargin = this.filterButton.getPreferredSize().width + 2;
                if (UIUtils.isGTKLookAndFeel()) {
                    leftMargin -= 4;
                } else if (UIUtils.isAquaLookAndFeel()) {
                    leftMargin -= 8;
                }
                int rightMargin = this.buttonsPanel.getPreferredSize().width + 2;
                if (UIUtils.isAquaLookAndFeel()) {
                    rightMargin += 10;
                } else if (UIUtils.isWindowsLookAndFeel()) {
                    rightMargin -= 2;
                }
                Border margin = BorderFactory.createEmptyBorder(0, leftMargin, 0, rightMargin);
                if (UIUtils.isNimbusLookAndFeel()) {
                    this.setBorder(margin);
                } else {
                    this.setBorder(impl.getBorder());
                    UIUtils.addBorder(this, margin);
                }
                if (UIUtils.isMetalLookAndFeel()) {
                    this.setPreferredSize(impl.getPreferredSize());
                }
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (!this.isFocusOwner() && this.getText().isEmpty()) {
                    this.hintLabel.paint(g);
                }
            }

            @Override
            public void setBounds(int x, int y, int w, int h) {
                int woffset = UIUtils.isAquaLookAndFeel() ? 14 : 0;
                super.setBounds(x, y, w + woffset, h);
                this.hintLabel.setBounds(x, y, w + woffset, h);
            }

            @Override
            public void doLayout() {
                Dimension d = this.filterButton.getPreferredSize();
                this.filterButton.setBounds(0, 0, d.width, this.getHeight());
                int woffset = UIUtils.isAquaLookAndFeel() ? 14 : 0;
                int xoffset = UIUtils.isAquaLookAndFeel() ? 5 + woffset : 0;
                d = this.buttonsPanel.getPreferredSize();
                this.buttonsPanel.setBounds(this.getWidth() - d.width - xoffset, 0, d.width, this.getHeight());
            }

            @Override
            public void processKeyEvent(KeyEvent e) {
                super.processKeyEvent(e);
                if (e.getID() != 401) {
                    return;
                }
                int keyCode = e.getKeyCode();
                if (keyCode == 10) {
                    Impl.this.submitFilter();
                } else if (keyCode == 27) {
                    Impl.this.clearFilter();
                } else if (keyCode == 525 || keyCode == 121 && e.getModifiers() == 1) {
                    Impl.this.showPopup();
                }
            }

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }

            public void setHint(String hint) {
                this.hintLabel.setText(hint);
                this.repaint();
            }

            @Override
            public Component getEditorComponent() {
                return this;
            }

            @Override
            public void setItem(Object anObject) {
                this.setText(anObject == null ? Impl.FILTER_EMPTY : anObject.toString());
            }

            @Override
            public Object getItem() {
                return this.getText();
            }

            @Override
            public void selectAll() {
                super.selectAll();
                this.requestFocus();
            }

            @Override
            public void addActionListener(ActionListener l) {
                super.addActionListener(l);
            }

            @Override
            public void removeActionListener(ActionListener l) {
                super.removeActionListener(l);
            }

            public void textChanged() {
                String text = this.getText();
                this.confirmButton.setVisible(!text.equals(Impl.this.filterValue));
                this.clearButton.setVisible(!text.isEmpty());
            }
        }

        private final class FilterCombo
        extends JComboBox {
            public FilterCombo() {
                super(new DefaultComboBoxModel());
                this.setEditor(new FilterComboEditor(this.getEditor()));
                this.setEditable(true);
            }

            public void setHint(String hint) {
                this.getEditorImpl().setHint(hint);
            }

            public String getText() {
                return this.getEditorImpl().getItem().toString().trim();
            }

            public void setText(String text) {
                this.getEditorImpl().setItem(text);
            }

            @Override
            public void setSelectedItem(final Object newObject) {
                super.setSelectedItem(newObject);
                final FilterComboEditor editorImpl = this.getEditorImpl();
                editorImpl.setItem(newObject);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!FilterCombo.this.isPopupVisible()) {
                            editorImpl.requestFocusInWindow();
                            Impl.this.filterValueChanged(newObject.toString());
                            editorImpl.textChanged();
                        }
                    }
                });
            }

            @Override
            public Object getSelectedItem() {
                Object selected = super.getSelectedItem();
                return selected == null ? Impl.FILTER_EMPTY : selected;
            }

            public void addItem(Object anObject) {
                String item;
                String string = item = anObject == null ? null : anObject.toString();
                if (item == null || item.isEmpty()) {
                    return;
                }
                DefaultComboBoxModel model = this.getModelImpl();
                Object selected = model.getSelectedItem();
                int index = model.getIndexOf(item);
                if (index > 0) {
                    model.removeElement(item);
                }
                if (index != 0) {
                    model.insertElementAt(item, 0);
                }
                model.setSelectedItem(selected);
            }

            public DefaultComboBoxModel getModelImpl() {
                return (DefaultComboBoxModel)super.getModel();
            }

            public FilterComboEditor getEditorImpl() {
                return (FilterComboEditor)super.getEditor();
            }
        }
    }
}

