/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectLookupProvider;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class TemplateAttributesProviderImpl
implements CreateFromTemplateAttributesProvider {
    private final MakeProject project;
    private FileEncodingQueryImplementation encodingQuery;
    private static final Logger LOG = Logger.getLogger(TemplateAttributesProviderImpl.class.getName());

    public TemplateAttributesProviderImpl(MakeProject project) {
        this.project = project;
    }

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        Charset charset;
        String encoding;
        String license;
        HashMap<String, String> values = new HashMap<String, String>();
        Properties priv = this.project.getProjectProperties(false);
        Properties props = this.project.getProjectProperties(true);
        String licensePath = priv.getProperty("project.licensePath");
        if (licensePath == null) {
            licensePath = props.getProperty("project.licensePath");
        }
        if (licensePath != null) {
            FileObject fo = this.project.getHelper().resolveFileObject(licensePath);
            if (fo != null && fo.isValid()) {
                File file = FileUtil.toFile((FileObject)fo);
                if (file == null) {
                    try {
                        file = File.createTempFile("license", ".txt");
                        file.deleteOnExit();
                        try (OutputStream w = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                            int i;
                            InputStream r = fo.getInputStream();
                            while ((i = r.read()) != -1) {
                                w.write(i);
                            }
                            r.close();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (file != null) {
                    values.put("licensePath", file.toURI().toString());
                }
            } else {
                LOG.log(Level.INFO, "project.licensePath value not accepted - " + licensePath);
            }
        }
        if ((license = priv.getProperty("project.license")) == null) {
            license = props.getProperty("project.license");
        }
        if (license != null) {
            values.put("license", license);
        }
        if (this.encodingQuery == null) {
            this.encodingQuery = (FileEncodingQueryImplementation)this.project.getLookup().lookup(FileEncodingQueryImplementation.class);
        }
        String string = encoding = (charset = this.encodingQuery.getEncoding(target.getPrimaryFile())) != null ? charset.name() : null;
        if (encoding != null) {
            values.put("encoding", encoding);
        }
        try {
            ProjectInformation info = ProjectUtils.getInformation((Project)this.project);
            if (info != null) {
                String pdname;
                String pname = info.getName();
                if (pname != null) {
                    values.put("name", pname);
                }
                if ((pdname = info.getDisplayName()) != null) {
                    values.put("displayName", pdname);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateAttributesProviderImpl.class.getName()).log(Level.FINE, "", ex);
        }
        if (values.isEmpty()) {
            return null;
        }
        return Collections.singletonMap("project", values);
    }

    public static class TemplateAttributesProviderFactory
    implements MakeProjectLookupProvider {
        public void addLookup(MakeProject owner, ArrayList<Object> ic) {
            ic.add(new TemplateAttributesProviderImpl(owner));
        }
    }
}

