/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.client.PanelEnabler;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.DynamicCredsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.KerberosConfigPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.StaticCredsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.ValidatorsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.BindingPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.KeystorePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TruststorePanel;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.X509Token;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class CallbackPanel
extends SectionInnerPanel {
    private Node node;
    private Binding binding;
    private boolean inSync = false;
    private Project project;
    private SectionView view;
    private JaxWsModel jaxwsmodel;
    private WSDLModel serviceModel;
    private WsitProvider wsitProvider;
    private boolean jsr109 = false;
    private String profile;
    private DefaultFormatterFactory tstampff = null;
    private ConfigVersion cfgVersion = null;
    private JFormattedTextField cbTimestampField;
    private JLabel cbTimestampLbl;
    private JPanel credPanel;
    private JComboBox credTypeCombo;
    private JLabel credTypeLabel;
    private JCheckBox devDefaultsChBox;
    private JFormattedTextField iterationField;
    private JLabel iterationLabel;
    private JSeparator jSeparator1;
    private JButton kerberosCfgButton;
    private JButton keyStoreButton;
    private JButton samlBrowseButton;
    private JTextField samlHandlerField;
    private JLabel samlHandlerLabel;
    private JButton trustStoreButton;
    private JButton validatorCfgButton;

    public CallbackPanel(SectionView view, Node node, Binding binding, JaxWsModel jaxWsModel, WSDLModel serviceModel) {
        super(view);
        JAXWSLightSupport support;
        this.view = view;
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        this.serviceModel = serviceModel;
        this.cfgVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)binding);
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fo == null && (support = (JAXWSLightSupport)node.getLookup().lookup(JAXWSLightSupport.class)) != null) {
            fo = support.getWsdlFolder(false);
        }
        if (fo == null) {
            throw new IllegalArgumentException("Cannot find corresponding project: " + node);
        }
        this.project = FileOwnerQuery.getOwner((FileObject)fo);
        this.wsitProvider = (WsitProvider)this.project.getLookup().lookup(WsitProvider.class);
        if (this.wsitProvider != null) {
            this.jsr109 = this.wsitProvider.isJsr109Project();
        }
        this.tstampff = new DefaultFormatterFactory();
        NumberFormat timestampFormat = NumberFormat.getIntegerInstance();
        timestampFormat.setGroupingUsed(false);
        timestampFormat.setParseIntegerOnly(true);
        timestampFormat.setMaximumIntegerDigits(8);
        timestampFormat.setMaximumFractionDigits(0);
        NumberFormatter timestampFormatter = new NumberFormatter(timestampFormat);
        timestampFormatter.setCommitsOnValidEdit(true);
        timestampFormatter.setMinimum(Integer.valueOf(0));
        timestampFormatter.setMaximum(Integer.valueOf(99999999));
        this.tstampff.setDefaultFormatter(timestampFormatter);
        this.initComponents();
        this.cbTimestampField.setFocusLostBehavior(1);
        this.inSync = true;
        this.credTypeCombo.removeAllItems();
        this.credTypeCombo.addItem(ComboConstants.STATIC);
        this.credTypeCombo.addItem(ComboConstants.DYNAMIC);
        this.inSync = false;
        this.addImmediateModifier(this.samlHandlerField);
        this.addImmediateModifier(this.credTypeCombo);
        this.addImmediateModifier(this.devDefaultsChBox);
        this.addImmediateModifier(this.cbTimestampField);
        this.addImmediateModifier(this.iterationField);
        this.sync();
    }

    public void sync() {
        String usernameCBH;
        this.inSync = true;
        Binding serviceBinding = PolicyModelHelper.getBinding(this.serviceModel, this.binding.getName());
        this.profile = ProfilesModelHelper.getWSITSecurityProfile((WSDLComponent)serviceBinding);
        boolean defaultsSupported = ProfilesModelHelper.isClientDefaultSetupSupported(this.profile);
        boolean defaults = false;
        if (defaultsSupported) {
            defaults = ProfilesModelHelper.isClientDefaultSetupUsed(this.profile, this.binding, (WSDLComponent)serviceBinding, this.project);
        }
        this.setChBox(this.devDefaultsChBox, defaults);
        String samlCallback = ProprietarySecurityPolicyModelHelper.getCallbackHandler(this.binding, "samlHandler");
        if (samlCallback != null) {
            this.setCallbackHandler(samlCallback);
        }
        if ((usernameCBH = ProprietarySecurityPolicyModelHelper.getCallbackHandler(this.binding, "usernameHandler")) != null && usernameCBH.length() > 0) {
            this.setCredType(ComboConstants.DYNAMIC, defaults);
            this.credTypeCombo.setSelectedItem(ComboConstants.DYNAMIC);
        } else {
            this.setCredType(ComboConstants.STATIC, defaults);
            this.credTypeCombo.setSelectedItem(ComboConstants.STATIC);
        }
        String tsTimeout = ProprietarySecurityPolicyModelHelper.getHandlerTimestampTimeout(this.binding);
        if (tsTimeout == null) {
            this.cbTimestampField.setText("300");
        } else {
            this.cbTimestampField.setText(tsTimeout);
        }
        String iterations = ProprietarySecurityPolicyModelHelper.getHandlerIterations(this.binding);
        if (iterations == null) {
            this.iterationField.setText("1000");
        } else {
            this.iterationField.setText(iterations);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void setChBox(JCheckBox chBox, Boolean enable) {
        if (enable == null) {
            chBox.setSelected(false);
        } else {
            chBox.setSelected(enable);
        }
    }

    private JPanel getPanel(String type, boolean defaults) {
        boolean amSec = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        if (ComboConstants.DYNAMIC.equals(type)) {
            return new DynamicCredsPanel(this.binding, this.project, !amSec && !defaults);
        }
        return new StaticCredsPanel(this.binding, !amSec && !defaults);
    }

    private void setCredType(String credType, boolean defaults) {
        this.remove(this.credPanel);
        this.credPanel = this.getPanel(credType, defaults);
        boolean active = true;
        if (this.view != null) {
            NodeSectionPanel panel = this.view.getActivePanel();
            active = panel == null ? false : panel.isActive();
        }
        this.refreshLayout();
    }

    public void setValue(JComponent source, Object value) {
        if (this.inSync) {
            return;
        }
        Util.checkMetroLibrary(this.project);
        if (source.equals(this.credTypeCombo)) {
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "usernameHandler", null, null, true);
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "passwordHandler", null, null, true);
            this.setCredType((String)this.credTypeCombo.getSelectedItem(), this.devDefaultsChBox.isSelected());
        }
        if (source.equals(this.samlHandlerField)) {
            String classname = this.getCallbackHandler();
            if (classname != null && classname.length() == 0) {
                classname = null;
            }
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "samlHandler", classname, null, true);
            return;
        }
        if (source.equals(this.iterationField)) {
            Long iterations = (Long)this.iterationField.getValue();
            if (iterations == null || iterations.toString().length() == 0) {
                ProprietarySecurityPolicyModelHelper.setHandlerIterations(this.binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setHandlerIterations(this.binding, iterations.toString(), true);
            }
        }
        if (source.equals(this.cbTimestampField)) {
            String timeout = ((Integer)this.cbTimestampField.getValue()).toString();
            if (timeout == null || timeout.length() == 0 || "300".equals(timeout.toString())) {
                ProprietarySecurityPolicyModelHelper.setHandlerTimestampTimeout(this.binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setHandlerTimestampTimeout(this.binding, timeout, true);
            }
        }
        if (source.equals(this.devDefaultsChBox)) {
            if (this.devDefaultsChBox.isSelected()) {
                DefaultSettings.fillDefaults(this.project, true, true);
                Binding serviceBinding = PolicyModelHelper.getBinding(this.serviceModel, this.binding.getName());
                ProfilesModelHelper.setClientDefaults(this.profile, this.binding, (WSDLComponent)serviceBinding, this.project);
                this.sync();
                this.refreshLayout();
                ((PanelEnabler)((Object)this.credPanel)).enablePanel(false);
                this.credPanel.revalidate();
                this.credPanel.repaint();
            } else {
                ((PanelEnabler)((Object)this.credPanel)).enablePanel(true);
            }
        }
        this.enableDisable();
    }

    public void documentChanged(JTextComponent comp, String value) {
        this.enableDisable();
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    private void enableDisable() {
        boolean amSec = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        boolean samlRequired = true;
        boolean authRequired = true;
        if (!amSec) {
            Component[] comps;
            boolean validatorsConfigRequired;
            this.devDefaultsChBox.setEnabled(true);
            boolean defaults = this.devDefaultsChBox.isSelected();
            boolean trustStoreConfigRequired = true;
            boolean keyStoreConfigRequired = true;
            boolean kerberosConfigRequired = false;
            boolean bl = validatorsConfigRequired = ConfigVersion.CONFIG_1_0 == this.cfgVersion;
            if (ComboConstants.PROF_USERNAME.equals(this.profile)) {
                keyStoreConfigRequired = false;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(this.profile)) {
                trustStoreConfigRequired = false;
            }
            if (ComboConstants.PROF_KERBEROS.equals(this.profile)) {
                trustStoreConfigRequired = false;
                keyStoreConfigRequired = false;
                kerberosConfigRequired = true;
            }
            this.keyStoreButton.setEnabled(keyStoreConfigRequired && !defaults);
            this.trustStoreButton.setEnabled(trustStoreConfigRequired && !defaults);
            this.kerberosCfgButton.setEnabled(kerberosConfigRequired && !defaults);
            this.validatorCfgButton.setEnabled(validatorsConfigRequired && !defaults);
            if (ComboConstants.PROF_USERNAME.equals(this.profile) || ComboConstants.PROF_STSISSUED.equals(this.profile) || ComboConstants.PROF_STSISSUEDENDORSE.equals(this.profile) || ComboConstants.PROF_STSISSUEDCERT.equals(this.profile) || ComboConstants.PROF_STSISSUEDSUPPORTING.equals(this.profile) || ComboConstants.PROF_MSGAUTHSSL.equals(this.profile)) {
                samlRequired = false;
            }
            if (ComboConstants.PROF_SAMLSSL.equals(this.profile) || ComboConstants.PROF_SAMLHOLDER.equals(this.profile) || ComboConstants.PROF_SAMLSENDER.equals(this.profile)) {
                authRequired = false;
            }
            this.credTypeLabel.setEnabled(authRequired && !defaults);
            this.credTypeCombo.setEnabled(authRequired && !defaults);
            this.credPanel.setEnabled(authRequired && !defaults);
            for (Component c : comps = this.credPanel.getComponents()) {
                c.setEnabled(authRequired && !defaults);
            }
            this.samlBrowseButton.setEnabled(samlRequired && !defaults);
            this.samlHandlerField.setEnabled(samlRequired && !defaults);
            this.samlHandlerLabel.setEnabled(samlRequired && !defaults);
            this.cbTimestampField.setEnabled(!defaults);
            this.cbTimestampLbl.setEnabled(!defaults);
            this.iterationField.setEnabled(!defaults);
            this.iterationLabel.setEnabled(!defaults);
        } else {
            Component[] comps;
            this.credPanel.setEnabled(false);
            for (Component c : comps = this.credPanel.getComponents()) {
                c.setEnabled(false);
            }
            this.credTypeCombo.setEnabled(false);
            this.credTypeLabel.setEnabled(false);
            this.devDefaultsChBox.setEnabled(false);
            this.validatorCfgButton.setEnabled(false);
            this.jSeparator1.setEnabled(false);
            this.keyStoreButton.setEnabled(false);
            this.samlBrowseButton.setEnabled(false);
            this.samlHandlerField.setEnabled(false);
            this.samlHandlerLabel.setEnabled(false);
            this.trustStoreButton.setEnabled(false);
        }
        this.refreshLayout();
    }

    public static boolean isStoreConfigRequired(String profile, boolean trust, Binding binding) {
        ArrayList<Object> compsToTry = new ArrayList<Object>();
        compsToTry.add(binding);
        Collection ops = binding.getBindingOperations();
        for (BindingOperation bindingOperation : ops) {
            BindingOutput bo;
            BindingInput bi = bindingOperation.getBindingInput();
            if (bi != null) {
                compsToTry.add(bi);
            }
            if ((bo = bindingOperation.getBindingOutput()) != null) {
                compsToTry.add(bo);
            }
            Collection bfs = bindingOperation.getBindingFaults();
            for (BindingFault bf : bfs) {
                if (bf == null) continue;
                compsToTry.add(bf);
            }
        }
        for (WSDLComponent wSDLComponent : compsToTry) {
            List<WSDLComponent> suppTokens = SecurityTokensModelHelper.getSupportingTokens(wSDLComponent);
            if (suppTokens == null) continue;
            for (WSDLComponent suppToken : suppTokens) {
                WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(suppToken);
                if (!(token instanceof X509Token)) continue;
                return true;
            }
        }
        if (ComboConstants.PROF_TRANSPORT.equals(profile) || ComboConstants.PROF_SAMLSSL.equals(profile)) {
            return false;
        }
        if (!trust) {
            if (ComboConstants.PROF_USERNAME.equals(profile)) {
                return false;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) {
                // empty if block
            }
        } else if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) {
            return false;
        }
        return true;
    }

    private void setCallbackHandler(String classname) {
        this.samlHandlerField.setText(classname);
    }

    private String getCallbackHandler() {
        return this.samlHandlerField.getText();
    }

    private void refreshLayout() {
        GroupLayout layout = (GroupLayout)this.getLayout();
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.keyStoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trustStoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kerberosCfgButton).addGap(6, 6, 6).addComponent(this.validatorCfgButton)).addComponent(this.devDefaultsChBox)).addGap(62, 62, 62)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.credTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credTypeCombo, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.credPanel, GroupLayout.Alignment.LEADING, -2, -1, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbTimestampLbl).addComponent(this.samlHandlerLabel).addComponent(this.iterationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iterationField, -2, 78, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.samlHandlerField, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.samlBrowseButton)).addComponent(this.cbTimestampField, -2, 78, -2))))).addComponent(this.jSeparator1, -1, 549, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.kerberosCfgButton, this.keyStoreButton, this.trustStoreButton, this.validatorCfgButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.devDefaultsChBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyStoreButton).addComponent(this.trustStoreButton).addComponent(this.kerberosCfgButton).addComponent(this.validatorCfgButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.credTypeLabel).addComponent(this.credTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.samlBrowseButton).addComponent(this.samlHandlerField, -2, -1, -2).addComponent(this.samlHandlerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTimestampField, -2, -1, -2).addComponent(this.cbTimestampLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iterationLabel).addComponent(this.iterationField, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.kerberosCfgButton, this.keyStoreButton, this.trustStoreButton, this.validatorCfgButton);
        this.samlHandlerLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSN"));
        this.samlHandlerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSD"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSN"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSD"));
        this.credTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSN"));
        this.credTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSD"));
        this.keyStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSN"));
        this.keyStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSD"));
        this.trustStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSN"));
        this.trustStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSD"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSN"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSD"));
    }

    private void initComponents() {
        this.samlHandlerLabel = new JLabel();
        this.samlHandlerField = new JTextField();
        this.samlBrowseButton = new JButton();
        this.credTypeCombo = new JComboBox();
        this.credTypeLabel = new JLabel();
        this.credPanel = new JPanel();
        this.keyStoreButton = new JButton();
        this.trustStoreButton = new JButton();
        this.devDefaultsChBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.cbTimestampLbl = new JLabel();
        this.cbTimestampField = new JFormattedTextField();
        this.kerberosCfgButton = new JButton();
        this.validatorCfgButton = new JButton();
        this.iterationLabel = new JLabel();
        this.iterationField = new JFormattedTextField();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CallbackPanel.this.formFocusGained(evt);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                CallbackPanel.this.formAncestorAdded(evt);
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.samlHandlerLabel.setLabelFor(this.samlHandlerField);
        Mnemonics.setLocalizedText((JLabel)this.samlHandlerLabel, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.samlBrowseButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton"));
        this.samlBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallbackPanel.this.samlBrowseButtonActionPerformed(evt);
            }
        });
        this.credTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Static", "Dynamic"}));
        this.credTypeLabel.setLabelFor(this.credTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.credTypeLabel, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel"));
        GroupLayout credPanelLayout = new GroupLayout(this.credPanel);
        this.credPanel.setLayout(credPanelLayout);
        credPanelLayout.setHorizontalGroup(credPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 424, Short.MAX_VALUE));
        credPanelLayout.setVerticalGroup(credPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 64, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.keyStoreButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore"));
        this.keyStoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallbackPanel.this.keyStoreButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.trustStoreButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore"));
        this.trustStoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallbackPanel.this.trustStoreButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.devDefaultsChBox, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults"));
        Mnemonics.setLocalizedText((JLabel)this.cbTimestampLbl, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_CallbackPanel_Timestamp"));
        this.cbTimestampField.setFormatterFactory(this.tstampff);
        Mnemonics.setLocalizedText((AbstractButton)this.kerberosCfgButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KerberosCfg"));
        this.kerberosCfgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallbackPanel.this.kerberosCfgButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.validatorCfgButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_ValidatorsCfg"));
        this.validatorCfgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallbackPanel.this.validatorCfgButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.iterationLabel, (String)"Key Obtention Iterations:");
        this.iterationField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.iterationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallbackPanel.this.iterationFieldActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.keyStoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trustStoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kerberosCfgButton).addGap(6, 6, 6).addComponent(this.validatorCfgButton)).addComponent(this.devDefaultsChBox)).addGap(62, 62, 62)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.credTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credTypeCombo, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.credPanel, GroupLayout.Alignment.LEADING, -2, -1, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbTimestampLbl).addComponent(this.samlHandlerLabel).addComponent(this.iterationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iterationField, -2, 78, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.samlHandlerField, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.samlBrowseButton)).addComponent(this.cbTimestampField, -2, 78, -2))))).addComponent(this.jSeparator1, -1, 572, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.kerberosCfgButton, this.keyStoreButton, this.trustStoreButton, this.validatorCfgButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.devDefaultsChBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyStoreButton).addComponent(this.trustStoreButton).addComponent(this.kerberosCfgButton).addComponent(this.validatorCfgButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.credTypeLabel).addComponent(this.credTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.samlBrowseButton).addComponent(this.samlHandlerField, -2, -1, -2).addComponent(this.samlHandlerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTimestampField, -2, -1, -2).addComponent(this.cbTimestampLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iterationLabel).addComponent(this.iterationField, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.kerberosCfgButton, this.keyStoreButton, this.trustStoreButton, this.validatorCfgButton);
        this.samlHandlerLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSN"));
        this.samlHandlerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSD"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSN"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSD"));
        this.credTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSN"));
        this.credTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSD"));
        this.keyStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSN"));
        this.keyStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSD"));
        this.trustStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSN"));
        this.trustStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSD"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSN"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSD"));
    }

    private void trustStoreButtonActionPerformed(ActionEvent evt) {
        TruststorePanel storePanel = new TruststorePanel((WSDLComponent)this.binding, this.project, this.jsr109, this.profile, true, this.cfgVersion);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)storePanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_Truststore_Panel_Title"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.OK_OPTION) {
            storePanel.storeState();
        }
    }

    private void keyStoreButtonActionPerformed(ActionEvent evt) {
        KeystorePanel storePanel = new KeystorePanel((WSDLComponent)this.binding, this.project, this.jsr109, true, this.cfgVersion);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)storePanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_Keystore_Panel_Title"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.OK_OPTION) {
            storePanel.storeState();
        }
    }

    private void formFocusGained(FocusEvent evt) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent evt) {
        this.enableDisable();
    }

    private void samlBrowseButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> iterator;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "javax.security.auth.callback.CallbackHandler");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = iterator.next();
                this.setCallbackHandler(selectedClass);
                ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "samlHandler", selectedClass, null, true);
            }
        }
    }

    private void kerberosCfgButtonActionPerformed(ActionEvent evt) {
        KerberosConfigPanel panel = new KerberosConfigPanel((WSDLComponent)this.binding, this.project);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_KerberosConfig_Panel_Title"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.OK_OPTION) {
            panel.storeState();
        }
    }

    private void validatorCfgButtonActionPerformed(ActionEvent evt) {
        ValidatorsPanel panel = new ValidatorsPanel((WSDLComponent)this.binding, this.project);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_KerberosConfig_Panel_Title"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.OK_OPTION) {
            panel.storeState();
        }
    }

    private void iterationFieldActionPerformed(ActionEvent evt) {
    }
}

