/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.file;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.web.clientproject.api.json.JsonFile;
import org.openide.filesystems.FileObject;

public final class PackageJson {
    public static final String FILE_NAME = "package.json";
    public static final String PROP_NAME = "NAME";
    public static final String PROP_SCRIPTS_START = "SCRIPTS_START";
    public static final String PROP_DEPENDENCIES = "DEPENDENCIES";
    public static final String PROP_DEV_DEPENDENCIES = "DEV_DEPENDENCIES";
    public static final String PROP_PEER_DEPENDENCIES = "PEER_DEPENDENCIES";
    public static final String PROP_OPTIONAL_DEPENDENCIES = "OPTIONAL_DEPENDENCIES";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_MAIN = "main";
    public static final String FIELD_SCRIPTS = "scripts";
    public static final String FIELD_START = "start";
    public static final String FIELD_ENGINES = "engines";
    public static final String FIELD_NODE = "node";
    public static final String FIELD_DEPENDENCIES = "dependencies";
    public static final String FIELD_DEV_DEPENDENCIES = "devDependencies";
    public static final String FIELD_PEER_DEPENDENCIES = "peerDependencies";
    public static final String FIELD_OPTIONAL_DEPENDENCIES = "optionalDependencies";
    public static final String NODE_MODULES_DIR = "node_modules";
    private final JsonFile packageJson;

    public PackageJson(FileObject directory) {
        this(directory, FILE_NAME);
    }

    PackageJson(FileObject directory, String filename) {
        assert (directory != null);
        this.packageJson = new JsonFile(filename, directory, JsonFile.WatchedFields.create().add(PROP_NAME, new String[]{FIELD_NAME}).add(PROP_SCRIPTS_START, new String[]{FIELD_SCRIPTS, FIELD_START}).add(PROP_DEPENDENCIES, new String[]{FIELD_DEPENDENCIES}).add(PROP_DEV_DEPENDENCIES, new String[]{FIELD_DEV_DEPENDENCIES}).add(PROP_PEER_DEPENDENCIES, new String[]{FIELD_PEER_DEPENDENCIES}).add(PROP_OPTIONAL_DEPENDENCIES, new String[]{FIELD_OPTIONAL_DEPENDENCIES}));
    }

    public boolean exists() {
        return this.packageJson.exists();
    }

    public String getPath() {
        return this.packageJson.getPath();
    }

    public File getFile() {
        return this.packageJson.getFile();
    }

    public File getNodeModulesDir() {
        return new File(this.packageJson.getFile().getParentFile(), NODE_MODULES_DIR);
    }

    @CheckForNull
    public Map<String, Object> getContent() {
        return this.packageJson.getContent();
    }

    @CheckForNull
    public <T> T getContentValue(Class<T> valueType, String ... fieldHierarchy) {
        return (T)this.packageJson.getContentValue(valueType, fieldHierarchy);
    }

    public void setContent(List<String> fieldHierarchy, Object value) throws IOException {
        this.packageJson.setContent(fieldHierarchy, value);
    }

    public void addPropertyChangeListener(PropertyChangeListener packageJsonListener) {
        this.packageJson.addPropertyChangeListener(packageJsonListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener packageJsonListener) {
        this.packageJson.removePropertyChangeListener(packageJsonListener);
    }

    public void cleanup() {
        this.packageJson.cleanup();
    }

    public void refresh() {
        this.packageJson.refresh();
    }

    public NpmDependencies getDependencies() {
        Map dependencies = this.getContentValue(Map.class, FIELD_DEPENDENCIES);
        Map devDependencies = this.getContentValue(Map.class, FIELD_DEV_DEPENDENCIES);
        Map peerDependencies = this.getContentValue(Map.class, FIELD_PEER_DEPENDENCIES);
        Map optionalDependencies = this.getContentValue(Map.class, FIELD_OPTIONAL_DEPENDENCIES);
        return new NpmDependencies(this.sanitizeDependencies(dependencies), this.sanitizeDependencies(devDependencies), this.sanitizeDependencies(peerDependencies), this.sanitizeDependencies(optionalDependencies));
    }

    @CheckForNull
    private Map<String, String> sanitizeDependencies(@NullAllowed Map<Object, Object> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        HashMap<String, String> sanitized = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            sanitized.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return sanitized;
    }

    public static final class NpmDependencies {
        public final Map<String, String> dependencies = new ConcurrentHashMap<String, String>();
        public final Map<String, String> devDependencies = new ConcurrentHashMap<String, String>();
        public final Map<String, String> peerDependencies = new ConcurrentHashMap<String, String>();
        public final Map<String, String> optionalDependencies = new ConcurrentHashMap<String, String>();

        NpmDependencies(@NullAllowed Map<String, String> dependencies, @NullAllowed Map<String, String> devDependencies, @NullAllowed Map<String, String> peerDependencies, @NullAllowed Map<String, String> optionalDependencies) {
            if (dependencies != null) {
                this.dependencies.putAll(dependencies);
            }
            if (devDependencies != null) {
                this.devDependencies.putAll(devDependencies);
            }
            if (peerDependencies != null) {
                this.peerDependencies.putAll(peerDependencies);
            }
            if (optionalDependencies != null) {
                this.optionalDependencies.putAll(optionalDependencies);
            }
        }

        public boolean isEmpty() {
            return this.dependencies.isEmpty() && this.devDependencies.isEmpty() && this.peerDependencies.isEmpty() && this.optionalDependencies.isEmpty();
        }

        public int getCount() {
            return this.dependencies.size() + this.devDependencies.size() + this.peerDependencies.size() + this.optionalDependencies.size();
        }
    }
}

