/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.SanitizerKind;
import org.clang.basic.SanitizerSet;
import org.clang.driver.Driver;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.SanitizerArgsStatics;
import org.clang.driver.options;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.SpecialCaseList;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;

public class SanitizerArgs
implements Destructors.ClassWithDestructor {
    private SanitizerSet Sanitizers;
    private SanitizerSet RecoverableSanitizers;
    private SanitizerSet TrapSanitizers;
    private std.vectorString BlacklistFiles;
    private std.vectorString ExtraDeps;
    private int CoverageFeatures;
    private int MsanTrackOrigins;
    private boolean MsanUseAfterDtor;
    private boolean CfiCrossDso;
    private int AsanFieldPadding;
    private boolean AsanSharedRuntime;
    private boolean AsanUseAfterScope;
    private boolean LinkCXXRuntimes;
    private boolean NeedPIE;
    private boolean Stats;
    private final int.ref MsanTrackOrigins$Ref;
    private final int.ref AsanFieldPadding$Ref;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SanitizerArgs(ToolChain TC, ArgList Args) {
        JavaCleaner $c$;
        JavaCleaner $c$2;
        long RecoverableKinds;
        long TrappingKinds;
        Driver D;
        long Kinds;
        long AllAddedKinds;
        block142: {
            std_pair.pairULongULong[] IncompatibleGroups;
            this.MsanTrackOrigins$Ref = new int.ref(){

                public int $deref() {
                    return SanitizerArgs.this.MsanTrackOrigins;
                }

                public int $set(int value) {
                    SanitizerArgs.this.MsanTrackOrigins = value;
                    return value;
                }
            };
            this.AsanFieldPadding$Ref = new int.ref(){

                public int $deref() {
                    return SanitizerArgs.this.AsanFieldPadding;
                }

                public int $set(int value) {
                    SanitizerArgs.this.AsanFieldPadding = value;
                    return value;
                }
            };
            this.Sanitizers = new SanitizerSet();
            this.RecoverableSanitizers = new SanitizerSet();
            this.TrapSanitizers = new SanitizerSet();
            this.BlacklistFiles = new std.vectorString(std.string.EMPTY);
            this.ExtraDeps = new std.vectorString(std.string.EMPTY);
            this.CoverageFeatures = 0;
            this.MsanTrackOrigins = 0;
            this.MsanUseAfterDtor = false;
            this.CfiCrossDso = false;
            this.AsanFieldPadding = 0;
            this.AsanSharedRuntime = false;
            this.AsanUseAfterScope = false;
            this.LinkCXXRuntimes = false;
            this.NeedPIE = false;
            this.Stats = false;
            long AllRemove = 0L;
            AllAddedKinds = 0L;
            long DiagnosedKinds = 0L;
            Kinds = 0L;
            long Supported = SanitizerArgsStatics.setGroupBits(TC.getSupportedSanitizers());
            ToolChain.RTTIMode RTTIMode2 = TC.getRTTIMode();
            D = TC.getDriver();
            TrappingKinds = SanitizerArgsStatics.parseSanitizeTrapArgs(D, Args);
            long InvalidTrappingKinds = TrappingKinds & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.NotAllowedWithTrap.getValue();
            std.reverse_iterator I = Args.rbegin();
            std_pair.pairULongULong[] E = Args.rend();
            while (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)I, (abstract_iterator)E)) {
                Arg Arg2 = (Arg)I.$star();
                if (Arg2.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_EQ.getValue()))) {
                    std.string Desc;
                    JavaCleaner $c$3;
                    Arg2.claim();
                    long Add = SanitizerArgsStatics.parseArgValues(D, Arg2, true);
                    AllAddedKinds |= BasicClangGlobals.expandSanitizerGroups((long)Add);
                    long KindsToDiagnose = (Add &= AllRemove ^ 0xFFFFFFFFFFFFFFFFL) & InvalidTrappingKinds & (DiagnosedKinds ^ 0xFFFFFFFFFFFFFFFFL);
                    if (KindsToDiagnose != 0L) {
                        $c$3 = Native.$createJavaCleaner();
                        try {
                            Desc = SanitizerArgsStatics.describeSanitizeArg((Arg)I.$star(), KindsToDiagnose);
                            $c$3.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$3.track((Object)D.Diag(306))), (StringRef)new StringRef(Desc)), (String)"-fsanitize-trap=undefined"));
                            DiagnosedKinds |= KindsToDiagnose;
                        }
                        finally {
                            $c$3.$destroy();
                        }
                    }
                    if ((KindsToDiagnose = (Add &= InvalidTrappingKinds ^ 0xFFFFFFFFFFFFFFFFL) & (Supported ^ 0xFFFFFFFFFFFFFFFFL) & (DiagnosedKinds ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                        $c$3 = Native.$createJavaCleaner();
                        try {
                            Desc = SanitizerArgsStatics.describeSanitizeArg((Arg)I.$star(), KindsToDiagnose);
                            $c$3.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$3.track((Object)D.Diag(365))), (StringRef)new StringRef(Desc)), (StringRef)new StringRef(TC.getTriple().str())));
                            DiagnosedKinds |= KindsToDiagnose;
                        }
                        finally {
                            $c$3.$destroy();
                        }
                    }
                    if (((Add &= Supported) & SanitizerKind.Vptr) != 0L && (RTTIMode2 == ToolChain.RTTIMode.RM_DisabledImplicitly || RTTIMode2 == ToolChain.RTTIMode.RM_DisabledExplicitly)) {
                        JavaCleaner $c$4;
                        if (RTTIMode2 == ToolChain.RTTIMode.RM_DisabledImplicitly) {
                            $c$4 = Native.$createJavaCleaner();
                            try {
                                $c$4.clean($c$4.track((Object)D.Diag(383)));
                            }
                            finally {
                                $c$4.$destroy();
                            }
                        }
                        $c$4 = Native.$createJavaCleaner();
                        try {
                            Arg NoRTTIArg = TC.getRTTIArg();
                            assert (NoRTTIArg != null) : "RTTI disabled explicitly but we have no argument!";
                            $c$4.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$4.track((Object)D.Diag(306))), (String)"-fsanitize=vptr"), (StringRef)new StringRef(NoRTTIArg.getAsString(Args))));
                        }
                        finally {
                            $c$4.$destroy();
                        }
                        AllRemove |= SanitizerKind.Vptr;
                    }
                    Add = BasicClangGlobals.expandSanitizerGroups((long)Add);
                    Add &= AllRemove ^ 0xFFFFFFFFFFFFFFFFL;
                    Add &= InvalidTrappingKinds ^ 0xFFFFFFFFFFFFFFFFL;
                    Kinds |= (Add &= Supported);
                } else if (Arg2.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_EQ.getValue()))) {
                    Arg2.claim();
                    long Remove = SanitizerArgsStatics.parseArgValues(D, Arg2, true);
                    AllRemove |= BasicClangGlobals.expandSanitizerGroups((long)Remove);
                }
                I.$preInc();
            }
            if (((Kinds |= TC.getDefaultSanitizers() & (AllRemove ^ 0xFFFFFFFFFFFFFFFFL)) & SanitizerKind.Vptr) != 0L && (RTTIMode2 == ToolChain.RTTIMode.RM_DisabledImplicitly || RTTIMode2 == ToolChain.RTTIMode.RM_DisabledExplicitly)) {
                Kinds &= SanitizerKind.Vptr ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((Kinds & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.NeedsLTO.getValue()) != 0L && !D.isUsingLTO()) {
                JavaCleaner $c$5 = Native.$createJavaCleaner();
                try {
                    $c$5.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$5.track((Object)D.Diag(307))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForMask(D, Args, Kinds & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.NeedsLTO.getValue()))), (String)"-flto"));
                }
                finally {
                    $c$5.$destroy();
                }
            }
            if (((Supported ^ 0xFFFFFFFFFFFFFFFFL) & SanitizerKind.Vptr) != 0L) {
                long KindsToDiagnose = Kinds & (TrappingKinds ^ 0xFFFFFFFFFFFFFFFFL) & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.NeedsUbsanCxxRt.getValue();
                if (TC.getTriple().isOSWindows()) {
                    KindsToDiagnose &= SanitizerKind.CFI ^ 0xFFFFFFFFFFFFFFFFL;
                }
                if (KindsToDiagnose != 0L) {
                    JavaCleaner $c$6 = Native.$createJavaCleaner();
                    try {
                        SanitizerSet S = new SanitizerSet();
                        S.Mask = KindsToDiagnose;
                        $c$6.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$6.track((Object)D.Diag(365))), (StringRef)new StringRef(std.$add_T_string((String)"-fno-sanitize-trap=", (std.string)SanitizerArgsStatics.__toString(S)))), (StringRef)new StringRef(TC.getTriple().str())));
                        Kinds &= KindsToDiagnose ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    finally {
                        $c$6.$destroy();
                    }
                }
            }
            for (std_pair.pairULongULong G : IncompatibleGroups = new std_pair.pairULongULong[]{std.make_pair_ullong_ullong((long)SanitizerKind.Address, (long)SanitizerKind.Thread), std.make_pair_ullong_ullong((long)SanitizerKind.Address, (long)SanitizerKind.Memory), std.make_pair_ullong_ullong((long)SanitizerKind.Thread, (long)SanitizerKind.Memory), std.make_pair_ullong_ullong((long)SanitizerKind.Leak, (long)SanitizerKind.Thread), std.make_pair_ullong_ullong((long)SanitizerKind.Leak, (long)SanitizerKind.Memory), std.make_pair_ullong_ullong((long)SanitizerKind.KernelAddress, (long)SanitizerKind.Address), std.make_pair_ullong_ullong((long)SanitizerKind.KernelAddress, (long)SanitizerKind.Leak), std.make_pair_ullong_ullong((long)SanitizerKind.KernelAddress, (long)SanitizerKind.Thread), std.make_pair_ullong_ullong((long)SanitizerKind.KernelAddress, (long)SanitizerKind.Memory), std.make_pair_ullong_ullong((long)SanitizerKind.Efficiency, (long)SanitizerKind.Address), std.make_pair_ullong_ullong((long)SanitizerKind.Efficiency, (long)SanitizerKind.Leak), std.make_pair_ullong_ullong((long)SanitizerKind.Efficiency, (long)SanitizerKind.Thread), std.make_pair_ullong_ullong((long)SanitizerKind.Efficiency, (long)SanitizerKind.Memory), std.make_pair_ullong_ullong((long)SanitizerKind.Efficiency, (long)SanitizerKind.KernelAddress)}) {
                long Incompatible;
                long Group = G.first;
                if ((Kinds & Group) == 0L || (Incompatible = Kinds & G.second) == 0L) continue;
                JavaCleaner $c$7 = Native.$createJavaCleaner();
                try {
                    $c$7.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$7.track((Object)D.Diag(306))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForMask(D, Args, Group))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForMask(D, Args, Incompatible))));
                    Kinds &= Incompatible ^ 0xFFFFFFFFFFFFFFFFL;
                }
                finally {
                    $c$7.$destroy();
                }
            }
            RecoverableKinds = SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.RecoverableByDefault.getValue();
            long DiagnosedUnrecoverableKinds = 0L;
            for (Arg Arg3 : Args) {
                char.ptr DeprecatedReplacement = null;
                if (Arg3.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_recover.getValue()))) {
                    DeprecatedReplacement = Native.$tryClone((char.ptr)NativePointer.$((String)"-fsanitize-recover=undefined,integer' or '-fsanitize-recover=all"));
                    RecoverableKinds |= BasicClangGlobals.expandSanitizerGroups((long)SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.LegacyFsanitizeRecoverMask.getValue());
                    Arg3.claim();
                } else if (Arg3.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_recover.getValue()))) {
                    DeprecatedReplacement = Native.$tryClone((char.ptr)NativePointer.$((String)"-fno-sanitize-recover=undefined,integer' or '-fno-sanitize-recover=all"));
                    RecoverableKinds &= BasicClangGlobals.expandSanitizerGroups((long)SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.LegacyFsanitizeRecoverMask.getValue()) ^ 0xFFFFFFFFFFFFFFFFL;
                    Arg3.claim();
                } else if (Arg3.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_recover_EQ.getValue()))) {
                    long Add = SanitizerArgsStatics.parseArgValues(D, Arg3, true);
                    long KindsToDiagnose = Add & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.Unrecoverable.getValue() & (DiagnosedUnrecoverableKinds ^ 0xFFFFFFFFFFFFFFFFL);
                    if (KindsToDiagnose != 0L) {
                        JavaCleaner $c$8 = Native.$createJavaCleaner();
                        try {
                            SanitizerSet SetToDiagnose = new SanitizerSet();
                            SetToDiagnose.Mask |= KindsToDiagnose;
                            $c$8.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$8.track((Object)D.Diag(366))), (StringRef)Arg3.getOption().getName()), (StringRef)new StringRef(SanitizerArgsStatics.__toString(SetToDiagnose))));
                            DiagnosedUnrecoverableKinds |= KindsToDiagnose;
                        }
                        finally {
                            $c$8.$destroy();
                        }
                    }
                    RecoverableKinds |= BasicClangGlobals.expandSanitizerGroups((long)Add);
                    Arg3.claim();
                } else if (Arg3.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_recover_EQ.getValue()))) {
                    RecoverableKinds &= BasicClangGlobals.expandSanitizerGroups((long)SanitizerArgsStatics.parseArgValues(D, Arg3, true)) ^ 0xFFFFFFFFFFFFFFFFL;
                    Arg3.claim();
                }
                if (DeprecatedReplacement == null) continue;
                JavaCleaner $c$9 = Native.$createJavaCleaner();
                try {
                    $c$9.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$9.track((Object)D.Diag(382))), (StringRef)new StringRef(Arg3.getAsString(Args))), (char.ptr)DeprecatedReplacement));
                }
                finally {
                    $c$9.$destroy();
                }
            }
            RecoverableKinds &= Kinds;
            RecoverableKinds &= SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.Unrecoverable.getValue() ^ 0xFFFFFFFFFFFFFFFFL;
            TrappingKinds &= Kinds;
            std.string BLPath = new std.string();
            if (SanitizerArgsStatics.getDefaultBlacklist(D, Kinds, BLPath) && fs.exists((Twine)new Twine(BLPath))) {
                this.BlacklistFiles.push_back(BLPath);
            }
            for (Arg Arg3 : Args) {
                if (Arg3.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_blacklist.getValue()))) {
                    Arg3.claim();
                    std.string BLPath2 = new std.string(Arg3.getValue());
                    if (fs.exists((Twine)new Twine(BLPath2))) {
                        this.BlacklistFiles.push_back(BLPath2);
                        this.ExtraDeps.push_back(BLPath2);
                        continue;
                    }
                    JavaCleaner $c$10 = Native.$createJavaCleaner();
                    try {
                        $c$10.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$10.track((Object)D.Diag(349))), (StringRef)new StringRef(BLPath2)));
                        continue;
                    }
                    finally {
                        $c$10.$destroy();
                        continue;
                    }
                }
                if (!Arg3.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_blacklist.getValue()))) continue;
                Arg3.claim();
                this.BlacklistFiles.clear();
                this.ExtraDeps.clear();
            }
            std_ptr.unique_ptr SCL = null;
            try {
                std.string BLError = new std.string();
                SCL = SpecialCaseList.create((std.vectorString)this.BlacklistFiles, (std.string)BLError);
                if (SCL.get() != null) break block142;
                JavaCleaner $c$11 = Native.$createJavaCleaner();
                try {
                    $c$11.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$11.track((Object)D.Diag(339))), (StringRef)new StringRef(BLError)));
                }
                finally {
                    $c$11.$destroy();
                }
            }
            finally {
                if (SCL != null) {
                    SCL.$destroy();
                }
            }
        }
        if ((AllAddedKinds & SanitizerKind.Memory) != 0L) {
            Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_fsanitize_memory_track_origins_EQ.getValue()), new OptSpecifier(options.ID.OPT_fsanitize_memory_track_origins.getValue()), new OptSpecifier(options.ID.OPT_fno_sanitize_memory_track_origins.getValue()));
            if (A != null) {
                if (A.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_memory_track_origins.getValue()))) {
                    this.MsanTrackOrigins = 2;
                } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_memory_track_origins.getValue()))) {
                    this.MsanTrackOrigins = 0;
                } else {
                    StringRef S = new StringRef(A.getValue());
                    if (S.getAsInteger$Signed(0, this.MsanTrackOrigins$Ref) || this.MsanTrackOrigins < 0 || this.MsanTrackOrigins > 2) {
                        JavaCleaner $c$12 = Native.$createJavaCleaner();
                        try {
                            $c$12.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$12.track((Object)D.Diag(337))), (StringRef)new StringRef(A.getAsString(Args))), (StringRef)S));
                        }
                        finally {
                            $c$12.$destroy();
                        }
                    }
                }
            }
            this.MsanUseAfterDtor = Args.hasArg(new OptSpecifier(options.ID.OPT_fsanitize_memory_use_after_dtor.getValue()));
            this.NeedPIE |= !TC.getTriple().isOSLinux() || TC.getTriple().getArch() != Triple.ArchType.x86_64;
        }
        if ((AllAddedKinds & SanitizerKind.CFI) != 0L) {
            this.CfiCrossDso = Args.hasFlag(new OptSpecifier(options.ID.OPT_fsanitize_cfi_cross_dso.getValue()), new OptSpecifier(options.ID.OPT_fno_sanitize_cfi_cross_dso.getValue()), false);
            this.NeedPIE |= this.CfiCrossDso;
        }
        this.Stats = Args.hasFlag(new OptSpecifier(options.ID.OPT_fsanitize_stats.getValue()), new OptSpecifier(options.ID.OPT_fno_sanitize_stats.getValue()), false);
        block89: for (Arg Arg3 : Args) {
            if (Arg3.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_coverage.getValue()))) {
                int.ref LegacySanitizeCoverage = NativePointer.create_int$ref();
                if (Arg3.getNumValues() == 1 && !new StringRef(Arg3.getValue(0)).getAsInteger$Signed(0, LegacySanitizeCoverage) && LegacySanitizeCoverage.$deref() >= 0 && LegacySanitizeCoverage.$deref() <= 4) {
                    switch (LegacySanitizeCoverage.$deref()) {
                        case 0: {
                            this.CoverageFeatures = 0;
                            Arg3.claim();
                            break;
                        }
                        case 1: {
                            JavaCleaner $c$13 = Native.$createJavaCleaner();
                            try {
                                $c$13.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$13.track((Object)D.Diag(382))), (StringRef)new StringRef(Arg3.getAsString(Args))), (String)"-fsanitize-coverage=func"));
                                this.CoverageFeatures = 1;
                                continue block89;
                            }
                            finally {
                                $c$13.$destroy();
                                continue block89;
                            }
                        }
                        case 2: {
                            JavaCleaner $c$13 = Native.$createJavaCleaner();
                            try {
                                $c$13.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$13.track((Object)D.Diag(382))), (StringRef)new StringRef(Arg3.getAsString(Args))), (String)"-fsanitize-coverage=bb"));
                                this.CoverageFeatures = 2;
                                continue block89;
                            }
                            finally {
                                $c$13.$destroy();
                                continue block89;
                            }
                        }
                        case 3: {
                            JavaCleaner $c$13 = Native.$createJavaCleaner();
                            try {
                                $c$13.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$13.track((Object)D.Diag(382))), (StringRef)new StringRef(Arg3.getAsString(Args))), (String)"-fsanitize-coverage=edge"));
                                this.CoverageFeatures = 4;
                                continue block89;
                            }
                            finally {
                                $c$13.$destroy();
                                continue block89;
                            }
                        }
                        case 4: {
                            JavaCleaner $c$13 = Native.$createJavaCleaner();
                            try {
                                $c$13.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$13.track((Object)D.Diag(382))), (StringRef)new StringRef(Arg3.getAsString(Args))), (String)"-fsanitize-coverage=edge,indirect-calls"));
                                this.CoverageFeatures = 12;
                                continue block89;
                            }
                            finally {
                                $c$13.$destroy();
                                continue block89;
                            }
                        }
                    }
                    continue;
                }
                this.CoverageFeatures |= SanitizerArgsStatics.parseCoverageFeatures(D, Arg3);
                if ((AllAddedKinds & (SanitizerArgsStatics.setGroupBits(SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.SupportsCoverage.getValue()) ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
                    Arg3.claim();
                    continue;
                }
                this.CoverageFeatures = 0;
                continue;
            }
            if (!Arg3.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_coverage.getValue()))) continue;
            Arg3.claim();
            this.CoverageFeatures &= ~SanitizerArgsStatics.parseCoverageFeatures(D, Arg3);
        }
        if ((this.CoverageFeatures & 1) != 0 && (this.CoverageFeatures & 2) != 0) {
            $c$2 = Native.$createJavaCleaner();
            try {
                $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)D.Diag(306))), (String)"-fsanitize-coverage=func"), (String)"-fsanitize-coverage=bb"));
            }
            finally {
                $c$2.$destroy();
            }
        }
        if ((this.CoverageFeatures & 1) != 0 && (this.CoverageFeatures & 4) != 0) {
            $c$2 = Native.$createJavaCleaner();
            try {
                $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)D.Diag(306))), (String)"-fsanitize-coverage=func"), (String)"-fsanitize-coverage=edge"));
            }
            finally {
                $c$2.$destroy();
            }
        }
        if ((this.CoverageFeatures & 2) != 0 && (this.CoverageFeatures & 4) != 0) {
            $c$2 = Native.$createJavaCleaner();
            try {
                $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)D.Diag(306))), (String)"-fsanitize-coverage=bb"), (String)"-fsanitize-coverage=edge"));
            }
            finally {
                $c$2.$destroy();
            }
        }
        int CoverageTypes = 7;
        if ((this.CoverageFeatures & 0x10) != 0 && (this.CoverageFeatures & CoverageTypes) == 0) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(307))), (String)"-fsanitize-coverage=trace-bb"), (String)"-fsanitize-coverage=(func|bb|edge)"));
            }
            finally {
                $c$.$destroy();
            }
        }
        if ((this.CoverageFeatures & 0x40) != 0 && (this.CoverageFeatures & CoverageTypes) == 0) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(307))), (String)"-fsanitize-coverage=8bit-counters"), (String)"-fsanitize-coverage=(func|bb|edge)"));
            }
            finally {
                $c$.$destroy();
            }
        }
        if ((this.CoverageFeatures & 0x80) != 0 && (this.CoverageFeatures & CoverageTypes) == 0) {
            this.CoverageFeatures |= 4;
        }
        if ((AllAddedKinds & SanitizerKind.Address) != 0L) {
            Arg WindowsDebugRTArg;
            StringRef S;
            this.AsanSharedRuntime = Args.hasArg(new OptSpecifier(options.ID.OPT_shared_libasan.getValue())) || TC.getTriple().isAndroid();
            this.NeedPIE |= TC.getTriple().isAndroid();
            Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_fsanitize_address_field_padding.getValue()));
            if (A != null && ((S = new StringRef(A.getValue())).getAsInteger$Signed(0, this.AsanFieldPadding$Ref) || this.AsanFieldPadding < 0 || this.AsanFieldPadding > 2)) {
                JavaCleaner $c$14 = Native.$createJavaCleaner();
                try {
                    $c$14.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$14.track((Object)D.Diag(337))), (StringRef)new StringRef(A.getAsString(Args))), (StringRef)S));
                }
                finally {
                    $c$14.$destroy();
                }
            }
            if ((WindowsDebugRTArg = Args.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_MTd.getValue()), new OptSpecifier(options.ID.OPT__SLASH_MT.getValue()), new OptSpecifier(options.ID.OPT__SLASH_MDd.getValue()), new OptSpecifier(options.ID.OPT__SLASH_MD.getValue()), new OptSpecifier(options.ID.OPT__SLASH_LDd.getValue()), new OptSpecifier(options.ID.OPT__SLASH_LD.getValue()))) != null) {
                switch (options.ID.valueOf(WindowsDebugRTArg.getOption().getID())) {
                    case OPT__SLASH_MTd: 
                    case OPT__SLASH_MDd: 
                    case OPT__SLASH_LDd: {
                        JavaCleaner $c$15 = Native.$createJavaCleaner();
                        try {
                            $c$15.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$15.track((Object)D.Diag(306))), (StringRef)new StringRef(WindowsDebugRTArg.getAsString(Args))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForMask(D, Args, SanitizerKind.Address))));
                            $c$15.clean($c$15.track((Object)D.Diag(374)));
                            break;
                        }
                        finally {
                            $c$15.$destroy();
                        }
                    }
                }
            }
        }
        this.AsanUseAfterScope = Args.hasArg(new OptSpecifier(options.ID.OPT_fsanitize_address_use_after_scope.getValue()));
        if (this.AsanUseAfterScope && (AllAddedKinds & SanitizerKind.Address) == 0L) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(307))), (String)"-fsanitize-address-use-after-scope"), (String)"-fsanitize=address"));
            }
            finally {
                $c$.$destroy();
            }
        }
        this.LinkCXXRuntimes = Args.hasArg(new OptSpecifier(options.ID.OPT_fsanitize_link_cxx_runtime.getValue())) || D.CCCIsCXX();
        this.Sanitizers.Mask |= Kinds;
        this.RecoverableSanitizers.Mask |= RecoverableKinds;
        this.TrapSanitizers.Mask |= TrappingKinds;
    }

    public boolean needsAsanRt() {
        return this.Sanitizers.has(SanitizerKind.Address);
    }

    public boolean needsSharedAsanRt() {
        return this.AsanSharedRuntime;
    }

    public boolean needsTsanRt() {
        return this.Sanitizers.has(SanitizerKind.Thread);
    }

    public boolean needsMsanRt() {
        return this.Sanitizers.has(SanitizerKind.Memory);
    }

    public boolean needsLsanRt() {
        return this.Sanitizers.has(SanitizerKind.Leak) && !this.Sanitizers.has(SanitizerKind.Address);
    }

    public boolean needsUbsanRt() {
        return ((this.Sanitizers.Mask & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.NeedsUbsanRt.getValue() & (this.TrapSanitizers.Mask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L || this.CoverageFeatures != 0) && !this.Sanitizers.has(SanitizerKind.Address) && !this.Sanitizers.has(SanitizerKind.Memory) && !this.Sanitizers.has(SanitizerKind.Thread) && !this.Sanitizers.has(SanitizerKind.DataFlow) && !this.CfiCrossDso;
    }

    public boolean needsDfsanRt() {
        return this.Sanitizers.has(SanitizerKind.DataFlow);
    }

    public boolean needsSafeStackRt() {
        return this.Sanitizers.has(SanitizerKind.SafeStack);
    }

    public boolean needsCfiRt() {
        return (this.Sanitizers.Mask & SanitizerKind.CFI & (this.TrapSanitizers.Mask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L && this.CfiCrossDso;
    }

    public boolean needsCfiDiagRt() {
        return (this.Sanitizers.Mask & SanitizerKind.CFI & (this.TrapSanitizers.Mask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L && this.CfiCrossDso;
    }

    public boolean needsStatsRt() {
        return this.Stats;
    }

    public boolean needsEsanRt() {
        return this.Sanitizers.hasOneOf(SanitizerKind.Efficiency);
    }

    public boolean requiresPIE() {
        return this.NeedPIE || (this.Sanitizers.Mask & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.RequiresPIE.getValue()) != 0L;
    }

    public boolean needsUnwindTables() {
        return (this.Sanitizers.Mask & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.NeedsUnwindTables.getValue()) != 0L;
    }

    public boolean linkCXXRuntimes() {
        return this.LinkCXXRuntimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArgs(ToolChain TC, ArgList Args, ArgStringList CmdArgs, types.ID InputType) {
        std_pair.pairUIntType[] CoverageFlags = new std_pair.pairUIntType[]{std.make_pair_uint_T((int)1, (Object)NativePointer.$((String)"-fsanitize-coverage-type=1")), std.make_pair_uint_T((int)2, (Object)NativePointer.$((String)"-fsanitize-coverage-type=2")), std.make_pair_uint_T((int)4, (Object)NativePointer.$((String)"-fsanitize-coverage-type=3")), std.make_pair_uint_T((int)8, (Object)NativePointer.$((String)"-fsanitize-coverage-indirect-calls")), std.make_pair_uint_T((int)16, (Object)NativePointer.$((String)"-fsanitize-coverage-trace-bb")), std.make_pair_uint_T((int)32, (Object)NativePointer.$((String)"-fsanitize-coverage-trace-cmp")), std.make_pair_uint_T((int)64, (Object)NativePointer.$((String)"-fsanitize-coverage-8bit-counters")), std.make_pair_uint_T((int)128, (Object)NativePointer.$((String)"-fsanitize-coverage-trace-pc"))};
        for (std_pair.pairUIntType F : CoverageFlags) {
            if ((this.CoverageFeatures & F.first) == 0) continue;
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine((char.ptr)F.second)));
        }
        if (TC.getTriple().isOSWindows() && this.needsUbsanRt()) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"--dependent-lib=", (std.string)TC.getCompilerRT(Args, new StringRef("ubsan_standalone"))))));
            if (types.isCXX(InputType)) {
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"--dependent-lib=", (std.string)TC.getCompilerRT(Args, new StringRef("ubsan_standalone_cxx"))))));
            }
        }
        if (TC.getTriple().isOSWindows() && this.needsStatsRt()) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"--dependent-lib=", (std.string)TC.getCompilerRT(Args, new StringRef("stats_client"))))));
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"--dependent-lib=", (std.string)TC.getCompilerRT(Args, new StringRef("stats"))))));
            SanitizerArgsStatics.addIncludeLinkerOption(TC, Args, CmdArgs, new StringRef("__sanitizer_stats_register"));
        }
        if (this.Sanitizers.empty()) {
            return;
        }
        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"-fsanitize=", (std.string)SanitizerArgsStatics.__toString(this.Sanitizers)))));
        if (!this.RecoverableSanitizers.empty()) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"-fsanitize-recover=", (std.string)SanitizerArgsStatics.__toString(this.RecoverableSanitizers)))));
        }
        if (!this.TrapSanitizers.empty()) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"-fsanitize-trap=", (std.string)SanitizerArgsStatics.__toString(this.TrapSanitizers)))));
        }
        for (std.string BLPath : this.BlacklistFiles) {
            SmallString BlacklistOpt = new SmallString(new StringRef("-fsanitize-blacklist="), 64);
            BlacklistOpt.$addassign(new StringRef(BLPath));
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(BlacklistOpt)));
        }
        for (std.string Dep : this.ExtraDeps) {
            SmallString ExtraDepOpt = new SmallString(new StringRef("-fdepfile-entry="), 64);
            ExtraDepOpt.$addassign(new StringRef(Dep));
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ExtraDepOpt)));
        }
        if (this.MsanTrackOrigins != 0) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"-fsanitize-memory-track-origins=", (std.string)llvm.utostr((long)Unsigned.$int2ulong((int)this.MsanTrackOrigins))))));
        }
        if (this.MsanUseAfterDtor) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-fsanitize-memory-use-after-dtor")));
        }
        if (this.CfiCrossDso) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-fsanitize-cfi-cross-dso")));
        }
        if (this.Stats) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-fsanitize-stats")));
        }
        if (this.AsanFieldPadding != 0) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string((String)"-fsanitize-address-field-padding=", (std.string)llvm.utostr((long)Unsigned.$int2ulong((int)this.AsanFieldPadding))))));
        }
        if (this.AsanUseAfterScope) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-fsanitize-address-use-after-scope")));
        }
        if (this.Sanitizers.has(SanitizerKind.Memory) || this.Sanitizers.has(SanitizerKind.Address)) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-fno-assume-sane-operator-new")));
        }
        if (this.Sanitizers.hasOneOf(SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.CFIClasses.getValue()) && !TC.getTriple().isOSWindows() && !Args.hasArg(new OptSpecifier(options.ID.OPT_fvisibility_EQ.getValue()))) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)TC.getDriver().Diag(307))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForMask(TC.getDriver(), Args, this.Sanitizers.Mask & SanitizerArgsStatics.SanitizerArgs_cpp_Unnamed_enum.CFIClasses.getValue()))), (String)"-fvisibility="));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    public void $destroy() {
        this.ExtraDeps.$destroy();
        this.BlacklistFiles.$destroy();
    }

    public String toString() {
        return "Sanitizers=" + this.Sanitizers + ", RecoverableSanitizers=" + this.RecoverableSanitizers + ", TrapSanitizers=" + this.TrapSanitizers + ", BlacklistFiles=" + this.BlacklistFiles + ", ExtraDeps=" + this.ExtraDeps + ", CoverageFeatures=" + this.CoverageFeatures + ", MsanTrackOrigins=" + this.MsanTrackOrigins + ", MsanUseAfterDtor=" + this.MsanUseAfterDtor + ", CfiCrossDso=" + this.CfiCrossDso + ", AsanFieldPadding=" + this.AsanFieldPadding + ", AsanSharedRuntime=" + this.AsanSharedRuntime + ", AsanUseAfterScope=" + this.AsanUseAfterScope + ", LinkCXXRuntimes=" + this.LinkCXXRuntimes + ", NeedPIE=" + this.NeedPIE + ", Stats=" + this.Stats;
    }
}

