/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.driver.Driver;
import org.clang.driver.SanitizerArgs;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.ToolChainsStatics;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.Darwin;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;
import org.llvm.target.target.DebuggerKind;

public class DarwinClang
extends Darwin
implements Destructors.ClassWithDestructor {
    public DarwinClang(Driver D, Triple Triple2, ArgList Args) {
        super(D, Triple2, Args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void AddLinkRuntimeLibArgs(ArgList Args, ArgStringList CmdArgs) {
        switch (this.GetRuntimeLibType(Args)) {
            case RLT_CompilerRT: {
                break;
            }
            default: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(367))), (char.ptr)Args.getLastArg(new OptSpecifier(options.ID.OPT_rtlib_EQ.getValue())).getValue()), (String)"darwin"));
                    return;
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_fapple_kext.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_mkernel.getValue()))) {
            return;
        }
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_static_libgcc.getValue()));
        if (A != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(364))), (StringRef)new StringRef(A.getAsString(Args))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        SanitizerArgs Sanitize = this.getSanitizerArgs();
        if (Sanitize.needsAsanRt()) {
            this.AddLinkSanitizerLibArgs(Args, CmdArgs, new StringRef("asan"));
        }
        if (Sanitize.needsUbsanRt()) {
            this.AddLinkSanitizerLibArgs(Args, CmdArgs, new StringRef("ubsan"));
        }
        if (Sanitize.needsTsanRt()) {
            this.AddLinkSanitizerLibArgs(Args, CmdArgs, new StringRef("tsan"));
        }
        if (Sanitize.needsStatsRt()) {
            StringRef OS = new StringRef(this.isTargetMacOS() ? NativePointer.$((String)"osx") : NativePointer.$((String)"iossim"));
            this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("libclang_rt.stats_client_"), (Twine)new Twine(OS)), (Twine)new Twine(".a")).str()), true);
            this.AddLinkSanitizerLibArgs(Args, CmdArgs, new StringRef("stats"));
        }
        if (Sanitize.needsEsanRt()) {
            this.AddLinkSanitizerLibArgs(Args, CmdArgs, new StringRef("esan"));
        }
        CmdArgs.push_back((Object)NativePointer.$((String)"-lSystem"));
        if (this.isTargetWatchOSBased()) {
            this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef("libclang_rt.watchos.a"));
        } else if (this.isTargetTvOSBased()) {
            this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef("libclang_rt.tvos.a"));
        } else if (this.isTargetIOSBased()) {
            if (this.isIPhoneOSVersionLT(5, 0) && !this.isTargetIOSSimulator() && this.getTriple().getArch() != Triple.ArchType.aarch64) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s.1"));
            }
            this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef("libclang_rt.ios.a"));
        } else {
            assert (this.isTargetMacOS()) : "unexpected non MacOS platform";
            if (this.isMacosxVersionLT(10, 5)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s.10.4"));
            } else if (this.isMacosxVersionLT(10, 6)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s.10.5"));
            }
            if (this.isMacosxVersionLT(10, 5)) {
                this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef("libclang_rt.10.4.a"));
            } else {
                this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef("libclang_rt.osx.a"));
            }
        }
    }

    @Override
    public void AddCXXStdlibLibArgs(ArgList Args, ArgStringList CmdArgs) {
        ToolChain.CXXStdlibType Type2 = this.GetCXXStdlibType(Args);
        switch (Type2) {
            case CST_Libcxx: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lc++"));
                break;
            }
            case CST_Libstdcxx: {
                Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_isysroot.getValue()));
                if (A != null) {
                    SmallString P = new SmallString(new StringRef(A.getValue()), 128);
                    path.append((SmallString)P, (Twine)new Twine("usr"), (Twine)new Twine("lib"), (Twine)new Twine("libstdc++.dylib"));
                    if (!this.getVFS().exists(new Twine(P))) {
                        path.remove_filename((SmallString)P);
                        path.append((SmallString)P, (Twine)new Twine("libstdc++.6.dylib"));
                        if (this.getVFS().exists(new Twine(P))) {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(P)));
                            return;
                        }
                    }
                }
                if (!this.getVFS().exists(new Twine("/usr/lib/libstdc++.dylib")) && this.getVFS().exists(new Twine("/usr/lib/libstdc++.6.dylib"))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"/usr/lib/libstdc++.6.dylib"));
                    return;
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
            }
        }
    }

    @Override
    public void AddCCKextLibArgs(ArgList Args, ArgStringList CmdArgs) {
        SmallString P = new SmallString(new StringRef(this.getDriver().ResourceDir), 128);
        path.append((SmallString)P, (Twine)new Twine("lib"), (Twine)new Twine("darwin"));
        if (this.isTargetWatchOS()) {
            path.append((SmallString)P, (Twine)new Twine("libclang_rt.cc_kext_watchos.a"));
        } else if (this.isTargetTvOS()) {
            path.append((SmallString)P, (Twine)new Twine("libclang_rt.cc_kext_tvos.a"));
        } else if (this.isTargetIPhoneOS()) {
            path.append((SmallString)P, (Twine)new Twine("libclang_rt.cc_kext_ios.a"));
        } else {
            path.append((SmallString)P, (Twine)new Twine("libclang_rt.cc_kext.a"));
        }
        if (this.getVFS().exists(new Twine(P))) {
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(P)));
        }
    }

    @Override
    public void addClangWarningOptions(ArgStringList CC1Args) {
        if (this.isTargetWatchOSBased() || this.getTriple().isArch64Bit()) {
            CC1Args.push_back((Object)NativePointer.$((String)"-Wdeprecated-objc-isa-usage"));
            CC1Args.push_back((Object)NativePointer.$((String)"-Werror=deprecated-objc-isa-usage"));
            if (!this.isTargetMacOS()) {
                CC1Args.push_back((Object)NativePointer.$((String)"-Werror=implicit-function-declaration"));
            }
        }
    }

    @Override
    public void AddLinkARCArgs(ArgList Args, ArgStringList CmdArgs) {
        if (this.isTargetMacOS() && this.getArch() == Triple.ArchType.x86) {
            return;
        }
        ObjCRuntime runtime = this.getDefaultObjCRuntime(true);
        if ((runtime.hasNativeARC() || !ToolChainsStatics.isObjCAutoRefCount(Args)) && runtime.hasSubscripting()) {
            return;
        }
        CmdArgs.push_back((Object)NativePointer.$((String)"-force_load"));
        SmallString P = new SmallString(new StringRef(this.getDriver().ClangExecutable), 128);
        path.remove_filename((SmallString)P);
        path.remove_filename((SmallString)P);
        path.append((SmallString)P, (Twine)new Twine("lib"), (Twine)new Twine("arc"), (Twine)new Twine("libarclite_"));
        if (this.isTargetWatchOSSimulator()) {
            P.$addassign("watchsimulator");
        } else if (this.isTargetWatchOS()) {
            P.$addassign("watchos");
        } else if (this.isTargetTvOSSimulator()) {
            P.$addassign("appletvsimulator");
        } else if (this.isTargetTvOS()) {
            P.$addassign("appletvos");
        } else if (this.isTargetIOSSimulator()) {
            P.$addassign("iphonesimulator");
        } else if (this.isTargetIPhoneOS()) {
            P.$addassign("iphoneos");
        } else {
            P.$addassign("macosx");
        }
        P.$addassign(".a");
        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(P)));
    }

    @Override
    public int GetDefaultDwarfVersion() {
        return 2;
    }

    @Override
    public boolean GetDefaultStandaloneDebug() {
        return true;
    }

    @Override
    public DebuggerKind getDefaultDebuggerTuning() {
        return DebuggerKind.LLDB;
    }

    private void AddLinkSanitizerLibArgs(ArgList Args, ArgStringList CmdArgs, StringRef Sanitizer) {
        this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("libclang_rt."), (Twine)new Twine(Sanitizer)), (Twine)new Twine(NativePointer.$UNDERSCORE)), (Twine)new Twine(this.getOSLibraryNameSuffix())), (Twine)new Twine("_dynamic.dylib")).str()), true, false, true);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

