/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.hibernate.cfg.model.Event;
import org.openide.util.NbBundle;

public class EventTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{NbBundle.getMessage(EventTableModel.class, (String)"LBL_Class")};
    private static final String attrName = "Class";
    private Event event;

    public EventTableModel(Event event) {
        this.event = event;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.event == null) {
            return null;
        }
        String attrValue = this.event.getAttributeValue("Listener", row, attrName);
        return attrValue;
    }

    @Override
    public int getRowCount() {
        if (this.event == null) {
            return 0;
        }
        return this.event.sizeListener();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addRow(String listenerClass) {
        int index = this.event.addListener(true);
        this.event.setAttributeValue("Listener", index, attrName, listenerClass);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void editRow(int row, String listenerClass) {
        this.event.setAttributeValue("Listener", row, attrName, listenerClass);
        this.fireTableRowsUpdated(row, row);
    }

    public void removeRow(int row) {
        this.event.removeListener(row);
        this.fireTableRowsDeleted(row, row);
    }
}

