/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.service.listener;

import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.spi.project.ui.ProjectOpenedHook;

public class ProjectOpenedHookImpl
extends ProjectOpenedHook {
    private Project project;
    private HibernateEnvironment hibernateEnvironment;
    private Logger logger = Logger.getLogger(ProjectOpenedHookImpl.class.getName());

    public ProjectOpenedHookImpl(Project project, HibernateEnvironment hibernateEnvironment) {
        this.project = project;
        this.hibernateEnvironment = hibernateEnvironment;
    }

    protected void projectOpened() {
        List<HibernateConfiguration> hibernateConfigurations = HibernateUtil.getAllHibernateConfigurations(this.project);
        if (hibernateConfigurations.size() != 0) {
            this.hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
        }
        this.logger.info("project opened .. " + this.project);
        this.logger.info("config : " + ((HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class)).getAllHibernateConfigurationsFromProject());
    }

    protected void projectClosed() {
    }
}

