/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.confirmdialog;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.confirmdialog.ConfirmDialog;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class ConfirmDialogRenderer
extends CoreRenderer {
    private static final Logger LOG = Logger.getLogger(ConfirmDialogRenderer.class.getName());

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ConfirmDialog dialog = (ConfirmDialog)component;
        this.encodeScript(context, dialog);
        this.encodeMarkup(context, dialog);
    }

    protected void encodeMarkup(FacesContext context, ConfirmDialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        String style = dialog.getStyle();
        String styleClass = dialog.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-confirm-dialog ui-dialog ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow" : "ui-confirm-dialog ui-dialog ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow " + styleClass;
        if (ComponentUtils.isRTL(context, dialog)) {
            styleClass = styleClass + " ui-dialog-rtl";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeHeader(context, dialog);
        this.encodeContent(context, dialog);
        this.encodeButtonPane(context, dialog);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ConfirmDialog dialog) throws IOException {
        String clientId = dialog.getClientId();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("ConfirmDialog", dialog.resolveWidgetVar(), clientId).attr("visible", dialog.isVisible(), false).attr("width", dialog.getWidth(), null).attr("height", dialog.getHeight(), null).attr("appendTo", SearchExpressionFacade.resolveComponentForClient(context, (UIComponent)dialog, dialog.getAppendTo()), null).attr("showEffect", dialog.getShowEffect(), null).attr("hideEffect", dialog.getHideEffect(), null).attr("closeOnEscape", dialog.isCloseOnEscape(), false).attr("global", dialog.isGlobal(), false);
        wb.finish();
    }

    protected void encodeHeader(FacesContext context, ConfirmDialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String header = dialog.getHeader();
        UIComponent headerFacet = dialog.getFacet("header");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-titlebar ui-widget-header ui-helper-clearfix ui-corner-top", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-dialog-title", null);
        if (headerFacet != null) {
            headerFacet.encodeAll(context);
        } else if (header != null) {
            writer.write(header);
        }
        writer.endElement("span");
        if (dialog.isClosable()) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)"ui-dialog-titlebar-icon ui-dialog-titlebar-close ui-corner-all", null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-closethick", null);
            writer.endElement("span");
            writer.endElement("a");
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, ConfirmDialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String messageText = dialog.getMessage();
        UIComponent messageFacet = dialog.getFacet("message");
        String defaultIcon = dialog.isGlobal() ? "ui-icon" : "ui-icon ui-icon-" + dialog.getSeverity();
        String severityIcon = defaultIcon + " " + "ui-confirm-dialog-severity";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-content ui-widget-content", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)severityIcon, null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-confirm-dialog-message", null);
        if (messageFacet != null) {
            messageFacet.encodeAll(context);
        } else if (messageText != null) {
            writer.writeText((Object)messageText, null);
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeButtonPane(FacesContext context, ConfirmDialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-buttonpane ui-dialog-footer ui-widget-content ui-helper-clearfix", null);
        this.renderChildren(context, (UIComponent)dialog);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

