/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.actions;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodCustomizer;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodCustomizerFactory;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModelSupport;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddWsOperationHelper {
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private final String name;
    private final boolean createAnnotations;
    private MethodModel method;

    public AddWsOperationHelper(String name, boolean flag) {
        this.name = name;
        this.createAnnotations = flag;
    }

    public AddWsOperationHelper(String name) {
        this(name, true);
    }

    protected MethodModel getPrototypeMethod() {
        return MethodModel.create((String)NbBundle.getMessage(AddWsOperationHelper.class, (String)"TXT_DefaultOperationName"), (String)"java.lang.String", (String)"", Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
    }

    public String getTitle() {
        return this.name;
    }

    protected MethodCustomizer createDialog(FileObject fileObject, MethodModel methodModel) throws IOException {
        return MethodCustomizerFactory.operationMethod((String)this.getTitle(), (MethodModel)methodModel, (ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot"), (ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile"), (ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")), this.getExistingMethods(fileObject));
    }

    public void addMethod(FileObject fileObject, String className) throws IOException {
        if (className == null) {
            return;
        }
        this.method = this.getPrototypeMethod();
        MethodCustomizer methodCustomizer = this.createDialog(fileObject, this.method);
        if (methodCustomizer.customizeMethod()) {
            try {
                this.method = methodCustomizer.getMethodModel();
                this.okButtonPressed(this.method, fileObject, className);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        } else {
            this.method = null;
        }
    }

    public MethodModel getMethodModel(FileObject fileObject, String className) throws IOException {
        this.addMethod(fileObject, className);
        return this.method;
    }

    protected void okButtonPressed(MethodModel method, FileObject implClassFo, String className) throws IOException {
        this.addOperation(method, implClassFo);
    }

    private void addOperation(final MethodModel methodModel, final FileObject implClassFo) {
        final JavaSource targetSource = JavaSource.forFileObject((FileObject)implClassFo);
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(AddWsOperationHelper.class, (String)"MSG_AddingNewOperation", (Object)methodModel.getName()));
        handle.start(100);
        final String[] seiClass = new String[1];
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                MethodTree method = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                if (method != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                    if (typeElement != null) {
                        boolean increaseProgress = true;
                        if (AddWsOperationHelper.this.createAnnotations) {
                            if (seiClass[0] == null) {
                                seiClass[0] = AddWsOperationHelper.this.getEndpointInterface(typeElement, (CompilationController)workingCopy);
                            } else {
                                seiClass[0] = null;
                                increaseProgress = false;
                            }
                        }
                        if (increaseProgress) {
                            handle.progress(20);
                        }
                        ClassTree javaClass = workingCopy.getTrees().getTree(typeElement);
                        TypeElement webMethodAn = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
                        TypeElement webParamAn = workingCopy.getElements().getTypeElement("javax.jws.WebParam");
                        ModifiersTree modifiersTree = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.emptyList());
                        if (AddWsOperationHelper.this.createAnnotations && seiClass[0] == null) {
                            PrimitiveTypeTree primitiveType;
                            String methodName = method.getName().toString();
                            String operationName = AddWsOperationHelper.this.findNewOperationName(typeElement, (CompilationController)workingCopy, methodName);
                            AssignmentTree opName = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"operationName"), (ExpressionTree)make.Literal((Object)operationName));
                            AnnotationTree annotationTree = make.Annotation((Tree)make.QualIdent((Element)webMethodAn), Collections.singletonList(opName));
                            modifiersTree = make.addModifiersAnnotation(modifiersTree, annotationTree);
                            boolean isOneWay = false;
                            if (Tree.Kind.PRIMITIVE_TYPE == method.getReturnType().getKind() && TypeKind.VOID == (primitiveType = (PrimitiveTypeTree)method.getReturnType()).getPrimitiveTypeKind() && method.getThrows().size() == 0) {
                                isOneWay = true;
                                TypeElement oneWayAn = workingCopy.getElements().getTypeElement("javax.jws.Oneway");
                                AnnotationTree oneWayAnnotation = make.Annotation((Tree)make.QualIdent((Element)oneWayAn), Collections.emptyList());
                                modifiersTree = make.addModifiersAnnotation(modifiersTree, oneWayAnnotation);
                            }
                            if (!methodName.equals(operationName)) {
                                String packagePrefix = AddWsOperationHelper.this.getPackagePrefix(typeElement.getQualifiedName().toString());
                                TypeElement reqWrapperAn = workingCopy.getElements().getTypeElement("javax.xml.ws.RequestWrapper");
                                AssignmentTree className = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"className"), (ExpressionTree)make.Literal((Object)(packagePrefix + operationName)));
                                AnnotationTree reqWrapperAnnotation = make.Annotation((Tree)make.QualIdent((Element)reqWrapperAn), Collections.singletonList(className));
                                modifiersTree = make.addModifiersAnnotation(modifiersTree, reqWrapperAnnotation);
                                if (!isOneWay) {
                                    TypeElement resWrapperAn = workingCopy.getElements().getTypeElement("javax.xml.ws.ResponseWrapper");
                                    className = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"className"), (ExpressionTree)make.Literal((Object)(packagePrefix + operationName + "Response")));
                                    AnnotationTree resWrapperAnnotation = make.Annotation((Tree)make.QualIdent((Element)resWrapperAn), Collections.singletonList(className));
                                    modifiersTree = make.addModifiersAnnotation(modifiersTree, resWrapperAnnotation);
                                }
                            }
                        }
                        if (increaseProgress) {
                            handle.progress(40);
                        }
                        List<? extends VariableTree> parameters = method.getParameters();
                        ArrayList<? extends VariableTree> newParameters = new ArrayList<VariableTree>();
                        if (AddWsOperationHelper.this.createAnnotations && seiClass[0] == null) {
                            for (VariableTree variableTree : parameters) {
                                AnnotationTree paramAnnotation = make.Annotation((Tree)make.QualIdent((Element)webParamAn), Collections.singletonList(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"name"), (ExpressionTree)make.Literal((Object)variableTree.getName().toString()))));
                                GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                                newParameters.add(genUtils.addAnnotation(variableTree, paramAnnotation));
                            }
                        } else {
                            newParameters.addAll(parameters);
                        }
                        if (increaseProgress) {
                            handle.progress(70);
                        }
                        MethodTree annotatedMethod = typeElement.getKind() == ElementKind.CLASS ? make.Method(modifiersTree, (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), newParameters, method.getThrows(), AddWsOperationHelper.this.getMethodBody(method.getReturnType()), (ExpressionTree)method.getDefaultValue()) : make.Method(modifiersTree, (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), newParameters, method.getThrows(), (BlockTree)null, (ExpressionTree)method.getDefaultValue());
                        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)NbBundle.getMessage(AddWsOperationHelper.class, (String)"TXT_WSOperation"));
                        make.addComment((Tree)annotatedMethod, comment, true);
                        if (increaseProgress) {
                            handle.progress(90);
                        }
                        ClassTree modifiedClass = make.addClassMember(javaClass, (Tree)annotatedMethod);
                        workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                    }
                }
            }

            public void cancel() {
            }
        };
        final Runnable runnable = new Runnable((CancellableTask)modificationTask){
            final /* synthetic */ CancellableTask val$modificationTask;
            {
                this.val$modificationTask = cancellableTask;
            }

            @Override
            public void run() {
                AddWsOperationHelper.this.doAddOperation(implClassFo, targetSource, handle, seiClass, (CancellableTask<WorkingCopy>)this.val$modificationTask);
            }
        };
        final String title = NbBundle.getMessage(AddWsOperationHelper.class, (String)"LBL_AddOperation");
        if (SwingUtilities.isEventDispatchThread()) {
            ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
                }
            });
        }
    }

    private void doAddOperation(final FileObject implClassFo, final JavaSource targetSource, final ProgressHandle handle, final String[] seiClass, final CancellableTask<WorkingCopy> modificationTask) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ClassPath sourceCP;
                    FileObject seiFo;
                    targetSource.runModificationTask((Task)modificationTask).commit();
                    if (seiClass[0] != null && (seiFo = (sourceCP = ClassPath.getClassPath((FileObject)implClassFo, (String)"classpath/source")).findResource(seiClass[0].replace('.', '/') + ".java")) != null) {
                        JavaSource seiSource = JavaSource.forFileObject((FileObject)seiFo);
                        seiSource.runModificationTask((Task)modificationTask).commit();
                        AddWsOperationHelper.this.saveFile(seiFo);
                    }
                    AddWsOperationHelper.this.saveFile(implClassFo);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    private String getEndpointInterface(TypeElement classEl, CompilationController controller) {
        TypeElement wsElement = controller.getElements().getTypeElement("javax.jws.WebService");
        if (wsElement != null) {
            List<? extends AnnotationMirror> annotations = classEl.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotations) {
                if (!controller.getTypes().isSameType(wsElement.asType(), annotationMirror.getAnnotationType())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                    TypeElement seiEl;
                    String value;
                    if (!entry.getKey().getSimpleName().contentEquals("endpointInterface") || (value = (String)expressions.get(entry.getKey()).getValue()) == null || (seiEl = controller.getElements().getTypeElement(value)) == null) continue;
                    return seiEl.getQualifiedName().toString();
                }
            }
        }
        return null;
    }

    private String findNewOperationName(TypeElement classEl, CompilationController controller, String suggestedMethodName) throws IOException {
        TypeElement methodElement = controller.getElements().getTypeElement("javax.jws.WebMethod");
        HashSet<String> operationNames = new HashSet<String>();
        if (methodElement != null) {
            List<ExecutableElement> methods = this.getMethods(controller, classEl);
            for (ExecutableElement m : methods) {
                String opName = null;
                List<? extends AnnotationMirror> annotations = m.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : annotations) {
                    if (controller.getTypes().isSameType(methodElement.asType(), annotationMirror.getAnnotationType())) {
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                            if (!entry.getKey().getSimpleName().contentEquals("operationName")) continue;
                            opName = (String)expressions.get(entry.getKey()).getValue();
                            break;
                        }
                    }
                    if (opName == null) continue;
                    break;
                }
                if (opName == null) {
                    opName = m.getSimpleName().toString();
                }
                operationNames.add(opName);
            }
        }
        return this.findNewOperationName(operationNames, suggestedMethodName);
    }

    private String findNewOperationName(Set<String> operationNames, String suggestedMethodName) {
        int i = 0;
        String newName = suggestedMethodName;
        while (operationNames.contains(newName)) {
            newName = suggestedMethodName + "_" + String.valueOf(++i);
        }
        return newName;
    }

    private String getPackagePrefix(String className) {
        int lastDot = className.indexOf(".");
        if (lastDot > 0) {
            return className.substring(0, lastDot + 1);
        }
        return "";
    }

    private void saveFile(FileObject file) throws IOException {
        SaveCookie cookie;
        DataObject dataObject = DataObject.find((FileObject)file);
        if (dataObject != null && (cookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    private String getMethodBody(Tree returnType) {
        TypeKind type;
        String body = null;
        body = Tree.Kind.PRIMITIVE_TYPE == returnType.getKind() ? (TypeKind.VOID == (type = ((PrimitiveTypeTree)returnType).getPrimitiveTypeKind()) ? "" : (TypeKind.BOOLEAN == type ? "return false;" : (TypeKind.INT == type ? "return 0;" : (TypeKind.LONG == type ? "return 0;" : (TypeKind.FLOAT == type ? "return 0.0;" : (TypeKind.DOUBLE == type ? "return 0.0;" : (TypeKind.BYTE == type ? "return 0;" : (TypeKind.SHORT == type ? "return 0;" : (TypeKind.CHAR == type ? "return ' ';" : "return null"))))))))) : "return null";
        return "{\n\t\t" + NbBundle.getMessage(AddWsOperationHelper.class, (String)"TXT_TodoComment") + "\n" + body + "\n}";
    }

    private Collection<MethodModel> getExistingMethods(FileObject implClass) {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)implClass);
        final ResultHolder result = new ResultHolder();
        if (javaSource != null) {
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                    ArrayList<MethodModel> wsOperations = new ArrayList<MethodModel>();
                    if (typeElement != null) {
                        ExecutableElement method;
                        List allMethods = AddWsOperationHelper.this.getMethods(controller, typeElement);
                        boolean foundWebMethodAnnotation = false;
                        Iterator iterator = allMethods.iterator();
                        while (iterator.hasNext() && (method = (ExecutableElement)iterator.next()).getReturnType().getKind() != TypeKind.ERROR) {
                            boolean validParamTypes = true;
                            List<? extends VariableElement> params = method.getParameters();
                            for (VariableElement variableElement : params) {
                                if (variableElement.asType().getKind() != TypeKind.ERROR) continue;
                                validParamTypes = false;
                                break;
                            }
                            if (!validParamTypes) continue;
                            MethodModel methodModel = MethodModelSupport.createMethodModel((CompilationController)controller, (ExecutableElement)method);
                            wsOperations.add(methodModel);
                        }
                    }
                    result.setResult(wsOperations);
                }

                public void cancel() {
                }
            };
            final Runnable runnable = new Runnable((CancellableTask)task){
                final /* synthetic */ CancellableTask val$task;
                {
                    this.val$task = cancellableTask;
                }

                @Override
                public void run() {
                    try {
                        javaSource.runUserActionTask((Task)this.val$task, true);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            };
            final String title = NbBundle.getMessage(AddWsOperationHelper.class, (String)"LBL_FindMethods");
            if (SwingUtilities.isEventDispatchThread()) {
                ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                catch (InterruptedException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        return result.getResult();
    }

    private List<ExecutableElement> getMethods(CompilationController controller, TypeElement classElement) throws IOException {
        List<? extends Element> members = classElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(members);
        ArrayList<ExecutableElement> publicMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement m : methods) {
            publicMethods.add(m);
        }
        return publicMethods;
    }

    private static class ResultHolder<E> {
        private Collection<E> result;

        private ResultHolder() {
        }

        public Collection<E> getResult() {
            return this.result;
        }

        public void setResult(Collection<E> result) {
            this.result = result;
        }
    }
}

