/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.wsdl.websvcmgr;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModel;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModeler;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModelerFactory;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WebServiceListManager;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WsdlDataImpl;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class WebServiceManager {
    private static WebServiceManager wsMgr;
    public static String WEBSVC_HOME;

    private WebServiceManager() {
    }

    public static WebServiceManager getInstance() {
        if (wsMgr == null) {
            wsMgr = new WebServiceManager();
        }
        return wsMgr;
    }

    public void addWebService(WsdlDataImpl wsData) throws IOException {
        this.addWebService(wsData, false);
    }

    public void addWebService(WsdlDataImpl wsData, boolean compile) throws IOException {
        File localWsdlFile;
        if (wsData.getStatus().equals((Object)WsdlData.Status.WSDL_UNRETRIEVED) || wsData.getStatus().equals((Object)WsdlData.Status.WSDL_RETRIEVING) && !wsData.isReady()) {
            wsData.setStatus(WsdlData.Status.WSDL_RETRIEVING);
            localWsdlFile = null;
            try {
                localWsdlFile = WebServiceManager.copyWsdlResources(wsData.getOriginalWsdlUrl());
            }
            catch (IOException ex) {
                wsData.setStatus(WsdlData.Status.WSDL_UNRETRIEVED);
                throw ex;
            }
            wsData.setWsdlFile(localWsdlFile.getAbsolutePath());
            wsData.setStatus(WsdlData.Status.WSDL_RETRIEVED);
        }
        assert (wsData.getWsdlFile() != null);
        localWsdlFile = new File(wsData.getWsdlFile());
        URL wsdlUrl = localWsdlFile.toURI().toURL();
        WsdlModeler wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(wsdlUrl);
        WsdlModel model = wsdlModeler.getAndWaitForWsdlModel();
        boolean dataInModel = WebServiceListManager.getInstance().wsdlDataExistsFor(wsData.getOriginalWsdlUrl());
        if (model == null) {
            this.removeWebService(wsData, true, false);
            Throwable exc = wsdlModeler.getCreationException();
            String message = NbBundle.getMessage(WebServiceManager.class, (String)"WS_MODELER_ERROR");
            if (exc != null) {
                String cause = exc.getLocalizedMessage();
                String excString = exc.getClass().getName() + " - " + cause;
                message = message + "\n\n" + excString;
                Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)exc, (String)message));
            } else {
                exc = new IllegalStateException(message);
                Exceptions.printStackTrace((Throwable)exc);
            }
            return;
        }
        if (model.getServices().isEmpty()) {
            this.removeWebService(wsData, true, true);
            String message = NbBundle.getMessage(WebServiceManager.class, (String)"WS_NO_METHODS_ERROR");
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            return;
        }
        if (dataInModel) {
            boolean assigned = false;
            for (WSService service : model.getServices()) {
                if (!service.getName().equals(wsData.getName())) continue;
                assigned = true;
                wsData.setWsdlService(service);
                wsData.setResolved(true);
                break;
            }
            if (!assigned) {
                WSService defaultService = model.getServices().get(0);
                wsData.setWsdlService(defaultService);
                wsData.setName(defaultService.getName());
                wsData.setResolved(true);
            }
        } else {
            boolean first = true;
            for (WSService service : model.getServices()) {
                WsdlDataImpl newData;
                if (first) {
                    first = false;
                    newData = wsData;
                } else {
                    newData = new WsdlDataImpl(wsData.getOriginalWsdlUrl());
                }
                newData.setWsdlService(service);
                newData.setName(service.getName());
                newData.setResolved(true);
                WebServiceListManager.getInstance().addWsdlData(newData);
            }
        }
    }

    public void refreshWebService(WsdlDataImpl wsData) throws IOException {
        this.removeWebService(wsData, false, true);
        wsData.setWsdlFile(null);
        wsData.setStatus(WsdlData.Status.WSDL_RETRIEVING);
        wsData.setWsdlService(null);
        this.addWebService(wsData, true);
    }

    public void removeWebService(WsdlDataImpl wsData) {
        this.removeWebService(wsData, true, true);
    }

    private void removeWebService(WsdlDataImpl wsData, boolean removeFromModel, boolean deleteWsdl) {
        WebServiceListManager mgr;
        if (removeFromModel && (mgr = WebServiceListManager.getInstance()).wsdlDataExistsFor(wsData.getOriginalWsdlUrl())) {
            mgr.removeWsdlData(wsData);
        }
        if (wsData.getWsdlFile() == null) {
            return;
        }
        if (deleteWsdl) {
            WebServiceManager.rmDir(new File(wsData.getWsdlFile()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rmDir(File dir) {
        if (dir == null) {
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)dir);
        if (fo != null) {
            FileLock lock = null;
            try {
                lock = fo.lock();
                fo.delete(lock);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    static File copyWsdlResources(String wsdlUrl) throws IOException {
        File userDirFile = new File(WEBSVC_HOME);
        File catalogFile = new File(userDirFile, WsdlUtil.getCatalogForWsdl(wsdlUrl));
        File dir = catalogFile.getParentFile();
        boolean success = false;
        dir = catalogFile.getParentFile();
        try {
            FileObject dirFO = FileUtil.createFolder((File)dir);
            URI catalog = catalogFile.toURI();
            URI wsdlUri = new URL(wsdlUrl).toURI();
            Retriever retriever = Retriever.getDefault();
            FileObject wsdlFO = retriever.retrieveResource(dirFO, catalog, wsdlUri);
            if (wsdlFO == null) {
                throw new IOException(NbBundle.getMessage(WebServiceManager.class, (String)"WSDL_COPY_ERROR"));
            }
            File result = FileUtil.toFile((FileObject)wsdlFO);
            success = true;
            File file = result;
            return file;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        finally {
            if (catalogFile.exists() && !success) {
                WebServiceManager.rmDir(catalogFile.getParentFile());
            }
        }
    }

    static {
        WEBSVC_HOME = SaasServicesModel.WEBSVC_HOME;
    }
}

