/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.util.Lookup;

public final class ModuleCookieSupport {
    private final TargetModuleID module;
    private final Lookup lookup;

    public ModuleCookieSupport(TargetModuleID module, Lookup lookup) {
        this.module = module;
        this.lookup = lookup;
    }

    public void performAction(Action action) {
        WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        if (manager != null) {
            ProgressObject obj = action.execute((DeploymentManager)manager, this.module);
            final CountDownLatch latch = new CountDownLatch(1);
            obj.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent pe) {
                    if (pe.getDeploymentStatus().isCompleted() || pe.getDeploymentStatus().isFailed()) {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface Action {
        public ProgressObject execute(DeploymentManager var1, TargetModuleID var2);
    }
}

