/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.apduio.CadTransportException;
import com.sun.javacard.apduio.ClientPCSCProtocol;
import java.io.IOException;
import java.util.ResourceBundle;

public class CadPCSCClient
extends CadDevice
implements CadClientInterface {
    protected ClientPCSCProtocol protocol;
    protected static ResourceBundle _messages = ResourceBundle.getBundle("com/sun/javacard/apduio/MessagesBundle");
    private int readerNumber;

    public CadPCSCClient(int n) {
        super((byte)-85);
        this.readerNumber = n;
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException, CadTransportException {
        if (this.protocol == null) {
            throw new IOException(_messages.getString("pcsc.2"));
        }
        this.protocol.exchangeApdu(apdu);
    }

    @Override
    public void powerDown(boolean bl) throws IOException, CadTransportException {
        this.protocol.closeCard();
        if (bl) {
            this.protocol = null;
        }
    }

    @Override
    public void powerDown() throws IOException, CadTransportException {
        this.powerDown(true);
    }

    @Override
    public byte[] powerUp() throws IOException, CadTransportException {
        try {
            this.protocol = new ClientPCSCProtocol();
            byte[] byArray = this.protocol.openCard(this.readerNumber);
            return byArray;
        }
        catch (Exception exception) {
            throw new IOException(_messages.getString("pcsc.1"));
        }
    }
}

