/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.ClassFieldsTable;
import com.sun.javacard.components.caputils.ClassFile;
import com.sun.javacard.components.caputils.ClassMethodTable;
import com.sun.javacard.converter.ConverterHarness;
import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AppletInfo;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CapProcessor {
    public static final String pathSep = File.separator;
    public static String pkgName;
    public static PackageInfo pkg;
    public static ExportFile ef;
    Hashtable<String, AppletInfo> applets = new Hashtable();
    String outputPath;

    public CapProcessor() {
        pkg = Cap.Header.thisPackage();
        ef = ImportComponent.findExportByAidAndVersion(pkg);
        pkgName = new String(Cap.packageDirectory);
    }

    public void processCap(String string, String string2, Vector<File> vector, String string3) {
        String string4 = null;
        this.outputPath = string2;
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        String string5 = null;
        for (int i = Cap.Descriptor.classCount(); i > 0; --i) {
            Object object;
            ClassFile classFile = new ClassFile();
            int n = classDescriptor.token();
            string5 = CAPUtil.getRefName(classDescriptor.thisClass());
            if (Cap.Applet != null && Cap.Applet.isAppletClass(classDescriptor)) {
                object = Cap.Applet.getAppletInfoForClass(classDescriptor);
                this.applets.put(string5, (AppletInfo)object);
            }
            object = null;
            if (ef != null) {
                object = ef.findClassByToken((short)n);
            }
            classFile.setClassName(string5);
            ClassConstantPool classConstantPool = new ClassConstantPool(classDescriptor, string5, (EfClass)object);
            classFile.setConstantPool(classConstantPool);
            classFile.setAccessFlags(classDescriptor.flags());
            classFile.setThisClass((short)classConstantPool.getThisClassIndex());
            classFile.setSuperClass((short)classConstantPool.getSuperClassRefIndex());
            Vector<Integer> vector2 = classConstantPool.getInterfaceRefs();
            int n2 = vector2.size();
            classFile.setInterfaceCount((short)n2);
            for (int j = 0; j < n2; ++j) {
                int n3 = vector2.elementAt(j);
                classFile.setInterfaceEntry((short)n3);
            }
            classFile.setMethodTable(new ClassMethodTable(classConstantPool, classDescriptor, (EfClass)object));
            classFile.setFieldTable(new ClassFieldsTable(classConstantPool, classDescriptor, (EfClass)object));
            String string6 = string5.substring(string5.lastIndexOf("/") + 1) + ".class";
            if (string4 == null) {
                string4 = string2 + pathSep + pkgName;
            }
            String string7 = string4 + pathSep + string6;
            try {
                File file = new File(string4);
                if (!file.exists()) {
                    file.mkdirs();
                }
                File file2 = new File(string7);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                classFile.write(fileOutputStream);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            classDescriptor.next();
        }
        String[] stringArray = this.getConverterArgs(string2, string, string3);
        ConverterHarness.startConversion(stringArray, this.getExportFilesHS(vector));
    }

    private String[] getConverterArgs(String string, String string2, String string3) {
        String[] stringArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add("-classdir");
        vector.add(string);
        vector.add("-i");
        vector.add("-out");
        vector.add("NORMALIZED_CAP");
        vector.add("-inputcap");
        vector.add(string2);
        Enumeration<String> enumeration = this.applets.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            String string4 = AID.prettyForHex(this.applets.get(stringArray));
            vector.add("-applet");
            vector.add(string4);
            stringArray = stringArray.replace('/', '.');
            vector.add(stringArray);
        }
        vector.add("-d");
        vector.add(this.outputPath);
        if (string3 != null) {
            vector.add("-keepproxysource");
            vector.add(string3);
        }
        vector.add(pkgName);
        vector.add(AID.prettyForHex(pkg));
        vector.add(pkg.majorVersion() + "." + pkg.minorVersion());
        stringArray = new String[vector.size()];
        return vector.toArray(stringArray);
    }

    private Hashtable<String, File> getExportFilesHS(Vector<File> vector) {
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        for (File file : vector) {
            ExportFile exportFile = ImportComponent.findExportByFileName(file.getPath());
            if (exportFile == null) continue;
            hashtable.put(exportFile.thisName(), file);
        }
        return hashtable;
    }
}

