/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public final class Signer
extends PackageItem {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private boolean required;
    private String keystore;
    private String storepass;
    private String passkey;
    private String alias;

    @Override
    public String getItemDisplayName() {
        return "Signing Tool";
    }

    @Override
    public void initialize() {
        if (!this.isRequired()) {
            return;
        }
        if (this.keystore == null) {
            this.addError(ErrorKey.MissingKeystore, new Object[0]);
        } else {
            File file = new File(this.keystore);
            if (file.isDirectory()) {
                this.addError(ErrorKey.IsNotAFile, file.getAbsolutePath());
            } else if (!file.exists()) {
                this.addError(ErrorKey.KeystoreFileDoesNotExists, file);
            }
        }
        if (this.storepass == null) {
            this.addError(ErrorKey.MissingStorepass, new Object[0]);
        }
        if (this.passkey == null) {
            this.addError(ErrorKey.MissingPassword, new Object[0]);
        }
        if (this.alias == null) {
            this.addError(ErrorKey.MissingAlias, new Object[0]);
        }
    }

    @Override
    public void processInternal() {
        if (!this.isRequired()) {
            return;
        }
        File file = Packager.getPackager().getOut();
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(46);
        string = n == -1 ? string + ".signature" : string.substring(0, n) + ".signature";
        this.createSignatureFile(new File(string), file);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public String getPasskey() {
        return this.passkey;
    }

    public void setPasskey(String string) {
        this.passkey = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    private void createSignatureFile(File file, File file2) {
        String string;
        KeyStore keyStore = null;
        File file3 = new File(this.keystore);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = null;
        Certificate certificate = null;
        byte[] byArray2 = null;
        if (file3.exists() && file3.length() == 0L) {
            this.addError(ErrorKey.EmptyKeystoreFile, new Object[0]);
            return;
        }
        try {
            fileInputStream = new FileInputStream(file3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addError(ErrorKey.KeystoreFileDoesNotExists, file3);
            return;
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, this.storepass.toCharArray());
        }
        catch (Exception exception) {
            this.addError(ErrorKey.ErrorReadingKeystoreFile, file3, exception.getMessage());
            return;
        }
        int n = 0;
        byte[] byArray3 = new byte[10240];
        Signature signature = null;
        try {
            signature = Signature.getInstance("MD5withRSA");
        }
        catch (Exception exception) {
            this.addError(ErrorKey.UnexpectedException, exception.toString());
            return;
        }
        Key key = null;
        try {
            key = keyStore.getKey(this.alias, this.passkey.toCharArray());
        }
        catch (Exception exception) {
            this.addError(ErrorKey.ErrorGettingPrivateKey, exception.getMessage());
            return;
        }
        try {
            signature.initSign((PrivateKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            this.addError(ErrorKey.InvalidPrivateKey, new Object[0]);
            return;
        }
        try {
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            while ((n = fileInputStream2.read(byArray3)) != -1) {
                signature.update(byArray3, 0, n);
            }
            fileInputStream2.close();
            byArray = signature.sign();
            string = Base64.encode(byArray);
            fileOutputStream = new FileOutputStream(file);
            Signer.write("signature", string, fileOutputStream, "UTF-8");
            certificate = keyStore.getCertificate(this.alias);
            if (certificate == null) {
                this.addError(ErrorKey.CertificateNotFound, new Object[0]);
                return;
            }
        }
        catch (Exception exception) {
            this.addError(ErrorKey.UnexpectedException, exception.toString());
            return;
        }
        try {
            byArray2 = certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.addError(ErrorKey.InvalidCertificateEncoding, new Object[0]);
            return;
        }
        string = Base64.encode(byArray2);
        try {
            Signer.write("certificate", string, fileOutputStream, "UTF-8");
            fileInputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            this.addError(ErrorKey.UnexpectedException, exception.toString());
            return;
        }
    }

    private static void write(String string, String string2, OutputStream outputStream, String string3) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string3);
        if (string3.equals("ISO8859_1")) {
            string = Signer.saveConvert(string);
            string2 = Signer.saveConvert(string2);
        }
        outputStreamWriter.write(string + "=" + string2);
        outputStreamWriter.write("\n");
        outputStreamWriter.flush();
    }

    private static String saveConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '~' || c == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('u');
                stringBuffer.append(Signer.toHex(c >> 12 & 0xF));
                stringBuffer.append(Signer.toHex(c >> 8 & 0xF));
                stringBuffer.append(Signer.toHex(c >> 4 & 0xF));
                stringBuffer.append(Signer.toHex(c & 0xF));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return HEX_DIGITS[n & 0xF];
    }
}

