/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.assistance;

import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.asm.core.assistance.CodeAnnotationSidebar;
import org.netbeans.modules.cnd.asm.core.assistance.LiveRangesAccessor;
import org.netbeans.modules.cnd.asm.core.assistance.LiveRangesAction;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterChooser;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterChooserListener;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.model.AsmModelAccessor;
import org.netbeans.modules.cnd.asm.model.AsmState;
import org.netbeans.modules.cnd.asm.model.lang.AsmOffsetable;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public class LiveRangesAssistance
implements AsmModelAccessor.ParseListener,
CaretListener,
RegisterChooserListener {
    private final CodeAnnotationSidebar sideBar;
    private final LiveRangesAction action;
    private LiveRangesAccessor accessor;
    private RegisterChooser lastChooser;
    private AsmOffsetable lastRangeStart;
    private AsmOffsetable lastRangeEnd;
    private final BaseDocument doc;
    private final JEditorPane pane;
    private final EditorCookie cookie;

    public LiveRangesAssistance(BaseDocument doc) {
        this.doc = doc;
        DataObject obj = NbEditorUtilities.getDataObject((Document)doc);
        this.cookie = (EditorCookie)obj.getCookie(EditorCookie.class);
        this.pane = this.cookie.getOpenedPanes()[0];
        this.pane.addCaretListener(this);
        this.action = new LiveRangesAction();
        this.sideBar = (CodeAnnotationSidebar)this.pane.getClientProperty("LIVE_RANGE_SIDEBAR");
        AsmModelAccessor acc = AsmObjectUtilities.getAccessor((Document)doc);
        if (acc == null) {
            return;
        }
        acc.addParseListener(this);
    }

    @Override
    public void notifyParsed() {
        AsmState state = AsmObjectUtilities.getAccessor((Document)this.doc).getState();
        this.accessor = this.action.calculateRanges(state);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiveRangesAssistance.this.calcLiveRanges(LiveRangesAssistance.this.getCaretPosition());
            }
        });
    }

    @Override
    public void update(RegisterChooser ch) {
        this.lastChooser = ch;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiveRangesAssistance.this.calcLiveRanges(LiveRangesAssistance.this.getCaretPosition());
            }
        });
    }

    private int getCaretPosition() {
        return this.pane.getCaretPosition();
    }

    private void addAnnotation(AsmOffsetable start, AsmOffsetable end, List<CodeAnnotationSidebar.AnnotationEntry> res) {
        try {
            int lnStart = Utilities.getLineOffset((BaseDocument)this.doc, (int)(start.getStartOffset() + 1));
            int lnEnd = Utilities.getLineOffset((BaseDocument)this.doc, (int)(end.getStartOffset() + 1));
            res.add(new CodeAnnotationSidebar.AnnotationEntry(Color.GREEN, lnStart + 1, lnEnd + 1));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void calcLiveRanges(int curPos) {
        if (this.lastChooser == null) {
            return;
        }
        LinkedList<CodeAnnotationSidebar.AnnotationEntry> res = new LinkedList<CodeAnnotationSidebar.AnnotationEntry>();
        AsmState state = AsmObjectUtilities.getAccessor((Document)this.doc).getState();
        if (this.accessor == null) {
            this.accessor = this.action.calculateRanges(state);
        }
        for (Register reg : this.lastChooser.getRegisters()) {
            this.lastRangeEnd = null;
            this.lastRangeStart = null;
            List<Integer> ranges = this.accessor.getRangesForRegister(reg);
            Iterator<Integer> iter = ranges.iterator();
            while (iter.hasNext()) {
                AsmOffsetable offStart = state.getElements().getCompounds().get(iter.next());
                AsmOffsetable offEnd = state.getElements().getCompounds().get(iter.next());
                this.addAnnotation(offStart, offEnd, res);
            }
        }
        this.sideBar.setAnnotations(res);
    }

    private boolean isInRange(AsmOffsetable offStart, AsmOffsetable offEnd, int pos) {
        return this.isInRange(offStart.getStartOffset(), offEnd.getStartOffset(), pos);
    }

    private boolean isInRange(int start, int end, int pos) {
        return start <= pos && pos < end;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int curPos = LiveRangesAssistance.this.getCaretPosition();
                if (LiveRangesAssistance.this.lastRangeStart != null && LiveRangesAssistance.this.lastRangeEnd != null && LiveRangesAssistance.this.isInRange(LiveRangesAssistance.this.lastRangeStart, LiveRangesAssistance.this.lastRangeEnd, curPos)) {
                    return;
                }
                LiveRangesAssistance.this.calcLiveRanges(curPos);
            }
        });
    }
}

