/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.io.IOException;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class QMakeExecSupport
extends ExecutionSupport {
    private Sheet.Set sheetSet;
    private static final String PROP_QMAKE_COMMAND = "qmakeCommand";
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private static final String PROP_ENVIRONMENT = "environment";
    private PropertySupport<String> qmakeRunDirectory;
    private PropertySupport<String> qmakeCommandProperty;
    private PropertySupport<String> qmakeEnvironmentProperty;

    public QMakeExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    public FileObject getFileObject() {
        return this.getEntry().getFile();
    }

    private void createProperties() {
        if (this.qmakeCommandProperty == null) {
            this.qmakeCommandProperty = this.createQMakeCommandProperty();
            this.qmakeRunDirectory = this.createRunDirectoryProperty();
            this.qmakeEnvironmentProperty = this.createEnvironmentProperty(PROP_ENVIRONMENT, QMakeExecSupport.getString("PROP_QMAKE_ENVIRONMENT"), QMakeExecSupport.getString("HINT_QMAKE_ENVIRONMENT"));
        }
    }

    @Override
    public void addProperties(Sheet.Set set) {
        this.createProperties();
        this.sheetSet = set;
        set.put(this.createParamsProperty("params", QMakeExecSupport.getString("PROP_QMAKE_PARAMS"), QMakeExecSupport.getString("HINT_QMAKE_PARAMS")));
        set.put(this.qmakeRunDirectory);
        set.put(this.qmakeCommandProperty);
        set.put(this.qmakeEnvironmentProperty);
    }

    private PropertySupport<String> createQMakeCommandProperty() {
        PropertySupport.ReadWrite<String> result = new PropertySupport.ReadWrite<String>(PROP_QMAKE_COMMAND, String.class, QMakeExecSupport.getString("PROP_QMAKE_COMMAND"), QMakeExecSupport.getString("HINT_QMAKE_COMMAND")){

            public String getValue() {
                return QMakeExecSupport.this.getQMakeCommand();
            }

            public void setValue(String val) {
                QMakeExecSupport.this.setQMakeCommand(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return QMakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        result.setValue("oneline", (Object)Boolean.TRUE);
        return result;
    }

    public String getQMakeCommand() {
        String make = (String)this.getEntry().getFile().getAttribute(PROP_QMAKE_COMMAND);
        if (make == null || make.equals("")) {
            make = "qmake";
            this.setQMakeCommand(make);
        }
        return make;
    }

    public void setQMakeCommand(String make) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_QMAKE_COMMAND, (Object)make);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createRunDirectoryProperty() {
        PropertySupport.ReadWrite<String> result = new PropertySupport.ReadWrite<String>(PROP_RUN_DIRECTORY, String.class, QMakeExecSupport.getString("PROP_RUN_QMAKE_DIRECTORY"), QMakeExecSupport.getString("HINT_RUN_QMAKE_DIRECTORY")){

            public String getValue() {
                return QMakeExecSupport.this.getRunDirectory();
            }

            public void setValue(String val) {
                QMakeExecSupport.this.setRunDirectory(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return QMakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        result.setValue("oneline", (Object)Boolean.TRUE);
        return result;
    }

    public String getRunDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (dir == null) {
            dir = ".";
            this.setRunDirectory(dir);
        }
        return dir;
    }

    public void setRunDirectory(String dir) {
        block2: {
            FileObject fo = this.getEntry().getFile();
            try {
                fo.setAttribute(PROP_RUN_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private static String getString(String key) {
        return NbBundle.getBundle(QMakeExecSupport.class).getString(key);
    }
}

