/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainProject;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

final class ExternalProgramOpenCookie
implements OpenCookie {
    private final DataObject dao;
    private final String[] programs;
    private final String failmsg;

    public ExternalProgramOpenCookie(DataObject dao, String[] programs, String failmsg) {
        Parameters.notNull((CharSequence)"dao", (Object)dao);
        Parameters.notNull((CharSequence)"program", (Object)programs);
        this.dao = dao;
        this.programs = programs;
        this.failmsg = failmsg;
    }

    public void open() {
        String qmakePath = this.getQmakePath();
        String tool = null;
        if (qmakePath != null) {
            File dir = new File(qmakePath);
            for (String program : this.programs) {
                File file = Utilities.isWindows() ? new File(dir, program + ".exe") : new File(dir, program);
                if (!file.exists()) continue;
                tool = file.getAbsolutePath();
                break;
            }
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.programs));
        if (tool != null) {
            list.add(tool);
        }
        boolean success = false;
        for (String program : list) {
            ProcessBuilder pb = new ProcessBuilder(program, this.dao.getPrimaryFile().getPath());
            boolean bl = success = ProcessUtils.execute((ProcessBuilder)pb).exitCode >= 0;
            if (!success && Utilities.isMac()) {
                pb = new ProcessBuilder("open", "-a", program, this.dao.getPrimaryFile().getPath());
                success = ProcessUtils.execute((ProcessBuilder)pb).isOK();
            }
            if (!success) continue;
            break;
        }
        if (!success && this.failmsg != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.failmsg));
        }
    }

    private String getQmakePath() {
        Tool qmake;
        ToolchainProject toolchain;
        Project project = FileOwnerQuery.getOwner((FileObject)this.dao.getPrimaryFile());
        CompilerSet set = null;
        if (project != null && (toolchain = (ToolchainProject)project.getLookup().lookup(ToolchainProject.class)) != null) {
            set = toolchain.getCompilerSet();
        }
        if (set == null) {
            set = CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getDefaultCompilerSet();
        }
        if (set != null && (qmake = set.findTool((ToolKind)PredefinedToolKind.QMakeTool)) != null) {
            return CndPathUtilities.getDirName((String)qmake.getPath());
        }
        return null;
    }
}

