/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.io.IOException;
import nu.validator.htmlparser.annotation.NoLength;
import nu.validator.htmlparser.common.ByteReadable;
import nu.validator.htmlparser.impl.Portability;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.xml.sax.SAXException;

public abstract class MetaScanner {
    @NoLength
    private static final char[] CHARSET = "charset".toCharArray();
    @NoLength
    private static final char[] CONTENT = "content".toCharArray();
    private static final int NO = 0;
    private static final int M = 1;
    private static final int E = 2;
    private static final int T = 3;
    private static final int A = 4;
    private static final int DATA = 0;
    private static final int TAG_OPEN = 1;
    private static final int SCAN_UNTIL_GT = 2;
    private static final int TAG_NAME = 3;
    private static final int BEFORE_ATTRIBUTE_NAME = 4;
    private static final int ATTRIBUTE_NAME = 5;
    private static final int AFTER_ATTRIBUTE_NAME = 6;
    private static final int BEFORE_ATTRIBUTE_VALUE = 7;
    private static final int ATTRIBUTE_VALUE_DOUBLE_QUOTED = 8;
    private static final int ATTRIBUTE_VALUE_SINGLE_QUOTED = 9;
    private static final int ATTRIBUTE_VALUE_UNQUOTED = 10;
    private static final int AFTER_ATTRIBUTE_VALUE_QUOTED = 11;
    private static final int MARKUP_DECLARATION_OPEN = 13;
    private static final int MARKUP_DECLARATION_HYPHEN = 14;
    private static final int COMMENT_START = 15;
    private static final int COMMENT_START_DASH = 16;
    private static final int COMMENT = 17;
    private static final int COMMENT_END_DASH = 18;
    private static final int COMMENT_END = 19;
    private static final int SELF_CLOSING_START_TAG = 20;
    protected ByteReadable readable = null;
    private int metaState = 0;
    private int contentIndex = -1;
    private int charsetIndex = -1;
    protected int stateSave = 0;
    private int strBufLen = 0;
    private char[] strBuf = new char[36];

    protected int read() throws IOException {
        return this.readable.readByte();
    }

    protected final void stateLoop(int state) throws SAXException, IOException {
        int n = -1;
        boolean reconsume = false;
        block129: while (true) {
            switch (state) {
                case 0: {
                    int n2;
                    block130: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 60: {
                                state = 1;
                                break block130;
                            }
                            default: {
                                continue block130;
                            }
                        }
                        break;
                    }
                }
                case 1: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block129;
                        }
                        case 77: 
                        case 109: {
                            this.metaState = 1;
                            state = 3;
                            break;
                        }
                        case 33: {
                            state = 13;
                            continue block129;
                        }
                        case 47: 
                        case 63: {
                            state = 2;
                            continue block129;
                        }
                        case 62: {
                            state = 0;
                            continue block129;
                        }
                        default: {
                            if (n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122) {
                                this.metaState = 0;
                                state = 3;
                                break;
                            }
                            state = 0;
                            reconsume = true;
                            continue block129;
                        }
                    }
                }
                case 3: {
                    int n2;
                    block131: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                state = 4;
                                break block131;
                            }
                            case 47: {
                                state = 20;
                                continue block129;
                            }
                            case 62: {
                                state = 0;
                                continue block129;
                            }
                            case 69: 
                            case 101: {
                                if (this.metaState == 1) {
                                    this.metaState = 2;
                                    continue block131;
                                }
                                this.metaState = 0;
                                continue block131;
                            }
                            case 84: 
                            case 116: {
                                if (this.metaState == 2) {
                                    this.metaState = 3;
                                    continue block131;
                                }
                                this.metaState = 0;
                                continue block131;
                            }
                            case 65: 
                            case 97: {
                                if (this.metaState == 3) {
                                    this.metaState = 4;
                                    continue block131;
                                }
                                this.metaState = 0;
                                continue block131;
                            }
                            default: {
                                this.metaState = 0;
                                continue block131;
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    int n2;
                    block132: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                continue block132;
                            }
                            case 47: {
                                state = 20;
                                continue block129;
                            }
                            case 62: {
                                state = 0;
                                continue block129;
                            }
                            case 67: 
                            case 99: {
                                this.contentIndex = 0;
                                this.charsetIndex = 0;
                                state = 5;
                                break block132;
                            }
                            default: {
                                this.contentIndex = -1;
                                this.charsetIndex = -1;
                                state = 5;
                                break block132;
                            }
                        }
                        break;
                    }
                }
                case 5: {
                    int n2;
                    block133: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                state = 6;
                                continue block129;
                            }
                            case 47: {
                                state = 20;
                                continue block129;
                            }
                            case 61: {
                                this.strBufLen = 0;
                                state = 7;
                                break block133;
                            }
                            case 62: {
                                state = 0;
                                continue block129;
                            }
                            default: {
                                if (this.metaState != 4) continue block133;
                                if (n2 >= 65 && n2 <= 90) {
                                    n2 += 32;
                                }
                                if (this.contentIndex == 6) {
                                    this.contentIndex = -1;
                                } else if (this.contentIndex > -1 && this.contentIndex < 6 && n2 == CONTENT[this.contentIndex + 1]) {
                                    ++this.contentIndex;
                                }
                                if (this.charsetIndex == 6) {
                                    this.charsetIndex = -1;
                                    continue block133;
                                }
                                if (this.charsetIndex <= -1 || this.charsetIndex >= 6 || n2 != CHARSET[this.charsetIndex + 1]) continue block133;
                                ++this.charsetIndex;
                                continue block133;
                            }
                        }
                        break;
                    }
                }
                case 7: {
                    int n2;
                    block134: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                continue block134;
                            }
                            case 34: {
                                state = 8;
                                break block134;
                            }
                            case 39: {
                                state = 9;
                                continue block129;
                            }
                            case 62: {
                                state = 0;
                                continue block129;
                            }
                            default: {
                                if (this.charsetIndex == 6 || this.contentIndex == 6) {
                                    this.addToBuffer(n2);
                                }
                                state = 10;
                                continue block129;
                            }
                        }
                        break;
                    }
                }
                case 8: {
                    int n2;
                    block135: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 34: {
                                if (this.tryCharset()) break block129;
                                state = 11;
                                break block135;
                            }
                            default: {
                                if (this.metaState != 4 || this.contentIndex != 6 && this.charsetIndex != 6) continue block135;
                                this.addToBuffer(n2);
                                continue block135;
                            }
                        }
                        break;
                    }
                }
                case 11: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block129;
                        }
                        case 9: 
                        case 10: 
                        case 12: 
                        case 32: {
                            state = 4;
                            continue block129;
                        }
                        case 47: {
                            state = 20;
                            break;
                        }
                        case 62: {
                            state = 0;
                            continue block129;
                        }
                        default: {
                            state = 4;
                            reconsume = true;
                            continue block129;
                        }
                    }
                }
                case 20: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block129;
                        }
                        case 62: {
                            state = 0;
                            continue block129;
                        }
                    }
                    state = 4;
                    reconsume = true;
                    continue block129;
                }
                case 10: {
                    int n2;
                    block136: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                if (this.tryCharset()) break block129;
                                state = 4;
                                continue block129;
                            }
                            case 62: {
                                if (this.tryCharset()) break block129;
                                state = 0;
                                continue block129;
                            }
                            default: {
                                if (this.metaState != 4 || this.contentIndex != 6 && this.charsetIndex != 6) continue block136;
                                this.addToBuffer(n2);
                                break;
                            }
                        }
                    }
                }
                case 6: {
                    int n2;
                    block137: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                continue block137;
                            }
                            case 47: {
                                if (this.tryCharset()) break block129;
                                state = 20;
                                break block137;
                            }
                            case 61: {
                                state = 7;
                                break block137;
                            }
                            case 62: {
                                if (this.tryCharset()) break block129;
                                state = 0;
                                break block137;
                            }
                            case 67: 
                            case 99: {
                                this.contentIndex = 0;
                                this.charsetIndex = 0;
                                state = 5;
                                break block137;
                            }
                            default: {
                                this.contentIndex = -1;
                                this.charsetIndex = -1;
                                state = 5;
                                break block137;
                            }
                        }
                        break;
                    }
                    continue block129;
                }
                case 13: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block129;
                        }
                        case 45: {
                            state = 14;
                            break;
                        }
                        default: {
                            state = 2;
                            reconsume = true;
                            continue block129;
                        }
                    }
                }
                case 14: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block129;
                        }
                        case 45: {
                            state = 15;
                            break;
                        }
                        default: {
                            state = 2;
                            reconsume = true;
                            continue block129;
                        }
                    }
                }
                case 15: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block129;
                        }
                        case 45: {
                            state = 16;
                            continue block129;
                        }
                        case 62: {
                            state = 0;
                            continue block129;
                        }
                    }
                    state = 17;
                }
                case 17: {
                    int n2;
                    block138: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 45: {
                                state = 18;
                                break block138;
                            }
                            default: {
                                continue block138;
                            }
                        }
                        break;
                    }
                }
                case 18: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block129;
                        }
                        case 45: {
                            state = 19;
                            break;
                        }
                        default: {
                            state = 17;
                            continue block129;
                        }
                    }
                }
                case 19: {
                    int n2;
                    block139: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 62: {
                                state = 0;
                                continue block129;
                            }
                            case 45: {
                                continue block139;
                            }
                        }
                        break;
                    }
                    state = 17;
                    continue block129;
                }
                case 16: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block129;
                        }
                        case 45: {
                            state = 19;
                            continue block129;
                        }
                        case 62: {
                            state = 0;
                            continue block129;
                        }
                    }
                    state = 17;
                    continue block129;
                }
                case 9: {
                    int n2;
                    block140: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 39: {
                                if (this.tryCharset()) break block129;
                                state = 11;
                                continue block129;
                            }
                            default: {
                                if (this.metaState != 4 || this.contentIndex != 6 && this.charsetIndex != 6) continue block140;
                                this.addToBuffer(n2);
                                break;
                            }
                        }
                    }
                }
                case 2: {
                    int n2;
                    while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block129;
                            }
                            case 62: {
                                state = 0;
                                continue block129;
                            }
                        }
                    }
                }
                default: {
                    continue block129;
                }
            }
            break;
        }
        this.stateSave = state;
    }

    private void addToBuffer(int c) {
        if (this.strBufLen == this.strBuf.length) {
            char[] newBuf = new char[this.strBuf.length + (this.strBuf.length << 1)];
            System.arraycopy(this.strBuf, 0, newBuf, 0, this.strBuf.length);
            Portability.releaseArray(this.strBuf);
            this.strBuf = newBuf;
        }
        this.strBuf[this.strBufLen++] = (char)c;
    }

    private boolean tryCharset() throws SAXException {
        String candidateEncoding;
        if (this.metaState != 4 || this.contentIndex != 6 && this.charsetIndex != 6) {
            return false;
        }
        String attVal = Portability.newStringFromBuffer(this.strBuf, 0, this.strBufLen);
        if (this.contentIndex == 6) {
            candidateEncoding = TreeBuilder.extractCharsetFromContent(attVal);
            Portability.releaseString(attVal);
        } else {
            candidateEncoding = attVal;
        }
        if (candidateEncoding == null) {
            return false;
        }
        boolean success = this.tryCharset(candidateEncoding);
        Portability.releaseString(candidateEncoding);
        this.contentIndex = -1;
        this.charsetIndex = -1;
        return success;
    }

    protected abstract boolean tryCharset(String var1) throws SAXException;
}

