/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.utils.CndNotifier;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.FingerprintScanner;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

abstract class OracleCCppCompiler
extends CCCCompiler {
    protected OracleCCppCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    protected String getCompilerFingerPrintCommand() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null) {
            return " " + compiler.getFingerPrintFlags();
        }
        return null;
    }

    @Override
    protected CCCCompiler.CompilerDefinitions getFreshCompilerDefinitions() {
        CCCCompiler.CompilerDefinitions res = new CCCCompiler.CompilerDefinitions();
        try {
            this.getSystemIncludesAndDefines(this.getCompilerFingerPrintCommand(), true, res);
            this.completePredefinedMacros(res);
        }
        catch (IOException ioe) {
            System.err.println("IOException " + ioe);
            String errormsg = this.getExecutionEnvironment().isLocal() ? NbBundle.getMessage(this.getClass(), (String)"CANTFINDCOMPILER", (Object)this.getPath()) : NbBundle.getMessage(this.getClass(), (String)"CANT_FIND_REMOTE_COMPILER", (Object)this.getPath(), (Object)this.getExecutionEnvironment().getDisplayName());
            CndNotifier.getDefault().notifyErrorLater(errormsg);
        }
        this.checkModel(res, this.getCallable());
        return res;
    }

    @Override
    protected CCCCompiler.MyCallable<CCCCompiler.CompilerDefinitions> getCallable() {
        return new CCCCompiler.MyCallable<CCCCompiler.CompilerDefinitions>(){

            @Override
            public CCCCompiler.CompilerDefinitions call(String p) {
                CCCCompiler.CompilerDefinitions tmp = new CCCCompiler.CompilerDefinitions();
                try {
                    OracleCCppCompiler.this.getSystemIncludesAndDefines(OracleCCppCompiler.this.getCompilerFingerPrintCommand() + " " + p, true, tmp);
                    OracleCCppCompiler.this.completePredefinedMacros(tmp);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                return tmp;
            }
        };
    }

    @Override
    protected void parseCompilerOutput(BufferedReader reader, CCCCompiler.CompilerDefinitions pair) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                FingerprintScanner.Result res = FingerprintScanner.scaneLine(line);
                if (res == null) continue;
                switch (res.getKind()) {
                    case SystemMacro: {
                        OracleCCppCompiler.addUnique(pair.systemPreprocessorSymbolsList, res.getResult());
                        break;
                    }
                    case SystemPath: {
                        OracleCCppCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(res.getResult()));
                        break;
                    }
                    case SystemIncludeHeader: {
                        OracleCCppCompiler.addUnique(pair.systemIncludeHeadersList, this.applyPathPrefix(res.getResult()));
                    }
                }
            }
            reader.close();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
    }
}

