/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;

public abstract class InstanceNode
extends AbstractHeapWalkerNode
implements HeapWalkerInstanceNode {
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    HeapWalkerNode loopTo;
    private Instance instance;
    private String name;
    private String details;

    public InstanceNode(Instance instance, String name, HeapWalkerNode parent) {
        this(instance, name, parent, parent == null ? 1 : parent.getMode());
    }

    public InstanceNode(Instance instance, String name, HeapWalkerNode parent, int mode) {
        super(parent, mode);
        this.instance = instance;
        this.name = name;
        this.loopTo = this.computeLoopTo();
    }

    @Override
    public abstract boolean isArray();

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public boolean isLeaf() {
        return !this.hasInstance() || this.isLoop();
    }

    @Override
    public boolean isLoop() {
        return this.getLoopTo() != null;
    }

    @Override
    public HeapWalkerNode getLoopTo() {
        return this.loopTo;
    }

    @Override
    public boolean hasInstance() {
        return this.instance != null;
    }

    @Override
    public String getDetails() {
        if (!this.hasInstance()) {
            return null;
        }
        if (this.details == null) {
            this.details = "";
            this.computeDetails();
        }
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getReferences() {
        if (this.hasInstance()) {
            List list;
            ChangeListener cl;
            block6: {
                ProgressHandle pHandle = null;
                cl = null;
                try {
                    pHandle = ProgressHandle.createHandle((String)Bundle.InstanceNode_References());
                    pHandle.setInitialDelay(200);
                    pHandle.start(1000);
                    cl = InstanceNode.setProgress(pHandle);
                    list = this.getInstance().getReferences();
                    if (pHandle == null) break block6;
                }
                catch (Throwable throwable) {
                    if (pHandle != null) {
                        pHandle.finish();
                    }
                    if (cl != null) {
                        HeapProgress.getProgress().removeChangeListener(cl);
                    }
                    throw throwable;
                }
                pHandle.finish();
            }
            if (cl != null) {
                HeapProgress.getProgress().removeChangeListener(cl);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    protected HeapWalkerNode computeLoopTo() {
        if (this.hasInstance()) {
            for (HeapWalkerNode parent = this.getParent(); parent != null && parent instanceof HeapWalkerInstanceNode; parent = parent.getParent()) {
                if (!((HeapWalkerInstanceNode)((Object)parent)).getInstance().equals(this.instance)) continue;
                return parent;
            }
        }
        return null;
    }

    @Override
    protected String computeName() {
        if (this.isLoop()) {
            return this.name + " " + Bundle.InstanceNode_LoopToString(BrowserUtils.getFullNodeName(this.getLoopTo()));
        }
        return this.name;
    }

    @Override
    protected String computeType() {
        if (!this.hasInstance()) {
            return "<object>";
        }
        return this.instance.getJavaClass().getName();
    }

    @Override
    protected String computeValue() {
        JavaClass javaClass;
        HeapWalkerNode root;
        if (!this.hasInstance()) {
            return "null";
        }
        if ("java.lang.Class".equals(this.instance.getJavaClass().getName()) && (root = BrowserUtils.getRoot(this)) instanceof RootNode && (javaClass = ((RootNode)((Object)root)).getJavaClassByID(this.instance.getInstanceId())) != null) {
            return "#" + this.instance.getInstanceNumber() + " - " + BrowserUtils.getSimpleType(javaClass.getName());
        }
        return "#" + this.instance.getInstanceNumber();
    }

    protected void computeDetails() {
        HeapWalkerNode _root = BrowserUtils.getRoot(this);
        if (_root instanceof RootNode) {
            final RootNode root = (RootNode)((Object)_root);
            BrowserUtils.performTask(new Runnable(){

                @Override
                public void run() {
                    final String d = root.getDetails(InstanceNode.this.instance);
                    if (d != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                InstanceNode.this.details = d;
                                root.repaintView();
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    protected String computeSize() {
        if (this.hasInstance()) {
            return numberFormat.format(this.instance.getSize());
        }
        return "-";
    }

    @Override
    protected String computeRetainedSize() {
        if (this.hasInstance()) {
            return numberFormat.format(this.instance.getRetainedSize());
        }
        return "-";
    }

    protected ImageIcon processLoopIcon(ImageIcon icon) {
        if (!this.isLoop()) {
            return icon;
        }
        return BrowserUtils.createLoopIcon(icon);
    }

    private static ChangeListener setProgress(final ProgressHandle pHandle) {
        final BoundedRangeModel progress = HeapProgress.getProgress();
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pHandle.progress(progress.getValue());
            }
        };
        progress.addChangeListener(cl);
        return cl;
    }

    @Override
    public Object getNodeID() {
        return this.instance;
    }
}

