/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class WrongParamNameHint
extends HintRule {
    private static final Logger LOGGER = Logger.getLogger(WrongParamNameHint.class.getName());
    private static final String HINT_ID = "wrong.param.name.hint";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.WrongParamNameHintDesc();
    }

    public String getDisplayName() {
        return Bundle.WrongParamNameHintName();
    }

    private static final class Fix
    implements HintFix {
        private final BaseDocument doc;
        private final OffsetRange offsetRange;
        private final String parameterName;

        public Fix(BaseDocument doc, OffsetRange offsetRange, String parameterName) {
            this.doc = doc;
            this.offsetRange = offsetRange;
            this.parameterName = parameterName;
        }

        public String getDescription() {
            return Bundle.WrongParamNameHintFix();
        }

        public void implement() throws Exception {
            EditList editList = new EditList(this.doc);
            editList.replace(this.offsetRange.getStart(), this.offsetRange.getLength(), this.parameterName, true, 0);
            editList.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class CommentVisitor
    extends DefaultVisitor {
        private final List<PHPDocNode> paramVariables = new ArrayList<PHPDocNode>();

        private CommentVisitor() {
        }

        @Override
        public void visit(PHPDocVarTypeTag node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.paramVariables.add(node.getVariable());
        }

        public List<PHPDocNode> getParamVariables() {
            return this.paramVariables;
        }
    }

    private final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final BaseDocument doc;
        private final List<Hint> hints;
        private Program program;

        private CheckVisitor(FileObject fileObject, BaseDocument doc) {
            this.fileObject = fileObject;
            this.doc = doc;
            this.hints = new ArrayList<Hint>();
        }

        private Collection<? extends Hint> getHints() {
            return this.hints;
        }

        @Override
        public void visit(Program program) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.program = program;
            super.visit(program);
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Comment comment = Utils.getCommentForNode(this.program, node);
            if (comment != null) {
                this.checkNodeWithComment(node, comment);
            }
        }

        private void checkNodeWithComment(FunctionDeclaration node, Comment comment) {
            CommentVisitor commentVisitor = new CommentVisitor();
            comment.accept(commentVisitor);
            List<PHPDocNode> paramVariables = commentVisitor.getParamVariables();
            List<FormalParameter> formalParameters = node.getFormalParameters();
            if (formalParameters.size() == paramVariables.size()) {
                for (int i = 0; i < paramVariables.size(); ++i) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    this.checkParametersEquality(paramVariables, formalParameters, i);
                }
            }
        }

        private void checkParametersEquality(List<PHPDocNode> paramVariables, List<FormalParameter> formalParameters, int i) {
            PHPDocNode paramVariable = paramVariables.get(i);
            String paramVariableName = paramVariable.getValue();
            FormalParameter formalParameter = formalParameters.get(i);
            Expression parameterNameExpression = formalParameter.getParameterName();
            if (parameterNameExpression instanceof Variable) {
                Variable parameterVariable = (Variable)parameterNameExpression;
                String parameterName = CodeUtils.extractVariableName(parameterVariable);
                if (StringUtils.hasText((String)paramVariableName) && !paramVariableName.equals(parameterName)) {
                    this.createHint(paramVariable, parameterName);
                }
            }
        }

        private void createHint(PHPDocNode paramVariable, String parameterName) {
            OffsetRange checkOffsetRange = new OffsetRange(paramVariable.getStartOffset(), this.getLineEnd(paramVariable));
            if (WrongParamNameHint.this.showHint(checkOffsetRange, this.doc)) {
                OffsetRange variableOffsetRange = new OffsetRange(paramVariable.getStartOffset(), paramVariable.getEndOffset());
                this.hints.add(new Hint((Rule)WrongParamNameHint.this, Bundle.WrongParamNameHintText(), this.fileObject, variableOffsetRange, Collections.singletonList(new Fix(this.doc, variableOffsetRange, parameterName)), 500));
            }
        }

        private int getLineEnd(PHPDocNode paramVariable) {
            int result = paramVariable.getEndOffset();
            try {
                result = LineDocumentUtils.getLineEnd((LineDocument)this.doc, (int)paramVariable.getStartOffset());
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return result;
        }
    }
}

