/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.mapping.ClientJavonTemplate;
import org.netbeans.modules.mobility.end2end.output.OutputLogger;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonTemplate;
import org.netbeans.modules.mobility.javon.OutputFileFormatter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ServerJavonTemplate
extends JavonTemplate {
    private static final String SERVLET = "server-servlet";
    private static final String GATEWAYS = "server-gateways";
    private static final String INVOCATION = "server-invocation";
    private static final String UTILITY = "server-utility";
    private static final String[] OUTPUTS = new String[]{"server-servlet", "server-gateways", "server-invocation", "server-utility"};
    private static final Set<String> outputSet = new HashSet<String>();

    public ServerJavonTemplate(JavonMapping mapping) {
        super(mapping);
    }

    @Override
    public Set<String> getTargets() {
        return new HashSet<String>(Arrays.asList(OUTPUTS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generateTarget(ProgressHandle ph, String target) {
        Reader is;
        OutputFileFormatter off;
        FileObject outputFile;
        block31: {
            if (!outputSet.contains(target)) {
                return true;
            }
            String templateName = "";
            String outputDirectoryName = this.mapping.getServerMapping().getOutputDirectory();
            String outputFileName = "";
            String msg = null;
            if (SERVLET.equals(target)) {
                templateName = "Templates/Server/Servlet.java";
                outputFileName = this.mapping.getServerMapping().getClassName();
                msg = NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_Servlet");
            } else if (GATEWAYS.equals(target)) {
                templateName = "Templates/Server/Gateways.java";
                outputFileName = "JavonGateways";
                msg = NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_Gateways");
            } else if (INVOCATION.equals(target)) {
                templateName = "Templates/Server/InvocationAbstraction.java";
                outputFileName = "InvocationAbstraction";
                msg = NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_Invocation");
            } else if (UTILITY.equals(target)) {
                templateName = "Templates/Server/Utility.java";
                outputFileName = "Utility";
                msg = NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_Utility");
            }
            ph.progress(msg);
            OutputLogger.getInstance().log(msg);
            this.mapping.setProperty("target", "server");
            FileObject outputRoot = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(outputDirectoryName)));
            String pckgFolder = this.mapping.getServerMapping().getPackageName().replace('.', '/');
            FileObject outputDir = outputRoot.getFileObject(pckgFolder);
            if (outputDir == null) {
                OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_ServerFolderCreation"), new File(FileUtil.toFile((FileObject)outputRoot), pckgFolder)));
                try {
                    outputDir = FileUtil.createFolder((FileObject)outputRoot, (String)pckgFolder);
                }
                catch (IOException e) {
                    OutputLogger.getInstance().log(OutputLogger.LogLevel.ERROR, MessageFormat.format(NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_FailServerFolderCreation"), new File(FileUtil.toFile((FileObject)outputRoot), pckgFolder)));
                    this.generationFailed(e, outputFileName);
                    return false;
                }
            }
            if ((outputFile = outputDir.getFileObject(outputFileName, "java")) == null) {
                OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_ServerFileCreation"), new File(FileUtil.toFile((FileObject)outputDir), outputFileName + ".java")));
                try {
                    outputFile = outputDir.createData(outputFileName, "java");
                }
                catch (IOException e) {
                    OutputLogger.getInstance().log(OutputLogger.LogLevel.ERROR, MessageFormat.format(NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_FailServerFileCreation"), new File(FileUtil.toFile((FileObject)outputDir), outputFileName + ".java")));
                    this.generationFailed(e, outputFileName);
                    return false;
                }
            }
            off = null;
            try {
                off = new OutputFileFormatter(outputFile);
            }
            catch (DataObjectNotFoundException e) {
                this.generationFailed((Exception)((Object)e), FileUtil.toFile((FileObject)outputFile));
                return false;
            }
            catch (IOException e) {
                this.generationFailed(e, FileUtil.toFile((FileObject)outputFile));
                return false;
            }
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine eng = mgr.getEngineByName("freemarker");
            Bindings bind = eng.getContext().getBindings(100);
            FileObject template = FileUtil.getConfigFile((String)templateName);
            OutputLogger.getInstance().log(NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_ConfigureBindings"));
            bind.put("mapping", (Object)this.mapping);
            bind.put("registry", (Object)this.mapping.getRegistry());
            HashSet<ClassData> returnTypes = new HashSet<ClassData>();
            HashSet<ClassData> parameterTypes = new HashSet<ClassData>();
            for (JavonMapping.Service service : this.mapping.getServiceMappings()) {
                returnTypes.addAll(service.getReturnTypes());
                parameterTypes.addAll(service.getParameterTypes());
            }
            bind.put("returnTypes", (Object)returnTypes);
            bind.put("parameterTypes", (Object)parameterTypes);
            HashSet<ClassData> instanceTypes = new HashSet<ClassData>();
            instanceTypes.addAll(returnTypes);
            instanceTypes.addAll(parameterTypes);
            bind.put("instanceTypes", (Object)instanceTypes);
            StringWriter w = null;
            is = null;
            OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_GenerateServerFile"), FileUtil.toFile((FileObject)outputFile)));
            try {
                w = new StringWriter();
                is = new InputStreamReader(template.getInputStream());
                eng.getContext().setWriter(w);
                eng.getContext().setAttribute(FileObject.class.getName(), template, 100);
                eng.getContext().setAttribute("javax.script.filename", template.getNameExt(), 100);
                eng.eval(is);
                if (w == null) break block31;
                off.write(((Object)w).toString());
            }
            catch (ScriptException e) {
                boolean bl;
                block33: {
                    try {
                        OutputLogger.getInstance().log(e);
                        ErrorManager.getDefault().notify((Throwable)e);
                        bl = false;
                        if (w == null) break block33;
                        off.write(((Object)w).toString());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (w != null) {
                                off.write(((Object)w).toString());
                                ((Writer)w).close();
                            }
                            if (is != null) {
                                is.close();
                            }
                            off.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            this.generationFailed(e2, FileUtil.toFile((FileObject)outputFile));
                            return false;
                        }
                    }
                    ((Writer)w).close();
                }
                if (is != null) {
                    is.close();
                }
                off.close();
                return bl;
            }
            ((Writer)w).close();
        }
        if (is != null) {
            is.close();
        }
        off.close();
        OpenProjects openProject = OpenProjects.getDefault();
        Project[] openedProjects = openProject.getOpenProjects();
        Project serverProject = null;
        for (Project p : openedProjects) {
            ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
            String webProjectName = pi.getName();
            if (!this.mapping.getServerMapping().getProjectName().equals(webProjectName)) continue;
            serverProject = p;
        }
        if (serverProject != null) {
            Util.addServletToWebProject(serverProject, this.mapping);
        }
        OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientJavonTemplate.class, (String)"MSG_ServerFileGenerated"), FileUtil.toFile((FileObject)outputFile)));
        return true;
    }

    private void generationFailed(Exception e, Object file) {
        OutputLogger.getInstance().log(e);
        ErrorManager.getDefault().notify((Throwable)e);
        OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ServerJavonTemplate.class, (String)"MSG_FailGenerateServerFile"), file));
    }

    static {
        for (String output : OUTPUTS) {
            outputSet.add(output);
        }
    }
}

