/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.api;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import javax.swing.JFileChooser;
import org.netbeans.modules.remotefs.versioning.spi.RemoteVcsSupportImplementation;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class RemoteVcsSupport {
    private RemoteVcsSupport() {
    }

    public static JFileChooser createFileChooser(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(file);
            return chooser;
        }
        return RemoteVcsSupport.getImpl().createFileChooser(proxy);
    }

    public static VCSFileProxy getSelectedFile(JFileChooser chooser) {
        return RemoteVcsSupport.getImpl().getSelectedFile(chooser);
    }

    public static FileSystem getFileSystem(VCSFileProxy proxy) {
        return RemoteVcsSupport.getImpl().getFileSystem(proxy);
    }

    public static FileSystem[] getFileSystems() {
        return RemoteVcsSupport.getImpl().getFileSystems();
    }

    public static FileSystem[] getConnectedFileSystems() {
        return RemoteVcsSupport.getImpl().getConnectedFileSystems();
    }

    public static FileSystem getDefaultFileSystem() {
        return RemoteVcsSupport.getImpl().getDefaultFileSystem();
    }

    public static boolean isSymlink(VCSFileProxy proxy) {
        return RemoteVcsSupport.getImpl().isSymlink(proxy);
    }

    static String readSymbolicLinkPath(VCSFileProxy file) throws IOException {
        return RemoteVcsSupport.getImpl().readSymbolicLinkPath(file);
    }

    public static boolean canRead(VCSFileProxy proxy) {
        return RemoteVcsSupport.getImpl().canRead(proxy);
    }

    public static boolean canRead(VCSFileProxy base, String subdir) {
        return RemoteVcsSupport.getImpl().canRead(base, subdir);
    }

    public static VCSFileProxy getCanonicalFile(VCSFileProxy proxy) throws IOException {
        return RemoteVcsSupport.getImpl().getCanonicalFile(proxy);
    }

    public static String getCanonicalPath(VCSFileProxy proxy) throws IOException {
        return RemoteVcsSupport.getImpl().getCanonicalPath(proxy);
    }

    public static VCSFileProxy getHome(VCSFileProxy proxy) {
        return RemoteVcsSupport.getImpl().getHome(proxy);
    }

    public static boolean isMac(VCSFileProxy proxy) {
        return RemoteVcsSupport.getImpl().isMac(proxy);
    }

    static boolean isSolaris(VCSFileProxy file) {
        return RemoteVcsSupport.getImpl().isSolaris(file);
    }

    public static boolean isUnix(VCSFileProxy proxy) {
        return RemoteVcsSupport.getImpl().isUnix(proxy);
    }

    public static long getSize(VCSFileProxy proxy) {
        return RemoteVcsSupport.getImpl().getSize(proxy);
    }

    public static String getFileSystemKey(FileSystem proxy) {
        return RemoteVcsSupport.getImpl().getFileSystemKey(proxy);
    }

    public static boolean isConnectedFileSystem(FileSystem file) {
        return RemoteVcsSupport.getImpl().isConnectedFileSystem(file);
    }

    public static void connectFileSystem(FileSystem file) {
        RemoteVcsSupport.getImpl().connectFileSystem(file);
    }

    public static String toString(VCSFileProxy proxy) {
        return RemoteVcsSupport.getImpl().toString(proxy);
    }

    public static VCSFileProxy fromString(String proxy) {
        return RemoteVcsSupport.getImpl().fromString(proxy);
    }

    public static FileSystem readFileSystem(DataInputStream is) throws IOException {
        return RemoteVcsSupport.getImpl().readFileSystem(is);
    }

    public static void writeFileSystem(DataOutputStream os, FileSystem fs) throws IOException {
        RemoteVcsSupport.getImpl().writeFileSystem(os, fs);
    }

    public static OutputStream getOutputStream(VCSFileProxy proxy) throws IOException {
        return RemoteVcsSupport.getImpl().getOutputStream(proxy);
    }

    public static void delete(VCSFileProxy file) {
        RemoteVcsSupport.getImpl().delete(file);
    }

    static void deleteExternally(VCSFileProxy file) {
        RemoteVcsSupport.getImpl().deleteExternally(file);
    }

    public static void setLastModified(VCSFileProxy file, VCSFileProxy referenceFile) {
        RemoteVcsSupport.getImpl().setLastModified(file, referenceFile);
    }

    public static void refreshFor(VCSFileProxy ... proxies) throws ConnectException, IOException {
        if (proxies.length == 0) {
            return;
        }
        if (proxies[0].toFile() != null) {
            File[] files = new File[proxies.length];
            for (int i = 0; i < proxies.length; ++i) {
                File f = proxies[i].toFile();
                assert (f != null);
                files[i] = f;
            }
            FileUtil.refreshFor((File[])files);
        } else {
            FileSystem fs = RemoteVcsSupport.getFileSystem(proxies[0]);
            String[] paths = new String[proxies.length];
            for (int i = 0; i < proxies.length; ++i) {
                paths[i] = proxies[i].getPath();
                assert (RemoteVcsSupport.getFileSystem(proxies[i]) == fs);
            }
            RemoteVcsSupport.refreshFor(fs, paths);
        }
    }

    public static void refreshFor(FileSystem fs, String ... paths) throws ConnectException, IOException {
        RemoteVcsSupport.getImpl().refreshFor(fs, paths);
    }

    private static RemoteVcsSupportImplementation getImpl() {
        RemoteVcsSupportImplementation impl = (RemoteVcsSupportImplementation)Lookup.getDefault().lookup(RemoteVcsSupportImplementation.class);
        if (impl == null) {
            throw new IllegalStateException("No provider found for " + RemoteVcsSupportImplementation.class.getName());
        }
        return impl;
    }
}

