/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor;

import java.util.Arrays;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.jade.editor.lexer.JadeTokenId;

public final class JadeCompletionContext
extends Enum<JadeCompletionContext> {
    public static final /* enum */ JadeCompletionContext NONE = new JadeCompletionContext();
    public static final /* enum */ JadeCompletionContext TAG = new JadeCompletionContext();
    public static final /* enum */ JadeCompletionContext TAG_AND_KEYWORD = new JadeCompletionContext();
    public static final /* enum */ JadeCompletionContext ATTRIBUTE = new JadeCompletionContext();
    public static final /* enum */ JadeCompletionContext CSS_ID = new JadeCompletionContext();
    public static final /* enum */ JadeCompletionContext CSS_CLASS = new JadeCompletionContext();
    private static final List<Object[]> KEYWORD_POSITION;
    private static final List<Object[]> TAG_POSITION;
    private static final List<JadeTokenId> WHITESPACES;
    private static final List<Object[]> ATTRIBUTE_POSITION;
    private static final List<Object[]> CSS_ID_POSITION;
    private static final List<Object[]> CSS_CLASS_POSITION;
    private static final /* synthetic */ JadeCompletionContext[] $VALUES;

    public static JadeCompletionContext[] values() {
        return (JadeCompletionContext[])$VALUES.clone();
    }

    public static JadeCompletionContext valueOf(String name) {
        return Enum.valueOf(JadeCompletionContext.class, name);
    }

    @NonNull
    public static JadeCompletionContext findCompletionContext(ParserResult info, int offset) {
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        boolean isEOF = false;
        if (th == null) {
            return NONE;
        }
        TokenSequence ts = th.tokenSequence(JadeTokenId.jadeLanguage());
        if (ts == null) {
            return NONE;
        }
        ts.move(offset);
        if (!ts.movePrevious()) {
            return TAG_AND_KEYWORD;
        }
        if (ts.token().id() == JadeTokenId.TAG) {
            if (!ts.movePrevious()) {
                return TAG_AND_KEYWORD;
            }
            ts.moveNext();
        }
        if (!ts.moveNext()) {
            if (ts.token() != null && ts.token().id() == JadeTokenId.EOL) {
                while ((ts.token().id() == JadeTokenId.WHITESPACE || ts.token().id() == JadeTokenId.EOL) && ts.movePrevious()) {
                }
                if (JadeCompletionContext.acceptTokenChains(ts, ATTRIBUTE_POSITION, false)) {
                    return ATTRIBUTE;
                }
                return TAG_AND_KEYWORD;
            }
            isEOF = true;
        }
        Token token = ts.token();
        JadeTokenId id = (JadeTokenId)token.id();
        String text = null;
        switch (id) {
            case ATTRIBUTE: {
                return ATTRIBUTE;
            }
            case TAG: {
                if (JadeCompletionContext.acceptTokenChains(ts, KEYWORD_POSITION, false)) {
                    return TAG_AND_KEYWORD;
                }
                return TAG;
            }
            case CSS_ID: {
                return CSS_ID;
            }
            case CSS_CLASS: {
                return CSS_CLASS;
            }
            case TEXT: {
                text = token.text().toString();
                if (!"#".equals(text) || !JadeCompletionContext.acceptTokenChains(ts, TAG_POSITION, true) && !isEOF) break;
                return CSS_ID;
            }
            case PLAIN_TEXT_DELIMITER: {
                if (JadeCompletionContext.acceptTokenChains(ts, TAG_POSITION, true)) {
                    return CSS_CLASS;
                }
                if (!isEOF) break;
                return CSS_CLASS;
            }
            case COMMENT: {
                int index;
                String commentText = token.text().toString();
                int spaces = 0;
                if (index > -1 && index < commentText.length()) {
                    char ch;
                    for (index = offset - ts.offset() - 1; index > -1 && (commentText.charAt(index) == ' ' || commentText.charAt(index) == '\t'); --index) {
                        ++spaces;
                    }
                    if (index > -1 && (ch = commentText.charAt(index)) == '\n') {
                        if (spaces == 0) {
                            return TAG_AND_KEYWORD;
                        }
                        if (ts.movePrevious() && ts.token().id() == JadeTokenId.COMMENT_DELIMITER && ts.movePrevious() && (id = (JadeTokenId)(token = ts.token()).id()) == JadeTokenId.WHITESPACE && token.length() >= spaces) {
                            return TAG_AND_KEYWORD;
                        }
                    }
                }
                return NONE;
            }
        }
        if (id.isKeyword()) {
            return TAG_AND_KEYWORD;
        }
        int helpIndex = ts.index();
        while ((id == JadeTokenId.WHITESPACE || id == JadeTokenId.EOL) && ts.movePrevious()) {
            id = (JadeTokenId)ts.token().id();
        }
        if (JadeCompletionContext.acceptTokenChains(ts, ATTRIBUTE_POSITION, helpIndex == ts.index())) {
            return ATTRIBUTE;
        }
        if (helpIndex != ts.index()) {
            ts.moveIndex(helpIndex);
            ts.moveNext();
            id = (JadeTokenId)ts.token().id();
        }
        if (JadeCompletionContext.acceptTokenChains(ts, KEYWORD_POSITION, !isEOF)) {
            return TAG_AND_KEYWORD;
        }
        if (JadeCompletionContext.acceptTokenChains(ts, TAG_POSITION, true)) {
            return TAG;
        }
        if (JadeCompletionContext.acceptTokenChains(ts, CSS_CLASS_POSITION, true)) {
            return CSS_CLASS;
        }
        if (JadeCompletionContext.acceptTokenChains(ts, CSS_ID_POSITION, true)) {
            return CSS_ID;
        }
        boolean isBeginOfLine = false;
        if (ts.movePrevious()) {
            token = ts.token();
            id = (JadeTokenId)token.id();
            if (id == JadeTokenId.WHITESPACE && ts.movePrevious()) {
                token = ts.token();
                id = (JadeTokenId)token.id();
            }
            switch (id) {
                case EOL: {
                    isBeginOfLine = true;
                    if (text == null) break;
                    if (".".equals(text)) {
                        return CSS_CLASS;
                    }
                    if (!"#".equals(text)) break;
                    return CSS_ID;
                }
                case COMMENT: {
                    return TAG_AND_KEYWORD;
                }
                case TEXT: {
                    text = token.text().toString();
                    if (!"#".equals(text) || !JadeCompletionContext.acceptTokenChains(ts, KEYWORD_POSITION, true)) break;
                    return CSS_ID;
                }
                case PLAIN_TEXT_DELIMITER: {
                    if (!JadeCompletionContext.acceptTokenChains(ts, KEYWORD_POSITION, true)) break;
                    return CSS_CLASS;
                }
            }
            while (ts.movePrevious()) {
                token = ts.token();
                id = (JadeTokenId)token.id();
                if (id == JadeTokenId.TAG) {
                    if (isBeginOfLine) {
                        return TAG_AND_KEYWORD;
                    }
                    return NONE;
                }
                if (id == JadeTokenId.ATTRIBUTE || id == JadeTokenId.BRACKET_LEFT_PAREN) {
                    return ATTRIBUTE;
                }
                if (id == JadeTokenId.EOL || id == JadeTokenId.WHITESPACE || id == JadeTokenId.JAVASCRIPT) continue;
                if (isBeginOfLine) {
                    return TAG_AND_KEYWORD;
                }
                return NONE;
            }
        }
        return NONE;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<Object[]> tokenIdChains, boolean movePrevious) {
        for (Object[] tokenIDChain : tokenIdChains) {
            if (!JadeCompletionContext.acceptTokenChain(tokenSequence, tokenIDChain, movePrevious)) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptTokenChain(TokenSequence tokenSequence, Object[] tokenIdChain, boolean movePrevious) {
        int orgTokenSequencePos = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = movePrevious ? tokenSequence.movePrevious() : true;
        for (int i = tokenIdChain.length - 1; i >= 0; --i) {
            Object tokenID = tokenIdChain[i];
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (tokenID instanceof JadeTokenId) {
                if (tokenSequence.token().id() == tokenID) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            assert (false) : "Unsupported token type: " + tokenID.getClass().getName();
        }
        tokenSequence.move(orgTokenSequencePos);
        tokenSequence.moveNext();
        return accept;
    }

    static {
        $VALUES = new JadeCompletionContext[]{NONE, TAG, TAG_AND_KEYWORD, ATTRIBUTE, CSS_ID, CSS_CLASS};
        KEYWORD_POSITION = Arrays.asList({JadeTokenId.EOL}, {JadeTokenId.EOL, JadeTokenId.WHITESPACE}, {JadeTokenId.EOL, JadeTokenId.TAG}, {JadeTokenId.EOL, JadeTokenId.WHITESPACE, JadeTokenId.TAG});
        TAG_POSITION = Arrays.asList({JadeTokenId.TAG}, {JadeTokenId.TAG, JadeTokenId.OPERATOR_COLON, JadeTokenId.WHITESPACE});
        WHITESPACES = Arrays.asList(JadeTokenId.WHITESPACE, JadeTokenId.EOL);
        ATTRIBUTE_POSITION = Arrays.asList({JadeTokenId.ATTRIBUTE}, {JadeTokenId.BRACKET_LEFT_PAREN}, {JadeTokenId.BRACKET_LEFT_PAREN, JadeTokenId.EOL}, {JadeTokenId.BRACKET_LEFT_PAREN, JadeTokenId.WHITESPACE}, {JadeTokenId.BRACKET_LEFT_PAREN, JadeTokenId.EOL, JadeTokenId.WHITESPACE}, {JadeTokenId.JAVASCRIPT, JadeTokenId.OPERATOR_COMMA}, {JadeTokenId.JAVASCRIPT, JadeTokenId.OPERATOR_COMMA, JadeTokenId.WHITESPACE}, {JadeTokenId.ATTRIBUTE, JadeTokenId.OPERATOR_ASSIGNMENT, JadeTokenId.JAVASCRIPT, JadeTokenId.WHITESPACE}, {JadeTokenId.ATTRIBUTE, JadeTokenId.OPERATOR_ASSIGNMENT, JadeTokenId.JAVASCRIPT});
        CSS_ID_POSITION = Arrays.asList({JadeTokenId.CSS_ID}, {JadeTokenId.TAG, JadeTokenId.TEXT}, {JadeTokenId.CSS_CLASS, JadeTokenId.TEXT});
        CSS_CLASS_POSITION = Arrays.asList({JadeTokenId.CSS_CLASS}, {JadeTokenId.TAG, JadeTokenId.PLAIN_TEXT_DELIMITER}, {JadeTokenId.CSS_ID, JadeTokenId.PLAIN_TEXT_DELIMITER}, {JadeTokenId.CSS_CLASS, JadeTokenId.PLAIN_TEXT_DELIMITER});
    }
}

