/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.support;

import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.spi.model.TypesProvider;
import org.openide.util.Lookup;

public final class CsmTypes {
    private CsmTypes() {
    }

    public static CsmType createType(CharSequence seq, CsmScope scope, SequenceDescriptor descriptor) {
        return CsmTypes.getProvider().createType(seq, scope, descriptor);
    }

    public static CsmType createType(CsmClassifier cls, TypeDescriptor td, OffsetDescriptor offs) {
        return CsmTypes.getProvider().createType(cls, td, offs);
    }

    public static CsmType createType(CsmType orig, TypeDescriptor newTypeDescriptor) {
        return CsmTypes.getProvider().createType(orig, newTypeDescriptor);
    }

    public static CsmType createSimpleType(CsmClassifier cls, OffsetDescriptor offs) {
        return CsmTypes.getProvider().createType(cls, new TypeDescriptor(false, false, 0, 0, 0), offs);
    }

    public static CsmType createConstType(CsmType orig) {
        return CsmTypes.getProvider().createType(orig, new TypeDescriptor(true, false, TypeDescriptor.getReferenceType(orig), orig.getPointerDepth(), orig.getArrayDepth()));
    }

    public static CsmType createDereferencedType(CsmType type) {
        int arrDepth = type.getArrayDepth();
        int ptrDepth = type.getPointerDepth();
        if (ptrDepth > 0) {
            --ptrDepth;
        } else {
            arrDepth = Math.max(arrDepth - 1, 0);
        }
        return CsmTypes.getProvider().createType(type, new TypeDescriptor(type.isConst(), type.isVolatile(), TypeDescriptor.getReferenceType(type), ptrDepth, arrDepth));
    }

    private static TypesProvider getProvider() {
        if (ProviderInstanceHolder.provider == null) {
            throw new IllegalStateException("no any avaiable org.netbeans.modules.cnd.spi.model.TypesProvider instances");
        }
        return ProviderInstanceHolder.provider;
    }

    private static final class ProviderInstanceHolder {
        private static final TypesProvider provider = (TypesProvider)Lookup.getDefault().lookup(TypesProvider.class);

        private ProviderInstanceHolder() {
        }
    }

    public static final class TypeDescriptor {
        public static final int NON_REFERENCE = 0;
        public static final int REFERENCE = 1;
        public static final int RVALUE_REFERENCE = 2;
        private final boolean _const;
        private final boolean _volatile;
        private final int _reference;
        private final int _ptrDepth;
        private final int _arrDepth;

        public static int getReferenceType(CsmType type) {
            if (type.isRValueReference()) {
                return 2;
            }
            if (type.isReference()) {
                return 1;
            }
            return 0;
        }

        public static int getReferenceType(TypeDescriptor td) {
            return td._reference;
        }

        public static int combineReferences(int ref1, int ref2) {
            if (ref1 == 1 || ref2 == 1) {
                return 1;
            }
            if (ref1 == 2 || ref2 == 2) {
                return 2;
            }
            return 0;
        }

        public TypeDescriptor(boolean _const, boolean _volatile, int _reference, int _ptrDepth, int _arrDepth) {
            this._const = _const;
            this._reference = _reference;
            this._ptrDepth = _ptrDepth;
            this._arrDepth = _arrDepth;
            this._volatile = _volatile;
        }

        public int getArrDepth() {
            return this._arrDepth;
        }

        public boolean isConst() {
            return this._const;
        }

        public boolean isVolatile() {
            return this._volatile;
        }

        public int getPtrDepth() {
            return this._ptrDepth;
        }

        public boolean isReference() {
            return this._reference > 0;
        }

        public boolean isRValueReference() {
            return this._reference > 1;
        }
    }

    public static final class OffsetDescriptor {
        private final CsmFile container;
        private final int start;
        private final int end;

        public OffsetDescriptor(CsmFile container, int start, int end) {
            this.container = container;
            this.start = start;
            this.end = end;
        }

        public CsmFile getContainer() {
            return this.container;
        }

        public int getEndOffset() {
            return this.end;
        }

        public int getStartOffset() {
            return this.start;
        }
    }

    public static final class SequenceDescriptor {
        public final String lang;
        public final String langFlavour;
        public final boolean inTypedef;
        public final boolean inTemplateDescriptor;
        public final boolean inFunctionParams;
        public final OffsetDescriptor offsets;

        public SequenceDescriptor(String lang, String langFlavour, boolean inTypedef, boolean inTemplateDescriptor, boolean inFunctionParams, OffsetDescriptor offsets) {
            this.lang = lang;
            this.langFlavour = langFlavour;
            this.inTypedef = inTypedef;
            this.inTemplateDescriptor = inTemplateDescriptor;
            this.inFunctionParams = inFunctionParams;
            this.offsets = offsets;
        }
    }
}

