/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.base.BaseExecutionDescriptor;
import org.netbeans.api.extexecution.base.Environment;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.extexecution.base.Processes;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.InputReader;
import org.netbeans.api.extexecution.base.input.InputReaderTask;
import org.netbeans.api.extexecution.base.input.InputReaders;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.modules.weblogic.common.RemoteLogInputReader;
import org.netbeans.modules.weblogic.common.api.RuntimeListener;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.spi.WebLogicTrustHandler;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class WebLogicRuntime {
    private static final Logger LOGGER = Logger.getLogger(WebLogicRuntime.class.getName());
    private static final RequestProcessor RUNTIME_RP = new RequestProcessor(WebLogicRuntime.class.getName(), 2);
    private static final Pattern LOG_PARSING_PATTERN = Pattern.compile("^####(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>)\\s+(<.*>?)(\\s+|$)");
    private static final String STARTUP_SH = "startWebLogic.sh";
    private static final String STARTUP_BAT = "startWebLogic.cmd";
    private static final String SHUTDOWN_SH = "stopWebLogic.sh";
    private static final String SHUTDOWN_BAT = "stopWebLogic.cmd";
    private static final String START_KEY_UUID = "NB_EXEC_WL_START_PROCESS_UUID";
    private static final String STOP_KEY_UUID = "NB_EXEC_WL_STOP_PROCESS_UUID";
    private static final int TIMEOUT = 300000;
    private static final int DELAY = 1000;
    private static final int CHECK_TIMEOUT = 5000;
    private static final WeakHashMap<WebLogicConfiguration, Process> PROCESSES = new WeakHashMap();
    private final WebLogicConfiguration config;

    private WebLogicRuntime(WebLogicConfiguration config) {
        this.config = config;
    }

    @NonNull
    public static WebLogicRuntime getInstance(@NonNull WebLogicConfiguration config) {
        return new WebLogicRuntime(config);
    }

    public void startAndWait(@NullAllowed BaseExecutionDescriptor.InputProcessorFactory outFactory, @NullAllowed BaseExecutionDescriptor.InputProcessorFactory errFactory, @NullAllowed Map<String, String> environment) throws InterruptedException, ExecutionException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<Exception> reference = new AtomicReference<Exception>();
        this.start(outFactory, errFactory, new BlockingListener(latch, reference, false), environment, null);
        latch.await();
        Exception exception = reference.get();
        if (exception != null) {
            throw new ExecutionException(exception);
        }
    }

    public void start(final @NullAllowed BaseExecutionDescriptor.InputProcessorFactory outFactory, final @NullAllowed BaseExecutionDescriptor.InputProcessorFactory errFactory, final @NullAllowed RuntimeListener listener, final @NullAllowed Map<String, String> environment, final @NullAllowed RunningCondition condition) {
        if (listener != null) {
            listener.onStart();
        }
        if (this.config.isRemote()) {
            if (listener != null) {
                listener.onRunning();
                listener.onExit();
            }
            return;
        }
        RUNTIME_RP.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Process process;
                    File startup;
                    File domainHome = WebLogicRuntime.this.config.getDomainHome();
                    if (!domainHome.exists() || !domainHome.isDirectory()) {
                        if (listener != null) {
                            listener.onFail();
                        }
                        return;
                    }
                    if (WebLogicRuntime.this.isRunning()) {
                        if (listener != null) {
                            listener.onRunning();
                        }
                        return;
                    }
                    long start = System.currentTimeMillis();
                    if (BaseUtilities.isWindows()) {
                        startup = new File(domainHome, WebLogicRuntime.STARTUP_BAT);
                        if (!startup.exists()) {
                            startup = new File(new File(domainHome, "bin"), WebLogicRuntime.STARTUP_BAT);
                        }
                    } else {
                        startup = new File(domainHome, WebLogicRuntime.STARTUP_SH);
                        if (!startup.exists()) {
                            startup = new File(new File(domainHome, "bin"), WebLogicRuntime.STARTUP_SH);
                        }
                    }
                    ProcessBuilder builder = ProcessBuilder.getLocal();
                    builder.setExecutable(startup.getAbsolutePath());
                    builder.setWorkingDirectory(domainHome.getAbsolutePath());
                    builder.getEnvironment().setVariable(WebLogicRuntime.START_KEY_UUID, WebLogicRuntime.this.config.getId());
                    File mwHome = WebLogicRuntime.this.config.getLayout().getMiddlewareHome();
                    if (mwHome != null) {
                        builder.getEnvironment().setVariable("MW_HOME", mwHome.getAbsolutePath());
                    }
                    WebLogicRuntime.configureEnvironment(builder.getEnvironment(), environment);
                    try {
                        process = builder.call();
                    }
                    catch (IOException ex) {
                        if (listener != null) {
                            listener.onException(ex);
                        }
                        if (listener != null) {
                            listener.onExit();
                        }
                        return;
                    }
                    WeakHashMap ex = PROCESSES;
                    synchronized (ex) {
                        PROCESSES.put(WebLogicRuntime.this.config, process);
                    }
                    if (listener != null) {
                        listener.onProcessStart();
                    }
                    ExecutorService service = Executors.newFixedThreadPool(2);
                    WebLogicRuntime.startService(service, process, outFactory, errFactory);
                    while (System.currentTimeMillis() - start < 300000L) {
                        if (condition != null && condition.isRunning() || WebLogicRuntime.this.isRunning()) {
                            if (listener != null) {
                                listener.onRunning();
                            }
                            boolean interrupted = false;
                            try {
                                process.waitFor();
                            }
                            catch (InterruptedException ex2) {
                                interrupted = true;
                            }
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            } else {
                                WebLogicRuntime.stopService(service);
                                if (listener != null) {
                                    listener.onProcessFinish();
                                }
                            }
                            if (listener != null) {
                                listener.onFinish();
                            }
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            if (listener != null) {
                                listener.onInterrupted();
                            }
                            Thread.currentThread().interrupt();
                            if (listener != null) {
                                listener.onExit();
                            }
                            return;
                        }
                    }
                    if (listener != null) {
                        listener.onTimeout();
                    }
                }
                finally {
                    if (listener != null) {
                        listener.onExit();
                    }
                }
            }
        });
    }

    public void stopAndWait(@NullAllowed BaseExecutionDescriptor.InputProcessorFactory outFactory, @NullAllowed BaseExecutionDescriptor.InputProcessorFactory errFactory) throws InterruptedException, ExecutionException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<Exception> reference = new AtomicReference<Exception>();
        this.stop(outFactory, errFactory, new BlockingListener(latch, reference, true));
        latch.await();
        Exception exception = reference.get();
        if (exception != null) {
            throw new ExecutionException(exception);
        }
    }

    public void stop(final @NullAllowed BaseExecutionDescriptor.InputProcessorFactory outFactory, final @NullAllowed BaseExecutionDescriptor.InputProcessorFactory errFactory, final @NullAllowed RuntimeListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        if (this.config.isRemote()) {
            if (listener != null) {
                listener.onRunning();
                listener.onExit();
            }
            return;
        }
        RUNTIME_RP.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block60: {
                    try {
                        block55: {
                            block56: {
                                domainHome = WebLogicRuntime.access$000(WebLogicRuntime.this).getDomainHome();
                                if (!domainHome.isDirectory()) {
                                    if (listener != null) {
                                        listener.onFail();
                                    }
                                    return;
                                }
                                shutdown = BaseUtilities.isWindows() != false ? new File(new File(domainHome, "bin"), "stopWebLogic.cmd") : new File(new File(domainHome, "bin"), "stopWebLogic.sh");
                                stopService = null;
                                stopProcess = null;
                                uuid = UUID.randomUUID().toString();
                                start = System.currentTimeMillis();
                                if (!shutdown.exists()) ** GOTO lbl52
                                builder = ProcessBuilder.getLocal();
                                builder.setExecutable(shutdown.getAbsolutePath());
                                builder.setWorkingDirectory(domainHome.getAbsolutePath());
                                builder.getEnvironment().setVariable("NB_EXEC_WL_STOP_PROCESS_UUID", uuid);
                                arguments = new ArrayList<E>();
                                arguments.add(WebLogicRuntime.access$000(WebLogicRuntime.this).getUsername());
                                arguments.add(WebLogicRuntime.access$000(WebLogicRuntime.this).getPassword());
                                arguments.add(WebLogicRuntime.access$000(WebLogicRuntime.this).getAdminURL());
                                builder.setArguments((List)arguments);
                                mwHome = WebLogicRuntime.access$000(WebLogicRuntime.this).getLayout().getMiddlewareHome();
                                if (mwHome != null) {
                                    builder.getEnvironment().setVariable("MW_HOME", mwHome.getAbsolutePath());
                                }
                                try {
                                    stopProcess = builder.call();
                                }
                                catch (IOException ex) {
                                    if (listener != null) {
                                        listener.onException(ex);
                                    }
                                    if (stopProcess != null) {
                                        mark = new HashMap<String, String>();
                                        mark.put("NB_EXEC_WL_STOP_PROCESS_UUID", uuid);
                                        Processes.killTree((Process)stopProcess, mark);
                                        WebLogicRuntime.access$400(stopService);
                                        if (listener != null) {
                                            listener.onProcessFinish();
                                        }
                                    }
                                    if (listener != null) {
                                        listener.onExit();
                                    }
                                    return;
                                }
                                if (listener != null) {
                                    listener.onProcessStart();
                                }
                                stopService = Executors.newFixedThreadPool(2);
                                WebLogicRuntime.access$300(stopService, stopProcess, outFactory, errFactory);
                                ** GOTO lbl78
lbl52:
                                // 1 sources

                                arguments = WebLogicRuntime.access$200();
                                synchronized (arguments) {
                                    process = (Process)WebLogicRuntime.access$200().get(WebLogicRuntime.access$000(WebLogicRuntime.this));
                                }
                                if (process != null) break block55;
                                if (listener != null) {
                                    listener.onFail();
                                }
                                if (stopProcess == null) break block56;
                                mark = new HashMap<K, V>();
                                mark.put("NB_EXEC_WL_STOP_PROCESS_UUID", uuid);
                                Processes.killTree(stopProcess, mark);
                                WebLogicRuntime.access$400(stopService);
                                if (listener != null) {
                                    listener.onProcessFinish();
                                }
                            }
                            return;
                        }
                        try {
                            mark = new HashMap<String, String>();
                            mark.put("NB_EXEC_WL_START_PROCESS_UUID", WebLogicRuntime.access$000(WebLogicRuntime.this).getId());
                            Processes.killTree((Process)process, mark);
lbl78:
                            // 3 sources

                            while (System.currentTimeMillis() - start < 300000L) {
                                if (!WebLogicRuntime.this.isRunning() || !WebLogicRuntime.access$500(stopProcess)) ** break block57
                                if (listener != null) {
                                    listener.onRunning();
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    if (listener != null) {
                                        listener.onInterrupted();
                                    }
                                    Thread.currentThread().interrupt();
                                    if (stopProcess != null) {
                                        mark = new HashMap<K, V>();
                                        mark.put("NB_EXEC_WL_STOP_PROCESS_UUID", uuid);
                                        Processes.killTree((Process)stopProcess, mark);
                                        WebLogicRuntime.access$400(stopService);
                                        if (listener != null) {
                                            listener.onProcessFinish();
                                        }
                                    }
                                    if (listener != null) {
                                        listener.onExit();
                                    }
                                    return;
                                }
                            }
                        }
                        catch (Throwable var14_16) {
                            if (stopProcess != null) {
                                mark = new HashMap<String, String>();
                                mark.put("NB_EXEC_WL_STOP_PROCESS_UUID", uuid);
                                Processes.killTree(stopProcess, mark);
                                WebLogicRuntime.access$400(stopService);
                                if (listener != null) {
                                    listener.onProcessFinish();
                                }
                            }
                            throw var14_16;
                        }
                        {
                            block59: {
                                block58: {
                                    if (stopProcess == null) break block58;
                                    try {
                                        stopProcess.waitFor();
                                    }
                                    catch (InterruptedException ex) {
                                        if (listener != null) {
                                            listener.onInterrupted();
                                        }
                                        Thread.currentThread().interrupt();
                                        if (stopProcess != null) {
                                            mark = new HashMap<K, V>();
                                            mark.put("NB_EXEC_WL_STOP_PROCESS_UUID", uuid);
                                            Processes.killTree((Process)stopProcess, mark);
                                            WebLogicRuntime.access$400(stopService);
                                            if (listener != null) {
                                                listener.onProcessFinish();
                                            }
                                        }
                                        if (listener != null) {
                                            listener.onExit();
                                        }
                                        return;
                                    }
                                }
                                if (WebLogicRuntime.this.isRunning()) {
                                    if (listener != null) {
                                        listener.onFail();
                                    }
                                } else if (listener != null) {
                                    listener.onFinish();
                                }
                                if (stopProcess == null) break block59;
                                mark = new HashMap<String, String>();
                                mark.put("NB_EXEC_WL_STOP_PROCESS_UUID", uuid);
                                Processes.killTree((Process)stopProcess, mark);
                                WebLogicRuntime.access$400(stopService);
                                if (listener != null) {
                                    listener.onProcessFinish();
                                }
                            }
                            return;
                        }
                        if (listener != null) {
                            listener.onTimeout();
                        }
                        if (stopProcess == null) break block60;
                        mark = new HashMap<String, String>();
                        mark.put("NB_EXEC_WL_STOP_PROCESS_UUID", uuid);
                        Processes.killTree((Process)stopProcess, mark);
                        WebLogicRuntime.access$400(stopService);
                        if (listener != null) {
                            listener.onProcessFinish();
                        }
                    }
                    finally {
                        if (listener != null) {
                            listener.onExit();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Process process;
        WeakHashMap<WebLogicConfiguration, Process> weakHashMap = PROCESSES;
        synchronized (weakHashMap) {
            process = PROCESSES.get(this.config);
        }
        if (process != null) {
            HashMap<String, String> mark = new HashMap<String, String>();
            mark.put(START_KEY_UUID, this.config.getId());
            Processes.killTree((Process)process, mark);
        }
    }

    public boolean isRunning() {
        String host = this.config.getHost();
        int port = this.config.getPort();
        return this.ping(host, port, 5000, this.config.isRemote(), this.config.isSecured());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessRunning() {
        Process proc;
        if (this.config.isRemote()) {
            return false;
        }
        WeakHashMap<WebLogicConfiguration, Process> weakHashMap = PROCESSES;
        synchronized (weakHashMap) {
            proc = PROCESSES.get(this.config);
        }
        return WebLogicRuntime.isRunning(proc);
    }

    @CheckForNull
    public InputReaderTask createLogReaderTask(final @NonNull LineProcessor processor, @NullAllowed Callable<String> nonProxy) {
        if (this.config.isRemote()) {
            return InputReaderTask.newTask((InputReader)new RemoteLogInputReader(this.config, nonProxy), (InputProcessor)InputProcessors.bridge((LineProcessor)processor));
        }
        final StringBuilder sb = new StringBuilder();
        return InputReaderTask.newTask((InputReader)InputReaders.forFileInputProvider((InputReaders.FileInput.Provider)new LogFileProvider(this.config)), (InputProcessor)InputProcessors.bridge((LineProcessor)new LineProcessor(){

            public void processLine(String line) {
                Matcher m = LOG_PARSING_PATTERN.matcher(line);
                if (m.matches()) {
                    sb.append(m.group(1)).append(" ");
                    sb.append(m.group(2)).append(" ");
                    sb.append(m.group(3)).append(" ");
                    sb.append(m.group(11)).append(" ");
                    sb.append(m.group(12)).append(" ");
                    processor.processLine(sb.toString());
                    sb.setLength(0);
                } else {
                    processor.processLine(line);
                }
            }

            public void reset() {
                processor.reset();
            }

            public void close() {
                processor.close();
            }
        }));
    }

    private static void configureEnvironment(Environment environment, Map<String, String> variables) {
        if (variables == null) {
            return;
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            environment.setVariable(entry.getKey(), entry.getValue());
        }
    }

    private static void startService(ExecutorService service, Process process, BaseExecutionDescriptor.InputProcessorFactory outFactory, BaseExecutionDescriptor.InputProcessorFactory errFactory) {
        InputProcessor output = null;
        if (outFactory != null) {
            output = outFactory.newInputProcessor();
        }
        InputProcessor error = null;
        if (errFactory != null) {
            error = errFactory.newInputProcessor();
        }
        service.submit((Runnable)InputReaderTask.newTask((InputReader)InputReaders.forStream((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()), (InputProcessor)output));
        service.submit((Runnable)InputReaderTask.newTask((InputReader)InputReaders.forStream((InputStream)process.getErrorStream(), (Charset)Charset.defaultCharset()), (InputProcessor)error));
    }

    private static void stopService(final ExecutorService service) {
        if (service != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    service.shutdownNow();
                    return null;
                }
            });
        }
    }

    private static boolean isRunning(Process process) {
        if (process == null) {
            return false;
        }
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private boolean ping(String host, int port, int timeout, boolean remote, boolean secured) {
        if (this.ping(host, port, timeout, "/console/login/LoginForm.jsp", remote, secured)) {
            return true;
        }
        return this.ping(host, port, timeout, "/console", remote, secured);
    }

    /*
     * Exception decompiling
     */
    private boolean ping(String host, int port, int timeout, String path, boolean remote, boolean secured) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Socket createSocket(String host, int port, String path, boolean remote, boolean secured) throws IOException {
        if (secured) {
            WebLogicTrustHandler provider = (WebLogicTrustHandler)Lookup.getDefault().lookup(WebLogicTrustHandler.class);
            if (provider != null) {
                try {
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(null, new TrustManager[]{provider.getTrustManager(this.config)}, new SecureRandom());
                    return context.getSocketFactory().createSocket();
                }
                catch (GeneralSecurityException ex) {
                    throw new IOException(ex);
                }
            }
            return SSLSocketFactory.getDefault().createSocket();
        }
        Proxy proxy = Proxy.NO_PROXY;
        if (remote) {
            try {
                List<Proxy> proxies = ProxySelector.getDefault().select(new URI("http://" + host + ":" + port + path));
                if (!proxies.isEmpty()) {
                    proxy = proxies.get(0);
                }
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return new Socket(proxy);
    }

    static /* synthetic */ boolean access$500(Process x0) {
        return WebLogicRuntime.isRunning(x0);
    }

    private static class BlockingListener
    implements RuntimeListener {
        private final CountDownLatch latch;
        private final AtomicReference<Exception> exception;
        private final boolean waitOnRunning;

        public BlockingListener(CountDownLatch latch, AtomicReference<Exception> exception, boolean waitOnRunning) {
            this.latch = latch;
            this.exception = exception;
            this.waitOnRunning = waitOnRunning;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public AtomicReference<Exception> getException() {
            return this.exception;
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onFinish() {
        }

        @Override
        public void onFail() {
        }

        @Override
        public void onProcessStart() {
        }

        @Override
        public void onProcessFinish() {
        }

        @Override
        public void onRunning() {
            if (!this.waitOnRunning) {
                this.latch.countDown();
            }
        }

        @Override
        public void onTimeout() {
            this.exception.set(new TimeoutException("300000 ms"));
            this.latch.countDown();
        }

        @Override
        public void onInterrupted() {
            this.exception.set(new InterruptedException());
            this.latch.countDown();
        }

        @Override
        public void onException(Exception ex) {
            this.exception.set(ex);
            this.latch.countDown();
        }

        @Override
        public void onExit() {
            this.latch.countDown();
        }
    }

    private static class LogFileProvider
    implements InputReaders.FileInput.Provider {
        private final WebLogicConfiguration config;
        private InputReaders.FileInput currentInput;

        public LogFileProvider(WebLogicConfiguration config) {
            this.config = config;
        }

        public InputReaders.FileInput getFileInput() {
            File fresh = this.config.getLogFile();
            if (this.currentInput == null) {
                this.currentInput = new InputReaders.FileInput(fresh, Charset.forName("UTF-8"));
            } else {
                File current = this.currentInput.getFile();
                if (!current.equals(fresh) && fresh.lastModified() > current.lastModified()) {
                    this.currentInput = new InputReaders.FileInput(fresh, Charset.forName("UTF-8"));
                }
            }
            return this.currentInput;
        }
    }

    public static interface RunningCondition {
        public boolean isRunning();
    }
}

