/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Color;
import java.io.File;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.spi.CsmDisplayUtilitiesProvider;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;

public class CsmDisplayUtilities {
    private static final boolean SKIP_COLORING = Boolean.getBoolean("cnd.test.skip.coloring");

    private CsmDisplayUtilities() {
    }

    public static String getContextLineHtml(CsmFile csmFile, int stToken, int endToken, boolean tokenInBold) {
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport(csmFile);
        StyledDocument stDoc = CsmUtilities.openDocument(ces);
        String displayText = null;
        if (stDoc instanceof BaseDocument) {
            BaseDocument doc = (BaseDocument)stDoc;
            try {
                int stOffset = stToken;
                int endOffset = endToken;
                int startLine = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)doc, (int)stOffset);
                int endLine = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)doc, (int)endOffset) + 1;
                if (!tokenInBold) {
                    stOffset = -1;
                    endOffset = -1;
                }
                displayText = CsmDisplayUtilities.getLineHtml(startLine, endLine, stOffset, endOffset, doc);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return displayText;
    }

    public static String getContextLine(CsmFile csmFile, int stToken, int endToken) {
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport(csmFile);
        StyledDocument stDoc = CsmUtilities.openDocument(ces);
        String displayText = null;
        if (stDoc instanceof BaseDocument) {
            BaseDocument doc = (BaseDocument)stDoc;
            try {
                int startLine = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)doc, (int)stToken);
                int endLine = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)doc, (int)endToken) + 1;
                displayText = doc.getText(startLine, endLine - startLine);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return displayText;
    }

    public static String getLineHtml(int startLine, int endLine, int stToken, int endToken, BaseDocument doc) throws BadLocationException {
        int startBold = stToken - startLine;
        int endBold = endToken - startLine;
        String content = doc.getText(startLine, endLine - startLine);
        String mime = DocumentUtilities.getMimeType((Document)doc);
        if (startBold >= 0 && endBold >= 0 && startBold <= content.length() && endBold <= content.length() && startBold < endBold) {
            StringBuilder buf = new StringBuilder();
            buf.append(CsmDisplayUtilities.getHtml(mime, CsmDisplayUtilities.trimStart(content.substring(0, startBold))));
            buf.append("<b>");
            buf.append(CsmDisplayUtilities.getHtml(mime, content.substring(startBold, endBold)));
            buf.append("</b>");
            buf.append(CsmDisplayUtilities.getHtml(mime, CsmDisplayUtilities.trimEnd(content.substring(endBold))));
            return buf.toString();
        }
        return CsmDisplayUtilities.getHtml(mime, content);
    }

    public static String getHtml(String mime, String content) {
        StringBuilder buf = new StringBuilder();
        Language lang = CndLexerUtilities.getLanguage((String)mime);
        if (lang == null) {
            return content;
        }
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)content, (Language)lang);
        TokenSequence tok = tokenH.tokenSequence();
        CsmDisplayUtilities.appendHtml(buf, tok);
        return buf.toString();
    }

    public static CharSequence getTooltipText(CsmObject item) {
        return CsmDisplayUtilitiesProvider.getDefault().getTooltipText(item);
    }

    public static CharSequence getTypeText(CsmType type, boolean expandInstantiations, boolean evaluateExpressions) {
        return CsmDisplayUtilitiesProvider.getDefault().getTypeText(type, expandInstantiations, evaluateExpressions);
    }

    private static void appendHtml(StringBuilder buf, TokenSequence<?> ts) {
        FontColorSettings settings = null;
        LanguagePath languagePath = ts.languagePath();
        while (!SKIP_COLORING && languagePath != null && settings == null) {
            String mime = languagePath.mimePath();
            Lookup lookup = MimeLookup.getLookup((String)mime);
            settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        }
        while (ts.moveNext()) {
            Token token = ts.token();
            TokenSequence es = ts.embedded();
            if (es != null && es.language() == CppTokenId.languagePreproc()) {
                CsmDisplayUtilities.appendHtml(buf, es);
                continue;
            }
            String category = token.id().primaryCategory();
            if (category == null) {
                category = "whitespace";
            }
            String text = "whitespace".equals(category) ? " " : token.text().toString();
            if (settings != null) {
                AttributeSet set = settings.getTokenFontColors(category);
                buf.append(CsmDisplayUtilities.addHTMLColor(CsmDisplayUtilities.htmlize(text), set));
                continue;
            }
            buf.append(CsmDisplayUtilities.htmlize(text));
        }
    }

    public static String htmlize(CharSequence input) {
        if (input == null) {
            System.err.println("null string");
            return "";
        }
        String temp = input.toString().replace("&", "&amp;");
        temp = temp.replace("<", "&lt;");
        if ((temp = temp.replace(">", "&gt;")).indexOf(10) > 0) {
            return "<pre>" + temp + "</pre>";
        }
        return temp;
    }

    public static String addHTMLColor(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuilder buf = new StringBuilder(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + CsmDisplayUtilities.getHTMLColor(LFCustoms.getForeground((AttributeSet)set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    public static String getHTMLColor(Color c) {
        String colorR = "0" + Integer.toHexString(c.getRed());
        colorR = colorR.substring(colorR.length() - 2);
        String colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = colorG.substring(colorG.length() - 2);
        String colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = colorB.substring(colorB.length() - 2);
        String html_color = "#" + colorR + colorG + colorB;
        return html_color;
    }

    private static String trimStart(String s) {
        for (int x = 0; x < s.length(); ++x) {
            if (Character.isWhitespace(s.charAt(x))) continue;
            return s.substring(x, s.length());
        }
        return "";
    }

    private static String trimEnd(String s) {
        for (int x = s.length() - 1; x >= 0; --x) {
            if (Character.isWhitespace(s.charAt(x))) continue;
            return s.substring(0, x + 1);
        }
        return "";
    }

    public static String shrinkPath(CharSequence path, int maxDisplayedDirLen, int nrDisplayedFrontDirs, int nrDisplayedTrailingDirs) {
        return CsmDisplayUtilities.shrinkPath(path, true, File.separator, maxDisplayedDirLen, nrDisplayedFrontDirs, nrDisplayedTrailingDirs);
    }

    public static String shrinkPath(CharSequence path, boolean shrink, String separator, int maxDisplayedDirLen, int nrDisplayedFrontDirs, int nrDisplayedTrailingDirs) {
        String SLASH = "/";
        StringBuilder builder = new StringBuilder(path);
        String toReplace = null;
        if ("/".equals(separator)) {
            if (builder.indexOf("\\") >= 0) {
                toReplace = "\\";
            }
        } else if (builder.indexOf("/") >= 0) {
            toReplace = "/";
        }
        if (toReplace != null) {
            builder = new StringBuilder(builder.toString().replace(toReplace, separator));
        }
        int len = builder.length();
        if (shrink && len > maxDisplayedDirLen) {
            StringBuilder reverse = new StringBuilder(builder).reverse();
            int st = builder.indexOf(separator);
            st = st < 0 ? 0 : ++st;
            int end = 0;
            while (reverse.charAt(end) == separator.charAt(0)) {
                ++end;
            }
            int firstSlash = nrDisplayedFrontDirs > 0 ? Integer.MAX_VALUE : -1;
            for (int i = nrDisplayedFrontDirs; i > 0 && firstSlash > 0; --i) {
                firstSlash = builder.indexOf(separator, st);
                st = firstSlash + 1;
            }
            int lastSlash = nrDisplayedTrailingDirs > 0 ? Integer.MAX_VALUE : -1;
            for (int i = nrDisplayedTrailingDirs; i > 0 && lastSlash > 0; --i) {
                lastSlash = reverse.indexOf(separator, end);
                end = lastSlash + 1;
            }
            if (lastSlash > 0 && firstSlash > 0 && firstSlash < (lastSlash = len - lastSlash) - 1) {
                builder.replace(firstSlash, lastSlash - 1, "...");
            }
        }
        return builder.toString();
    }
}

