/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.modules.cnd.modelutil.CsmFontColorManager;
import org.netbeans.modules.cnd.modelutil.ExceptionStr;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.modelutil.ParamStr;
import org.netbeans.swing.plaf.LFCustoms;

public abstract class CsmPaintComponent
extends JPanel {
    DrawState drawState = new DrawState();
    protected Font drawFont;
    private static final int ICON_WIDTH = 16;
    private static final int ICON_TEXT_GAP = 5;
    private int fontHeight;
    private int ascent;
    private FontMetrics fontMetrics;
    protected boolean isSelected;
    private ArrayList<PostfixString> postfixes;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    private static final Color KEYWORD_COLOR = Color.gray;
    private static final Color POSTFIX_COLOR = Color.lightGray;
    private Icon icon;
    protected int modifiers = 0;
    private static Border BORDER = BorderFactory.createEmptyBorder(0, 3, 0, 3);
    private static LayoutManager layout = new FlowLayout();

    public CsmPaintComponent() {
        super(layout, true);
        this.setBorder(BORDER);
        this.postfixes = new ArrayList();
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void paintComponent(Graphics g) {
        Color postfixColor = LFCustoms.shiftColor((Color)POSTFIX_COLOR);
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        this.draw(g);
        if (!this.postfixes.isEmpty()) {
            this.drawString(g, (CharSequence)" (", postfixColor);
            Iterator<PostfixString> iter = this.postfixes.iterator();
            while (iter.hasNext()) {
                iter.next().Draw(g);
                if (!iter.hasNext()) continue;
                this.drawString(g, (CharSequence)",  ", postfixColor);
            }
            this.drawString(g, (CharSequence)")", postfixColor);
        }
    }

    public void appendPostfix(String text, Color c, int font) {
        this.postfixes.add(new PostfixString(text, c, font));
    }

    public void removePostfixes() {
        this.postfixes.clear();
    }

    public boolean hasPostfixes() {
        return !this.postfixes.isEmpty();
    }

    protected abstract void draw(Graphics var1);

    @Override
    public abstract String toString();

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    protected void drawIcon(Graphics g, Icon icon) {
        Insets i = this.getInsets();
        if (i != null) {
            this.drawState.drawX = i.left;
            this.drawState.drawY = i.top;
        } else {
            this.drawState.drawX = 0;
            this.drawState.drawY = 0;
        }
        if (icon != null) {
            if (g != null) {
                icon.paintIcon(this, g, this.drawState.drawX, this.drawState.drawY);
            }
            this.drawState.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawState.drawHeight = this.fontHeight;
        }
        this.drawState.drawX += 21;
        if (i != null) {
            this.drawState.drawHeight += i.bottom;
        }
        this.drawState.drawHeight += this.drawState.drawY;
        this.drawState.drawY += this.ascent;
    }

    protected void drawString(Graphics g, CharSequence s) {
        this.drawString(g, s, false);
    }

    protected void drawString(Graphics g, CharSequence s, boolean strike) {
        if (g != null) {
            g.setColor(this.getForeground());
        }
        this.drawStringToGraphics(g, s, null, strike);
    }

    protected void drawString(Graphics g, CharSequence s, Color c) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
        }
        this.drawStringToGraphics(g, s);
    }

    protected void drawString(Graphics g, CharSequence s, Color c, Font font, boolean strike) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
            g.setFont(font);
        }
        this.drawStringToGraphics(g, s, font, strike);
        if (g != null) {
            g.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics g, String s, Color c) {
        if (g == null) {
            this.drawString(g, "   ");
            this.drawString(g, (CharSequence)s, c);
        } else {
            int spaceWidth;
            int w = this.getWidth() - this.getWidth(s) - this.drawState.drawX;
            if (w > (spaceWidth = this.getWidth(" ")) * 2) {
                this.drawState.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s);
            } else {
                this.drawState.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s) - this.getWidth("...   ");
                g.setColor(this.getBackground());
                g.fillRect(this.drawState.drawX, 0, this.getWidth() - this.drawState.drawX, this.getHeight());
                this.drawString(g, (CharSequence)"...   ", c);
            }
            this.drawString(g, (CharSequence)s, c);
        }
    }

    protected void drawStringToGraphics(Graphics g, CharSequence s) {
        this.drawStringToGraphics(g, s, null, false);
    }

    protected void drawStringToGraphics(Graphics g, CharSequence s, Font font, boolean strike) {
        String str;
        String string = str = s != null ? s.toString() : "";
        if (g != null) {
            if (!strike) {
                g.drawString(str, this.drawState.drawX, this.drawState.drawY);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AttributedString strikeText = new AttributedString(str);
                strikeText.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                strikeText.addAttribute(TextAttribute.FONT, g.getFont());
                g2.drawString(strikeText.getIterator(), this.drawState.drawX, this.drawState.drawY);
            }
        }
        this.drawState.drawX += this.getWidth(str, font);
    }

    protected int getWidth(String s) {
        return this.fontMetrics.stringWidth(s);
    }

    protected int getWidth(String s, Font font) {
        if (font == null) {
            return this.getWidth(s);
        }
        return this.getFontMetrics(font).stringWidth(s);
    }

    protected Color getColor(CharSequence s, Color defaultColor) {
        return this.isSelected ? this.getForeground() : defaultColor;
    }

    private void storeWidth(String s) {
        this.fontMetrics.stringWidth(s);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    @Override
    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawState.drawX += i.right;
        }
        if (this.drawState.drawX > this.getMaximumSize().width) {
            this.drawState.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawState.drawX, this.drawState.drawHeight);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    DrawState getDrawState() {
        return this.drawState;
    }

    void setDrawState(DrawState drawState) {
        this.drawState = drawState;
    }

    public static class StringPaintComponent
    extends CsmPaintComponent {
        private String str;

        public void setString(String str) {
            this.str = str;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, null);
            this.drawString(g, (CharSequence)this.str, LFCustoms.getTextFgColor());
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static class CsmPaintComponentWrapper
    extends CsmPaintComponent {
        private CsmPaintComponent comp;
        private boolean drawTypeAsPrefix = true;

        public void setCsmComponent(CsmPaintComponent comp) {
            this.comp = comp;
        }

        @Override
        protected void draw(Graphics g) {
            if (this.comp != null) {
                if (this.drawTypeAsPrefix) {
                    if (this.comp instanceof FieldPaintComponent) {
                        ((FieldPaintComponent)this.comp).setDrawTypeAsPrefix(true);
                    } else if (this.comp instanceof MethodPaintComponent) {
                        ((MethodPaintComponent)this.comp).setDrawTypeAsPrefix(true);
                    }
                }
                this.comp.draw(g);
                if (this.drawTypeAsPrefix) {
                    if (this.comp instanceof FieldPaintComponent) {
                        ((FieldPaintComponent)this.comp).setDrawTypeAsPrefix(false);
                    } else if (this.comp instanceof MethodPaintComponent) {
                        ((MethodPaintComponent)this.comp).setDrawTypeAsPrefix(false);
                    }
                }
                this.setDrawState(this.comp.getDrawState());
            }
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.comp != null) {
                this.comp.setFont(font);
            }
        }

        @Override
        public String toString() {
            if (this.comp != null) {
                return this.comp.toString();
            }
            return "";
        }
    }

    public static class GlobalFunctionPaintComponent
    extends MethodPaintComponent {
        private Color FUN_COLOR = LFCustoms.getTextFgColor();

        @Override
        public Color getNameColor() {
            return this.FUN_COLOR;
        }
    }

    public static class FileLocalFunctionPaintComponent
    extends MethodPaintComponent {
        private Color FUN_COLOR = LFCustoms.getTextFgColor();

        @Override
        public Color getNameColor() {
            return this.FUN_COLOR;
        }
    }

    public static class MethodPaintComponent
    extends ConstructorPaintComponent {
        private Color METHOD_COLOR = LFCustoms.getTextFgColor();
        private String typeName;
        private Color typeColor;
        private boolean drawTypeAsPrefix = false;

        public Color getNameColor() {
            return this.METHOD_COLOR;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public void setTypeColor(Color typeColor) {
            this.typeColor = typeColor;
        }

        public void setDrawTypeAsPrefix(boolean asPrefix) {
            this.drawTypeAsPrefix = asPrefix;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            if (this.drawTypeAsPrefix) {
                this.drawString(g, this.getTypeName(), this.getTypeColor(), null, strike);
                this.drawString(g, (CharSequence)" ", strike);
            }
            if ((this.getModifiers() & 0x100) != 0) {
                this.drawString(g, this.getName(), this.getNameColor(), new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), strike);
            } else {
                this.drawString(g, this.getName(), this.getNameColor(), null, strike);
            }
            this.drawParameterList(g, this.getParamList(), strike);
            if (!this.drawTypeAsPrefix) {
                this.drawTypeName(g, this.getTypeName(), this.getTypeColor());
            }
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.drawTypeAsPrefix) {
                buf.append(this.getTypeName());
                buf.append(' ');
            }
            buf.append(this.getName());
            buf.append(this.toStringParameterList(this.getParamList()));
            if (!this.drawTypeAsPrefix) {
                buf.append(' ');
                buf.append(this.getTypeName());
            }
            return buf.toString();
        }
    }

    public static class ConstructorPaintComponent
    extends CsmPaintComponent {
        private Color CONSTRUCTOR_COLOR = LFCustoms.shiftColor((Color)Color.orange);
        private Color PARAMETER_NAME_COLOR = LFCustoms.shiftColor((Color)new Color(227, 166, 74));
        private List<ParamStr> params = new ArrayList<ParamStr>();
        private List<ExceptionStr> excs = new ArrayList<ExceptionStr>();
        private String name;

        public int getMethodModifiers() {
            return this.modifiers;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public void setParams(List<ParamStr> params) {
            this.params = params;
        }

        public void setExceptions(List<ExceptionStr> excs) {
            this.excs = excs;
        }

        protected List<ParamStr> getParamList() {
            return this.params;
        }

        protected List<ExceptionStr> getExceptionList() {
            return this.excs;
        }

        protected void drawParameter(Graphics g, ParamStr prm) {
            this.drawParameter(g, prm, false);
        }

        protected void drawParameter(Graphics g, ParamStr prm, boolean strike) {
            String parmName = prm.getName();
            String simpleTypeName = prm.getSimpleTypeName();
            int indexOfSqr = simpleTypeName.indexOf(91);
            if (indexOfSqr == -1) {
                this.drawString(g, simpleTypeName, prm.getTypeColor(), null, strike);
                if (parmName != null && parmName.length() > 0) {
                    this.drawString(g, (CharSequence)" ", strike);
                    this.drawString(g, parmName, this.PARAMETER_NAME_COLOR, null, strike);
                }
            } else {
                this.drawString(g, simpleTypeName.substring(0, indexOfSqr), prm.getTypeColor(), null, strike);
                if (parmName != null && parmName.length() > 0) {
                    this.drawString(g, (CharSequence)" ", strike);
                    this.drawString(g, parmName, this.PARAMETER_NAME_COLOR, null, strike);
                }
                this.drawString(g, simpleTypeName.substring(indexOfSqr), prm.getTypeColor(), null, strike);
            }
        }

        protected void drawParameterList(Graphics g, List<ParamStr> prmList) {
            this.drawParameterList(g, prmList, false);
        }

        protected void drawParameterList(Graphics g, List<ParamStr> prmList, boolean strike) {
            this.drawString(g, (CharSequence)"(", strike);
            Iterator<ParamStr> it = prmList.iterator();
            while (it.hasNext()) {
                this.drawParameter(g, it.next(), strike);
                if (!it.hasNext()) continue;
                this.drawString(g, (CharSequence)", ", strike);
            }
            this.drawString(g, (CharSequence)")", strike);
        }

        protected void drawExceptions(Graphics g, List<ExceptionStr> exc, boolean strike) {
            if (exc.size() > 0) {
                this.drawString(g, CsmPaintComponent.THROWS, LFCustoms.shiftColor((Color)KEYWORD_COLOR), null, strike);
                Iterator<ExceptionStr> it = exc.iterator();
                while (it.hasNext()) {
                    ExceptionStr ex = it.next();
                    this.drawString(g, ex.getName(), ex.getTypeColor(), null, strike);
                    if (!it.hasNext()) continue;
                    this.drawString(g, (CharSequence)", ", strike);
                }
            }
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.getName(), this.CONSTRUCTOR_COLOR, null, strike);
            this.drawParameterList(g, this.getParamList(), strike);
            this.drawExceptions(g, this.getExceptionList(), strike);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getName());
            buf.append(this.toStringParameterList(this.getParamList()));
            buf.append(this.toStringExceptions(this.getExceptionList()));
            return buf.toString();
        }

        protected String toStringParameter(ParamStr prm) {
            StringBuilder builder = new StringBuilder();
            String parmName = prm.getName();
            String simpleTypeName = prm.getSimpleTypeName();
            int indexOfSqr = simpleTypeName.indexOf(91);
            if (indexOfSqr == -1) {
                builder.append(simpleTypeName);
                if (parmName != null && parmName.length() > 0) {
                    builder.append(" ").append(parmName);
                }
            } else {
                builder.append(simpleTypeName.substring(0, indexOfSqr));
                if (parmName != null && parmName.length() > 0) {
                    builder.append(" ").append(parmName);
                }
                builder.append(simpleTypeName.substring(indexOfSqr));
            }
            return builder.toString();
        }

        protected String toStringParameterList(List<ParamStr> prmList) {
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            Iterator<ParamStr> it = prmList.iterator();
            while (it.hasNext()) {
                buf.append(this.toStringParameter(it.next()));
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(')');
            return buf.toString();
        }

        protected String toStringExceptions(List<ExceptionStr> exc) {
            StringBuilder buf = new StringBuilder();
            if (exc.size() > 0) {
                buf.append(CsmPaintComponent.THROWS);
                Iterator<ExceptionStr> it = exc.iterator();
                while (it.hasNext()) {
                    ExceptionStr ex = it.next();
                    buf.append(ex.getName());
                    if (!it.hasNext()) continue;
                    buf.append(", ");
                }
            }
            return buf.toString();
        }
    }

    public static class LabelPaintComponent
    extends CsmPaintComponent {
        private Color LABEL_NAME_COLOR = LFCustoms.getTextFgColor();
        private List<CharSequence> params = null;
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public void setParams(List<CharSequence> params) {
            this.params = params;
        }

        protected List<CharSequence> getParamList() {
            return this.params;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.getName(), this.LABEL_NAME_COLOR, null, strike);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getName());
            return buf.toString();
        }
    }

    public static class TemplateParameterPaintComponent
    extends CsmPaintComponent {
        private Color PARAMETER_NAME_COLOR = LFCustoms.getTextFgColor();
        private List<CharSequence> params = null;
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public void setParams(List<CharSequence> params) {
            this.params = params;
        }

        protected List<CharSequence> getParamList() {
            return this.params;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.getName(), this.PARAMETER_NAME_COLOR, null, strike);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getName());
            return buf.toString();
        }
    }

    public static class MacroPaintComponent
    extends CsmPaintComponent {
        private Color MACRO_NAME_COLOR = CsmFontColorManager.instance().getColor(FontColorProvider.Entity.DEFINED_MACRO);
        private Color MACRO_PARAMETER_NAME_COLOR = LFCustoms.shiftColor((Color)new Color(227, 166, 74));
        private List<CharSequence> params = null;
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public void setParams(List<CharSequence> params) {
            this.params = params;
        }

        protected List<CharSequence> getParamList() {
            return this.params;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.getName(), this.MACRO_NAME_COLOR, null, strike);
            this.drawParameterList(g, this.getParamList(), strike);
        }

        protected void drawParameterList(Graphics g, List<CharSequence> prmList, boolean strike) {
            if (prmList == null || prmList.size() == 0) {
                return;
            }
            this.drawString(g, (CharSequence)"(", strike);
            Iterator<CharSequence> it = prmList.iterator();
            while (it.hasNext()) {
                this.drawString(g, it.next(), this.MACRO_PARAMETER_NAME_COLOR, null, strike);
                if (!it.hasNext()) continue;
                this.drawString(g, (CharSequence)", ", strike);
            }
            this.drawString(g, (CharSequence)")", strike);
        }

        protected String toStringParameterList(List<CharSequence> prmList) {
            if (prmList == null || prmList.size() == 0) {
                return "";
            }
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            Iterator<CharSequence> it = prmList.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(')');
            return buf.toString();
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getName());
            buf.append(this.toStringParameterList(this.getParamList()));
            return buf.toString();
        }
    }

    public static class GlobalVariablePaintComponent
    extends FieldPaintComponent {
        private Color VARIABLE_COLOR = LFCustoms.shiftColor((Color)new Color(64, 64, 255));

        @Override
        public Color getNameColor() {
            return this.VARIABLE_COLOR;
        }
    }

    public static class FileLocalVariablePaintComponent
    extends FieldPaintComponent {
        private Color VARIABLE_COLOR = LFCustoms.shiftColor((Color)new Color(64, 64, 255));

        @Override
        public Color getNameColor() {
            return this.VARIABLE_COLOR;
        }
    }

    public static class LocalVariablePaintComponent
    extends FieldPaintComponent {
        private Color VARIABLE_COLOR = LFCustoms.shiftColor((Color)new Color(255, 64, 64));

        public LocalVariablePaintComponent() {
            this.modifiers |= 0x100 | this.modifiers;
        }

        @Override
        public Color getNameColor() {
            return this.VARIABLE_COLOR;
        }

        @Override
        public void setModifiers(int modifiers) {
            super.setModifiers(modifiers | 0x100);
        }
    }

    public static class FieldPaintComponent
    extends CsmPaintComponent {
        private Color FIELD_COLOR = CsmFontColorManager.instance().getColor(FontColorProvider.Entity.CLASS_FIELD);
        protected String typeName;
        protected Color typeColor;
        protected String fldName;
        private boolean drawTypeAsPrefix = false;

        public Color getNameColor() {
            return this.FIELD_COLOR;
        }

        @Override
        public void setName(String fldName) {
            this.fldName = fldName;
        }

        public void setTypeColor(Color typeColor) {
            this.typeColor = typeColor;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setDrawTypeAsPrefix(boolean asPrefix) {
            this.drawTypeAsPrefix = asPrefix;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            if (this.drawTypeAsPrefix) {
                this.drawString(g, this.getTypeName(), this.getTypeColor(), null, strike);
                this.drawString(g, (CharSequence)" ", strike);
            }
            if ((this.modifiers & 0x100) != 0) {
                this.drawString(g, this.fldName, this.getNameColor(), new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), strike);
            } else {
                this.drawString(g, this.fldName, this.getNameColor(), null, strike);
            }
            if (!this.drawTypeAsPrefix) {
                this.drawTypeName(g, this.getTypeName(), this.getTypeColor());
            }
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.drawTypeAsPrefix) {
                buf.append(this.typeName);
                buf.append(' ');
            }
            buf.append(this.fldName);
            if (!this.drawTypeAsPrefix) {
                buf.append(' ');
                buf.append(this.typeName);
            }
            return buf.toString();
        }
    }

    public static class UnionPaintComponent
    extends ClassPaintComponent {
        private Color UNION_COLOR = LFCustoms.shiftColor((Color)new Color(255, 64, 64));

        @Override
        protected Color getColor() {
            return this.UNION_COLOR;
        }
    }

    public static class StructPaintComponent
    extends ClassPaintComponent {
        private Color STRUCT_COLOR = LFCustoms.shiftColor((Color)new Color(255, 64, 64));

        @Override
        protected Color getColor() {
            return this.STRUCT_COLOR;
        }
    }

    public static class TypedefPaintComponent
    extends CsmPaintComponent {
        String formatTypedefName;
        private final Color TYPEDEF_COLOR = CsmFontColorManager.instance().getColor(FontColorProvider.Entity.TYPEDEF);

        public void setFormatTypedefName(String formatTypedefName) {
            this.formatTypedefName = formatTypedefName;
        }

        protected Color getColor() {
            return this.TYPEDEF_COLOR;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.formatTypedefName, this.getColor(), null, strike);
        }

        @Override
        public String toString() {
            return this.formatTypedefName;
        }
    }

    public static class ClassPaintComponent
    extends CsmPaintComponent {
        String formatClassName;
        private Color CLASS_COLOR = LFCustoms.shiftColor((Color)new Color(255, 64, 64));
        private boolean displayFQN;

        public void setFormatClassName(String formatClassName) {
            this.formatClassName = formatClassName;
        }

        protected Color getColor() {
            return this.CLASS_COLOR;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.formatClassName, this.getColor(), null, strike);
        }

        @Override
        public String toString() {
            return this.formatClassName;
        }
    }

    public static class EnumeratorPaintComponent
    extends CsmPaintComponent {
        String formatEnumeratorName;
        private Color ENUMERATOR_COLOR = LFCustoms.shiftColor((Color)new Color(64, 64, 255));
        private boolean displayFQN;

        public void EnumeratorPaintComponent(String formatEnumeratorName) {
            this.formatEnumeratorName = formatEnumeratorName;
        }

        protected Color getColor() {
            return this.ENUMERATOR_COLOR;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.formatEnumeratorName, this.getColor(), null, strike);
        }

        public void setFormatEnumeratorName(String formatEnumeratorName) {
            assert (formatEnumeratorName != null);
            this.formatEnumeratorName = formatEnumeratorName;
        }

        @Override
        public String toString() {
            return this.formatEnumeratorName;
        }
    }

    public static class EnumPaintComponent
    extends CsmPaintComponent {
        String formatEnumName;
        private Color ENUM_COLOR = LFCustoms.shiftColor((Color)new Color(255, 64, 64));
        private boolean displayFQN;

        public void EnumPaintComponent(String formatEnumName) {
            this.formatEnumName = formatEnumName;
        }

        protected Color getColor() {
            return this.ENUM_COLOR;
        }

        @Override
        protected void draw(Graphics g) {
            boolean strike = false;
            this.drawIcon(g, this.getIcon());
            this.drawString(g, this.formatEnumName, this.getColor(), null, strike);
        }

        public void setFormatEnumName(String formatEnumName) {
            this.formatEnumName = formatEnumName;
        }

        @Override
        public String toString() {
            return this.formatEnumName;
        }
    }

    public static class NamespaceAliasPaintComponent
    extends CsmPaintComponent {
        private String aliasName;
        private Color NAMESPACE_COLOR = LFCustoms.shiftColor((Color)new Color(64, 255, 64));

        public void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, (CharSequence)this.aliasName, this.NAMESPACE_COLOR);
        }

        @Override
        public String toString() {
            return this.aliasName;
        }
    }

    public static class NamespacePaintComponent
    extends CsmPaintComponent {
        private String pkgName;
        private boolean displayFullNamespacePath;
        private Color NAMESPACE_COLOR = LFCustoms.shiftColor((Color)new Color(64, 255, 64));

        public void setNamespaceName(String pkgName) {
            this.pkgName = pkgName;
        }

        public void setDisplayFullNamespacePath(boolean displayFullNamespacePath) {
            this.displayFullNamespacePath = displayFullNamespacePath;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            String name = this.pkgName;
            if (!this.displayFullNamespacePath) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            this.drawString(g, (CharSequence)name, this.NAMESPACE_COLOR);
        }

        @Override
        public String toString() {
            return this.pkgName;
        }
    }

    private static class DrawState {
        int drawX = 0;
        int drawY = 0;
        int drawHeight = 0;
    }

    private class PostfixString {
        private String text;
        private Color c;
        private int fontStyle;

        public PostfixString(String text, Color c, int fontStyle) {
            this.text = text;
            this.c = c;
            this.fontStyle = fontStyle;
        }

        public PostfixString(String text, int fontStyle) {
            this(text, LFCustoms.shiftColor((Color)POSTFIX_COLOR), fontStyle);
        }

        void Draw(Graphics g) {
            CsmPaintComponent.this.drawString(g, this.text, this.c, new Font(CsmPaintComponent.this.getDrawFont().getName(), CsmPaintComponent.this.getDrawFont().getStyle() | this.fontStyle, CsmPaintComponent.this.getDrawFont().getSize()), false);
        }
    }
}

