/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.cnd.analysis.api.AbstractAnalyzer;
import org.netbeans.modules.cnd.analysis.api.AbstractHintsPanel;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.highlight.hints.CsmHintProvider;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class HintAnalyzerImpl
extends AbstractAnalyzer {
    private static final String PREFIX = "cnd-";

    private HintAnalyzerImpl(Analyzer.Context ctx) {
        super(ctx);
    }

    protected CsmErrorProvider getErrorProvider(Preferences preferences) {
        if (preferences != null) {
            return new CsmHintProvider(preferences);
        }
        return CsmHintProvider.getInstance();
    }

    protected Collection<? extends ErrorDescription> doRunImpl(FileObject sr, Analyzer.Context ctx, CsmErrorProvider provider, AtomicBoolean cancel) {
        CsmFile csmFile = CsmUtilities.getCsmFile((FileObject)sr, (boolean)false, (boolean)false);
        if (csmFile == null) {
            return Collections.emptyList();
        }
        AbstractAnalyzer.RequestImpl request = new AbstractAnalyzer.RequestImpl(csmFile, ctx, cancel);
        ArrayList<ErrorDescription> res = new ArrayList<ErrorDescription>();
        ResponseImpl responce = new ResponseImpl(sr, res, cancel);
        provider.getErrors((CsmErrorProvider.Request)request, (CsmErrorProvider.Response)responce);
        return res;
    }

    protected boolean isCompileUnitBased() {
        return false;
    }

    public static final class AnalyzerFactoryImpl
    extends Analyzer.AnalyzerFactory {
        public AnalyzerFactoryImpl() {
            super("General", NbBundle.getMessage(CsmHintProvider.class, (String)"General_DESCRIPTION"), ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/highlight/resources/bugs.png"));
        }

        public Iterable<? extends Analyzer.WarningDescription> getWarnings() {
            ArrayList<Analyzer.WarningDescription> result = new ArrayList<Analyzer.WarningDescription>();
            CsmHintProvider provider = (CsmHintProvider)CsmHintProvider.getInstance();
            for (CodeAudit audit : provider.getAudits()) {
                result.add(Analyzer.WarningDescription.create((String)(HintAnalyzerImpl.PREFIX + audit.getID()), (String)audit.getName(), (String)"General", (String)provider.getDisplayName()));
            }
            return result;
        }

        public Analyzer.CustomizerProvider<Void, AbstractHintsPanel> getCustomizerProvider() {
            return new Analyzer.CustomizerProvider<Void, AbstractHintsPanel>(){

                public Void initialize() {
                    return null;
                }

                public AbstractHintsPanel createComponent(Analyzer.CustomizerContext<Void, AbstractHintsPanel> context) {
                    AbstractHintsPanel result = null;
                    if (context != null) {
                        result = (AbstractHintsPanel)context.getPreviousComponent();
                    }
                    if (result == null) {
                        result = HintAnalyzerImpl.createComponent((CodeAuditProvider)AnalyzerFactoryImpl.this.getErrorProvider(context.getSettings()));
                    } else if (context != null) {
                        result.setSettings(AnalyzerFactoryImpl.this.getErrorProvider(context.getSettings()).getPreferences().getPreferences());
                    }
                    return result;
                }
            };
        }

        private CodeAuditProvider getErrorProvider(Preferences preferences) {
            if (preferences != null) {
                return new CsmHintProvider(preferences);
            }
            return (CodeAuditProvider)CsmHintProvider.getInstance();
        }

        public Analyzer createAnalyzer(Analyzer.Context context) {
            return new HintAnalyzerImpl(context);
        }
    }

    private static class ResponseImpl
    extends AbstractAnalyzer.AbstractResponse {
        public ResponseImpl(FileObject sr, ArrayList<ErrorDescription> res, AtomicBoolean cancel) {
            super(sr, res, cancel);
        }

        protected ErrorDescription addErrorImpl(CsmErrorInfo errorInfo, FileObject fo) {
            String[] messages = errorInfo.getMessage().split("\n");
            if (messages.length >= 2) {
                String abbr = messages[0];
                AbstractAnalyzer.LazyFixListImpl list = new AbstractAnalyzer.LazyFixListImpl();
                StringBuilder buf = new StringBuilder("<pre>");
                boolean first = true;
                for (int i = 1; i < messages.length; ++i) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append("<br>");
                    }
                    buf.append(messages[i]);
                }
                buf.append("</pre>");
                String message = messages[1];
                return ErrorDescriptionFactory.createErrorDescription((String)(HintAnalyzerImpl.PREFIX + abbr), (Severity)Severity.ERROR, (String)message, (CharSequence)buf.toString(), (LazyFixList)list, (FileObject)fo, (int)errorInfo.getStartOffset(), (int)errorInfo.getStartOffset());
            }
            return null;
        }
    }
}

