/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.util.Collections;
import java.util.concurrent.Callable;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.implspi.EnvironmentFactory;
import org.netbeans.modules.parsing.implspi.SourceControl;
import org.netbeans.modules.parsing.implspi.SourceEnvironment;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class Utilities {
    private static final ThreadLocal<Parser.CancelReason> cancelReason = new ThreadLocal();
    private static final int DEFAULT_MAX_FILE_SIZE = 0x3200000;
    private static volatile EnvironmentFactory envFactory;

    public static final int getMaxFileSize() {
        return Integer.getInteger("parse.max.file.size", 0x3200000);
    }

    private Utilities() {
    }

    public static <T> T runPriorityIO(Callable<T> r) throws Exception {
        return Utilities.getEnvFactory().runPriorityIO(r);
    }

    public static void acquireParserLock() {
        TaskProcessor.acquireParserLock();
    }

    public static void releaseParserLock() {
        TaskProcessor.releaseParserLock();
    }

    public static boolean holdsParserLock() {
        return TaskProcessor.holdsParserLock();
    }

    public static boolean isTaskProcessorThread() {
        return TaskProcessor.WORKER.isRequestProcessorThread();
    }

    public static void scheduleSpecialTask(@NonNull Runnable runnable, @NonNull Lookup context, int priority) {
        TaskProcessor.scheduleSpecialTask(runnable, context, priority);
    }

    public static void revalidate(@NonNull Source source) {
        SourceControl ctl = SourceAccessor.getINSTANCE().getEnvControl(source);
        ctl.sourceChanged(false);
        ctl.revalidate(SourceEnvironment.getReparseDelay(false));
    }

    public static void revalidate(@NonNull FileObject fo) {
        Source source = SourceAccessor.getINSTANCE().get(fo);
        if (source != null) {
            Utilities.revalidate(source);
        }
    }

    public static void addParserResultTask(ParserResultTask<?> task, Source source) {
        Parameters.notNull((CharSequence)"task", task);
        Parameters.notNull((CharSequence)"source", (Object)source);
        SourceCache cache = SourceAccessor.getINSTANCE().getCache(source);
        TaskProcessor.addPhaseCompletionTasks(Collections.singleton(Pair.of(task, null)), cache, true);
    }

    public static void removeParserResultTask(ParserResultTask<?> task, Source source) {
        Parameters.notNull((CharSequence)"task", task);
        Parameters.notNull((CharSequence)"source", (Object)source);
        TaskProcessor.removePhaseCompletionTasks(Collections.singleton(task), source);
    }

    public static void rescheduleTask(ParserResultTask<?> task, Source source) {
        Parameters.notNull((CharSequence)"task", task);
        Parameters.notNull((CharSequence)"source", (Object)source);
        TaskProcessor.rescheduleTasks(Collections.singleton(task), source, null);
    }

    public static Parser.CancelReason getTaskCancelReason() {
        return cancelReason.get();
    }

    static void setTaskCancelReason(@NullAllowed Parser.CancelReason reason) {
        if (reason == null) {
            cancelReason.remove();
        } else {
            cancelReason.set(reason);
        }
    }

    public static FileObject getFileObject(Document doc) {
        return EditorDocumentUtils.getFileObject((Document)doc);
    }

    public static StackTraceElement findCaller(StackTraceElement[] elements, Object ... classesToFilterOut) {
        block0: for (StackTraceElement e : elements) {
            if (e.getClassName().equals(Utilities.class.getName()) || e.getClassName().startsWith("java.lang.")) continue;
            if (classesToFilterOut != null && classesToFilterOut.length > 0) {
                for (Object c : classesToFilterOut) {
                    if (c instanceof Class && e.getClassName().startsWith(((Class)c).getName()) || c instanceof String && e.getClassName().startsWith((String)c)) continue block0;
                }
            } else if (e.getClassName().startsWith("org.netbeans.modules.parsing.")) continue;
            return e;
        }
        return null;
    }

    public static synchronized EnvironmentFactory getEnvFactory() {
        EnvironmentFactory f = envFactory;
        if (f == null && (f = (envFactory = (EnvironmentFactory)Lookup.getDefault().lookup(EnvironmentFactory.class))) == null) {
            throw new UnsupportedOperationException("EnvironmentFactory missing");
        }
        return f;
    }

    public static SourceEnvironment createEnvironment(Source src, SourceControl ctrl) {
        return Utilities.getEnvFactory().createEnvironment(src, ctrl);
    }

    public static Class<? extends Scheduler> findDefaultScheduler(String type) {
        EnvironmentFactory f = Utilities.getEnvFactory();
        return f.findStandardScheduler(type);
    }

    public static final class NopScheduler
    extends Scheduler {
        @Override
        protected SchedulerEvent createSchedulerEvent(SourceModificationEvent event) {
            return null;
        }
    }
}

