/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.repository;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitRepositories;
import org.netbeans.modules.git.remote.ui.repository.Bundle;
import org.netbeans.modules.git.remote.ui.repository.GitRepositoryTopComponent;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class OpenRepositoryAction
extends AbstractAction {
    public OpenRepositoryAction() {
        super(Bundle.LBL_OpenRepositoryAction_PopupName());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        FileSystem defaultFileSystem = VCSFileProxySupport.getDefaultFileSystem();
        if (defaultFileSystem == null) {
            return;
        }
        VCSFileProxy root = VCSFileProxy.createFileProxy((FileObject)defaultFileSystem.getRoot());
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)root);
        fileChooser.setDialogTitle(Bundle.CTL_OpenRepository_ACSD());
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(null, Bundle.CTL_OpenRepository_okButton());
        final VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        if (f == null) {
            return;
        }
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                final VCSFileProxy repository = Git.getInstance().getRepositoryRoot(f);
                if (repository != null) {
                    GitRepositories.getInstance().add(repository, true);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitRepositoryTopComponent rtc = GitRepositoryTopComponent.findInstance();
                            rtc.open();
                            rtc.requestActive();
                            rtc.selectRepository(repository);
                        }
                    });
                }
            }
        }, (int)0);
    }
}

