/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.xref;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.support.Interrupter;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public abstract class CsmReferenceRepository {
    private static final CsmReferenceRepository EMPTY = new Empty();
    private static CsmReferenceRepository defaultRepository;

    protected CsmReferenceRepository() {
    }

    public static CsmReferenceRepository getDefault() {
        if (defaultRepository != null) {
            return defaultRepository;
        }
        defaultRepository = (CsmReferenceRepository)Lookup.getDefault().lookup(CsmReferenceRepository.class);
        return defaultRepository == null ? EMPTY : defaultRepository;
    }

    public abstract Collection<CsmFile> findRelevantFiles(Collection<CsmProject> var1, CharSequence var2);

    public abstract Collection<CsmReference> getReferences(CsmObject var1, CsmProject var2, Set<CsmReferenceKind> var3, Interrupter var4);

    public abstract Collection<CsmReference> getReferences(CsmObject var1, CsmFile var2, Set<CsmReferenceKind> var3, Interrupter var4);

    public abstract Collection<CsmReference> getReferences(CsmObject[] var1, CsmFile var2, Set<CsmReferenceKind> var3, Interrupter var4);

    public static BaseDocument getDocument(CsmFile file) {
        BaseDocument doc = null;
        try {
            doc = CsmReferenceRepository.getBaseDocument(file.getFileObject());
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return doc;
    }

    private static BaseDocument getBaseDocument(FileObject fileObject) throws DataObjectNotFoundException, IOException {
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        StyledDocument doc = CsmUtilities.openDocument((DataObject)DataObject.find((FileObject)fileObject));
        return doc instanceof BaseDocument ? (BaseDocument)doc : null;
    }

    private static final class Empty
    extends CsmReferenceRepository {
        Empty() {
        }

        @Override
        public Collection<CsmReference> getReferences(CsmObject target, CsmProject project, Set<CsmReferenceKind> kinds, Interrupter interrupter) {
            return Collections.emptyList();
        }

        public Map<CsmObject, Collection<CsmReference>> getReferences(CsmObject[] targets, CsmProject project, Set<CsmReferenceKind> kinds, Interrupter interrupter) {
            return Collections.emptyMap();
        }

        @Override
        public Collection<CsmReference> getReferences(CsmObject target, CsmFile file, Set<CsmReferenceKind> kinds, Interrupter interrupter) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmReference> getReferences(CsmObject[] targets, CsmFile file, Set<CsmReferenceKind> kinds, Interrupter interrupter) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmFile> findRelevantFiles(Collection<CsmProject> projects, CharSequence id) {
            return Collections.emptyList();
        }
    }
}

