/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.project.CodeAssistance;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class CsmCodeAssistanceProvider
implements CodeAssistance,
CsmProgressListener {
    private static final WeakHashMap<ChangeListener, Boolean> listeners = new WeakHashMap();
    private static final Object lock = new Object();

    public CsmCodeAssistanceProvider() {
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
    }

    public boolean hasCodeAssistance(NativeFileItem item) {
        CndUtils.assertNonUiThread();
        CsmFile csmFile = CsmUtilities.getCsmFile((NativeFileItem)item, (boolean)false, (boolean)false);
        return csmFile != null;
    }

    public CodeAssistance.State getCodeAssistanceState(NativeFileItem item) {
        CsmFile csmFile = CsmUtilities.getCsmFile((NativeFileItem)item, (boolean)false, (boolean)false);
        if (csmFile != null) {
            if (csmFile.isHeaderFile()) {
                if (CsmIncludeHierarchyResolver.getDefault().getFiles(csmFile).isEmpty()) {
                    return CodeAssistance.State.ParsedOrphanHeader;
                }
                return CodeAssistance.State.ParsedIncludedHeader;
            }
            return CodeAssistance.State.ParsedSource;
        }
        return CodeAssistance.State.NotParsed;
    }

    public Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> getHeaderLanguageFlavour(FileObject item) {
        CsmFile csmFile = CsmUtilities.getCsmFile((FileObject)item, (boolean)false, (boolean)false);
        if (csmFile != null) {
            Collection<CsmCompilationUnit> compilationUnits = CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0);
            if (!compilationUnits.isEmpty()) {
                Iterator<CsmCompilationUnit> iterator = compilationUnits.iterator();
                HashSet<NativeFileItem.Language> langs = new HashSet<NativeFileItem.Language>();
                HashSet<NativeFileItem.LanguageFlavor> flavors = new HashSet<NativeFileItem.LanguageFlavor>();
                while (iterator.hasNext()) {
                    NativeProject np;
                    NativeFileItem ni;
                    Object platformProject;
                    CsmCompilationUnit cu = iterator.next();
                    CsmFile startFile = cu.getStartFile();
                    if (startFile == null || !((platformProject = startFile.getProject().getPlatformProject()) instanceof NativeProject) || (ni = (np = (NativeProject)platformProject).findFileItem(startFile.getFileObject())) == null || startFile == csmFile || !startFile.isSourceFile()) continue;
                    langs.add(ni.getLanguage());
                    flavors.add(ni.getLanguageFlavor());
                }
                if (!flavors.isEmpty()) {
                    NativeFileItem.Language prefLang = NativeFileItem.Language.C_HEADER;
                    if (!csmFile.isHeaderFile()) {
                        if (langs.contains(NativeFileItem.Language.C)) {
                            prefLang = NativeFileItem.Language.C;
                        }
                        if (langs.contains(NativeFileItem.Language.CPP)) {
                            prefLang = NativeFileItem.Language.CPP;
                        }
                    }
                    NativeFileItem.LanguageFlavor prefFlavor = this.maxFlavor(flavors);
                    return Pair.of((Object)prefLang, (Object)prefFlavor);
                }
            }
            if (csmFile.isHeaderFile()) {
                return Pair.of((Object)NativeFileItem.Language.C_HEADER, (Object)NativeFileItem.LanguageFlavor.UNKNOWN);
            }
            if (csmFile.isSourceFile()) {
                return Pair.of((Object)NativeFileItem.Language.CPP, (Object)NativeFileItem.LanguageFlavor.UNKNOWN);
            }
        }
        return Pair.of((Object)NativeFileItem.Language.OTHER, (Object)NativeFileItem.LanguageFlavor.UNKNOWN);
    }

    public Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> getStartFileLanguageFlavour(NativeFileItem item) {
        CsmFile csmFile = CsmUtilities.getCsmFile((NativeFileItem)item, (boolean)false, (boolean)false);
        if (csmFile != null) {
            Collection<CsmCompilationUnit> compilationUnits = CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0);
            if (!compilationUnits.isEmpty()) {
                Iterator<CsmCompilationUnit> iterator = compilationUnits.iterator();
                HashSet<NativeFileItem.Language> langs = new HashSet<NativeFileItem.Language>();
                HashSet<NativeFileItem.LanguageFlavor> flavors = new HashSet<NativeFileItem.LanguageFlavor>();
                while (iterator.hasNext()) {
                    NativeProject np;
                    NativeFileItem ni;
                    Object platformProject;
                    CsmCompilationUnit cu = iterator.next();
                    CsmFile startFile = cu.getStartFile();
                    if (startFile == null || !((platformProject = startFile.getProject().getPlatformProject()) instanceof NativeProject) || (ni = (np = (NativeProject)platformProject).findFileItem(startFile.getFileObject())) == null || ni == item || !startFile.isSourceFile()) continue;
                    langs.add(ni.getLanguage());
                    flavors.add(ni.getLanguageFlavor());
                }
                if (!flavors.isEmpty()) {
                    NativeFileItem.Language prefLang = NativeFileItem.Language.C_HEADER;
                    if (langs.contains(NativeFileItem.Language.C)) {
                        prefLang = NativeFileItem.Language.C;
                    }
                    if (langs.contains(NativeFileItem.Language.CPP)) {
                        prefLang = NativeFileItem.Language.CPP;
                    }
                    NativeFileItem.LanguageFlavor prefFlavor = this.maxFlavor(flavors);
                    return Pair.of((Object)prefLang, (Object)prefFlavor);
                }
            }
            if (csmFile.isHeaderFile()) {
                return Pair.of((Object)NativeFileItem.Language.C_HEADER, (Object)NativeFileItem.LanguageFlavor.UNKNOWN);
            }
            if (csmFile.isSourceFile()) {
                return Pair.of((Object)NativeFileItem.Language.CPP, (Object)NativeFileItem.LanguageFlavor.UNKNOWN);
            }
        }
        return Pair.of((Object)NativeFileItem.Language.OTHER, (Object)NativeFileItem.LanguageFlavor.UNKNOWN);
    }

    public List<NativeFileItem> findHeaderCompilationUnit(NativeFileItem item) {
        ArrayList<NativeFileItem> res = new ArrayList<NativeFileItem>();
        CsmFile csmFile = CsmUtilities.getCsmFile((NativeFileItem)item, (boolean)false, (boolean)false);
        if (csmFile != null) {
            Collection<CsmCompilationUnit> compilationUnits;
            NativeProject np;
            NativeFileItem ni;
            Object platformProject;
            CsmFile topParentFile = CsmIncludeResolver.getDefault().getCloseTopParentFile(csmFile);
            if (topParentFile != null && (platformProject = topParentFile.getProject().getPlatformProject()) instanceof NativeProject && (ni = (np = (NativeProject)platformProject).findFileItem(topParentFile.getFileObject())) != null && ni != item && topParentFile.isSourceFile()) {
                res.add(ni);
            }
            if (!(compilationUnits = CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0)).isEmpty()) {
                for (CsmCompilationUnit cu : compilationUnits) {
                    NativeProject np2;
                    NativeFileItem ni2;
                    Object platformProject2;
                    CsmFile startFile = cu.getStartFile();
                    if (startFile == null || !((platformProject2 = startFile.getProject().getPlatformProject()) instanceof NativeProject) || (ni2 = (np2 = (NativeProject)platformProject2).findFileItem(startFile.getFileObject())) == null || ni2 == item || !startFile.isSourceFile() || res.contains(ni2)) continue;
                    res.add(ni2);
                }
            }
        }
        return res;
    }

    private NativeFileItem.LanguageFlavor maxFlavor(Set<NativeFileItem.LanguageFlavor> flavors) {
        NativeFileItem.LanguageFlavor prefFlavor = NativeFileItem.LanguageFlavor.UNKNOWN;
        if (flavors.contains(NativeFileItem.LanguageFlavor.C)) {
            prefFlavor = NativeFileItem.LanguageFlavor.C;
        }
        if (flavors.contains(NativeFileItem.LanguageFlavor.C89)) {
            prefFlavor = NativeFileItem.LanguageFlavor.C89;
        }
        if (flavors.contains(NativeFileItem.LanguageFlavor.C99)) {
            prefFlavor = NativeFileItem.LanguageFlavor.C99;
        }
        if (flavors.contains(NativeFileItem.LanguageFlavor.C11)) {
            prefFlavor = NativeFileItem.LanguageFlavor.C11;
        }
        if (flavors.contains(NativeFileItem.LanguageFlavor.CPP)) {
            prefFlavor = NativeFileItem.LanguageFlavor.CPP;
        }
        if (flavors.contains(NativeFileItem.LanguageFlavor.CPP11)) {
            prefFlavor = NativeFileItem.LanguageFlavor.CPP11;
        }
        if (flavors.contains(NativeFileItem.LanguageFlavor.CPP14)) {
            prefFlavor = NativeFileItem.LanguageFlavor.CPP14;
        }
        return prefFlavor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        Object object = lock;
        synchronized (object) {
            listeners.put(listener, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        Object object = lock;
        synchronized (object) {
            listeners.remove(listener);
        }
    }

    public void projectParsingStarted(CsmProject project) {
    }

    public void projectFilesCounted(CsmProject project, int filesCount) {
    }

    public void projectParsingFinished(CsmProject project) {
    }

    public void projectParsingCancelled(CsmProject project) {
    }

    public void projectLoaded(CsmProject project) {
        this.fireChanges(project);
    }

    public void fileInvalidated(CsmFile file) {
    }

    public void fileAddedToParse(CsmFile file) {
    }

    public void fileParsingStarted(CsmFile file) {
    }

    public void fileParsingFinished(CsmFile file) {
        this.fireChanges(file);
    }

    public void fileRemoved(CsmFile file) {
        this.fireChanges(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChanges(CsmFile file) {
        ArrayList<ChangeListener> list;
        if (file == null) {
            return;
        }
        FileObject fileObject = file.getFileObject();
        if (fileObject == null) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(fileObject);
        Iterator iterator = lock;
        synchronized (iterator) {
            list = new ArrayList<ChangeListener>(listeners.keySet());
        }
        for (ChangeListener listener : list) {
            listener.stateChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChanges(CsmProject project) {
        Object platformProject = project.getPlatformProject();
        if (platformProject instanceof NativeProject) {
            ArrayList<ChangeListener> list;
            ChangeEvent changeEvent = new ChangeEvent(platformProject);
            Iterator iterator = lock;
            synchronized (iterator) {
                list = new ArrayList<ChangeListener>(listeners.keySet());
            }
            for (ChangeListener listener : list) {
                listener.stateChanged(changeEvent);
            }
        }
    }

    public void parserIdle() {
    }
}

