/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.ui.build2.BuildOptionsVisual;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class BuildOptionsPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private BuildOptionsVisual component;
    private WizardDescriptor wizard;

    public BuildOptionsVisual getComponent() {
        if (this.component == null) {
            this.component = new BuildOptionsVisual();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        FileObject fo;
        File file;
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        this.wizard.putProperty("WizardPanel_infoMessage", null);
        this.wizard.putProperty("WizardPanel_warningMessage", null);
        String buildContext = (String)this.wizard.getProperty("buildContext");
        String dockerfile = this.component.getDockerfile();
        if (dockerfile == null) {
            dockerfile = "Dockerfile";
        }
        if (!(file = new File(dockerfile)).isAbsolute()) {
            file = new File(buildContext, dockerfile);
        }
        if ((fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) == null || !fo.isData() || !dockerfile.endsWith(fo.getNameExt())) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_NonExistingDockerfile());
            return false;
        }
        FileObject build = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(buildContext)));
        if (build == null || !FileUtil.isParentOf((FileObject)build, (FileObject)fo)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_NonRelativeDockerfile());
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        if (this.wizard == null) {
            this.wizard = wiz;
        }
        this.component.setBuildContext((String)wiz.getProperty("buildContext"));
        String dockerfile = (String)wiz.getProperty("dockerfile");
        if (dockerfile == null) {
            dockerfile = "Dockerfile";
        }
        this.component.setDockerfile(dockerfile);
        Boolean pull = (Boolean)wiz.getProperty("pull");
        this.component.setPull(pull != null ? pull : false);
        Boolean noCache = (Boolean)wiz.getProperty("noCache");
        this.component.setPull(noCache != null ? noCache : false);
        this.changeSupport.fireChange();
    }

    public void storeSettings(WizardDescriptor wiz) {
        wiz.putProperty("dockerfile", (Object)this.component.getDockerfile());
        wiz.putProperty("pull", (Object)this.component.isPull());
        wiz.putProperty("noCache", (Object)this.component.isNoCache());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }
}

