/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.beans.PropertyChangeListener;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;

public class EditorContextBridge {
    private static final EditorContextDispatcher contextDispatcher = EditorContextDispatcher.getDefault();

    public static String getCurrentURL() {
        return contextDispatcher.getCurrentURLAsString();
    }

    public static FileObject getCurrentFileObject() {
        return contextDispatcher.getCurrentFile();
    }

    public static String getCurrentFilePath() {
        FileObject currentFile = contextDispatcher.getCurrentFile();
        if (currentFile != null) {
            return currentFile.getPath();
        }
        return "";
    }

    public static String getMostRecentFilePath() {
        FileObject currentFile = EditorContextBridge.getMostRecentFileObject();
        if (currentFile != null) {
            return currentFile.getPath();
        }
        return "";
    }

    public static FileObject getMostRecentFileObject() {
        return contextDispatcher.getMostRecentFile();
    }

    public static int getCurrentLineNumber() {
        return contextDispatcher.getCurrentLineNumber();
    }

    public static int getMostRecentLineNumber() {
        return contextDispatcher.getMostRecentLineNumber();
    }

    public static String getCurrentMIMEType() {
        FileObject fo = contextDispatcher.getCurrentFile();
        return fo != null ? fo.getMIMEType() : "";
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        contextDispatcher.addPropertyChangeListener("text/x-c", l);
        contextDispatcher.addPropertyChangeListener("text/x-c++", l);
        contextDispatcher.addPropertyChangeListener("text/x-h", l);
        contextDispatcher.addPropertyChangeListener("text/x-asm", l);
        contextDispatcher.addPropertyChangeListener("text/x-fortran", l);
    }
}

