/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.HostOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.HostOptionSet;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.SecuritySettings;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Record;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSetOwner;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionValue;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;

public class CustomizableHost
extends Host
implements Record,
OptionSetOwner {
    private OptionSet options = new HostOptionSet();
    private static final String default_location = System.getProperty("spro.home");

    public CustomizableHost() {
        this.setHostName("localhost");
        this.setRemoteStudioLocation(default_location);
    }

    @Override
    public String getKey() {
        return this.getHostName();
    }

    @Override
    public void setKey(String newKey) {
        this.setHostName(newKey);
    }

    @Override
    public boolean matches(String key) {
        return IpeUtils.sameString(this.getKey(), key);
    }

    @Override
    public boolean isArchetype() {
        return "localhost".equals(this.getHostName());
    }

    @Override
    public ExecutionEnvironment executionEnvironment() {
        ExecutionEnvironment ee = this.isRemote() ? ExecutionEnvironmentFactory.createNew((String)this.getHostLogin(), (String)this.getHostName(), (int)this.getPortNum()) : ExecutionEnvironmentFactory.getLocal();
        return ee;
    }

    private static String getLocalHost() {
        return LocalHostNameHolder.name;
    }

    @Override
    public boolean isRemote() {
        return CustomizableHost.isRemote(this.getHostName());
    }

    public CustomizableHost(OptionSet options) {
        this.options = options;
    }

    public void setPlatform(Platform platform) {
        this.setPlatformName(platform.name());
    }

    @Override
    public String getPlatformName() {
        String platForm = this.getHostOption("platform");
        return platForm;
    }

    public void setPlatformName(String platform) {
        this.setHostOption("platform", platform);
    }

    @Override
    public String getHostName() {
        String hostName = this.getHostOption("host_name");
        return hostName;
    }

    @Override
    public int getPortNum() {
        return Integer.parseInt(this.getHostOption("ssh_port"));
    }

    public boolean isRememberPassword() {
        return "on".equals(this.getHostOption("remember_password"));
    }

    public void setRememberPassword(boolean rememberPassword) {
        if (rememberPassword) {
            this.setHostOption("remember_password", "on");
        } else {
            this.setHostOption("remember_password", "off");
        }
    }

    public void setHostName(String hostName) {
        this.setHostOption("host_name", hostName);
    }

    public String getHostKey() {
        if (this.isRemote()) {
            return this.getHostLogin() + "@" + this.getHostName() + ":" + this.getPortNum();
        }
        return this.getHostName();
    }

    @Override
    public String getHostLogin() {
        String loginName = this.getHostOption("login_name");
        return loginName;
    }

    public void setHostLogin(String loginName) {
        this.setHostOption("login_name", loginName);
    }

    @Override
    public String getRemoteStudioLocation() {
        String studioLocation = this.getHostOption("studio_location");
        if (Log.Remote.host) {
            System.out.printf("Host.getRemoteStudioLocation() -> %s\n", studioLocation);
        }
        return studioLocation;
    }

    public void setRemoteStudioLocation(String studioLocation) {
        this.setHostOption("studio_location", studioLocation);
    }

    public void setSecuritySettings(SecuritySettings ss) {
        this.setHostOption("ssh_port", Integer.toString(ss.sshPort()));
    }

    @Override
    public SecuritySettings getSecuritySettings() {
        return new SecuritySettings(Integer.parseInt(this.getHostOption("ssh_port")), null);
    }

    @Override
    public CustomizableHost cloneRecord() {
        return new CustomizableHost(this.options.makeCopy());
    }

    @Override
    public String displayName() {
        if (this.getHostName().equals("localhost")) {
            return this.getHostName() + " (" + CustomizableHost.getLocalHost() + ", " + this.getPlatformName() + " )";
        }
        return this.getHostName() + " (" + this.getPlatformName() + " )";
    }

    public void setHostOption(String name, String value) {
        if (Log.Remote.host && "studio_location".equals(name)) {
            System.out.printf("Host.setHostOption(%s, %s)\n", name, value);
        }
        OptionValue o = this.options.byName(name);
        this.invalidateResources();
        if (o != null) {
            o.set(value);
        }
    }

    public String getHostOption(String name) {
        OptionValue o = this.options.byName(name);
        if (o != null) {
            return o.get();
        }
        return null;
    }

    public void assign(CustomizableHost that) {
        this.invalidateResources();
        this.options.assign(that.options);
    }

    @Override
    public OptionSet getOptions() {
        return this.options;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName("General");
        set.setShortDescription("General");
        set.put((Node.Property)HostOption.HOST_PROP_HOSTNAME.createNodeProp(this));
        set.put((Node.Property)HostOption.HOST_PROP_PLATFORM.createNodeProp(this));
        set.put((Node.Property)HostOption.HOST_PROP_LOCATION.createNodeProp(this));
        set.put((Node.Property)HostOption.HOST_PROP_LOGINNAME.createNodeProp(this));
        set.put((Node.Property)HostOption.HOST_PROP_SSH_PORT.createNodeProp(this));
        set.put((Node.Property)HostOption.HOST_PROP_REMEMBER_PASSWORD.createNodeProp(this));
        sheet.put(set);
        return sheet;
    }

    public String toString() {
        return "CustomizableHost: " + this.getHostName();
    }

    private static class LocalHostNameHolder {
        private static final String name = LocalHostNameHolder.getLocalHost();

        private LocalHostNameHolder() {
        }

        private static String getLocalHost() {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                return addr.getHostName();
            }
            catch (UnknownHostException x) {
                return "<unknown>";
            }
        }
    }
}

