/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projecttemplates;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.projecttemplates.FileCreator;
import org.netbeans.modules.projecttemplates.GeneratedProject;
import org.netbeans.modules.projecttemplates.TemplateBasedFileCreator;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Parameters;

public final class ProjectCreator {
    private final FileObject dir;
    private final List<FileCreator> entries = new LinkedList<FileCreator>();

    public ProjectCreator(FileObject projectDir) {
        this.dir = projectDir;
    }

    public void add(String destPath, String name, FileObject fileTemplate, boolean openOnLoad) {
        this.add(new TemplateBasedFileCreator(destPath, name, fileTemplate, openOnLoad));
    }

    public void add(FileCreator creator) {
        Parameters.notNull((CharSequence)"creator", (Object)creator);
        this.entries.add(creator);
    }

    public final GeneratedProject createProject(final ProgressHandle handle, final String name, final FileObject template, Map<String, String> substitutions) throws IOException {
        final Map<String, String> params = Collections.unmodifiableMap(substitutions);
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"template", (Object)template);
        handle.start(6);
        final EditableProperties[] projectProps = this.parseTemplate(template, params);
        handle.progress(1);
        handle.setDisplayName(NbBundle.getMessage(ProjectCreator.class, (String)"LBL_CreatingProject"));
        handle.progress(1);
        final FileObject projectDir = FileUtil.createFolder((FileObject)this.dir, (String)name);
        final GeneratedProject[] result = new GeneratedProject[1];
        projectDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                result[0] = ProjectCreator.this.doCreateProject(handle, (Map[])projectProps, projectDir, name, template, params);
            }
        });
        handle.finish();
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeneratedProject doCreateProject(ProgressHandle handle, Map<String, String>[] projectProps, FileObject projectDir, String name, FileObject template, Map<String, String> params) throws IOException {
        assert (projectDir != null);
        handle.progress(2);
        if (!projectProps[0].isEmpty()) {
            this.entries.add(new ProjectPropertiesEntry(projectProps[0]));
        }
        if (!projectProps[1].isEmpty()) {
            this.entries.add(new ProjectPropertiesEntry("nbproject/private/private.properties", projectProps[1]));
        }
        handle.progress(3);
        HashSet<DataObject> toOpen = new HashSet<DataObject>();
        handle.progress(4);
        for (FileCreator entry : this.entries) {
            handle.setDisplayName(entry.getName());
            DataObject ob = entry.create(projectDir, params);
            if (!entry.isOpenOnLoad()) continue;
            toOpen.add(ob);
        }
        ProjectCreator projectCreator = this;
        synchronized (projectCreator) {
            this.notifyAll();
        }
        return new GeneratedProject(projectDir, toOpen);
    }

    public final List<File> listCreatedFiles(File target) {
        LinkedList<File> files = new LinkedList<File>();
        for (FileCreator c : this.entries) {
            String targetFile = c.dest;
            if (targetFile != null && !targetFile.endsWith("/")) {
                targetFile = targetFile + '/';
            }
            targetFile = targetFile + c.getName();
            File f = new File(target, targetFile);
            files.add(f);
        }
        Collections.sort(files, new PathLengthComparator());
        return files;
    }

    private EditableProperties[] parseTemplate(FileObject template, Map<String, String> params) throws IOException {
        EditableProperties templateProps = this.loadProperties(template);
        EditableProperties projectProperties = new EditableProperties(true);
        EditableProperties privateProperties = new EditableProperties(true);
        MapFormat fmt = new MapFormat(params);
        fmt.setLeftBrace("{{");
        fmt.setRightBrace("}}");
        for (String key : NbCollections.checkedSetByFilter((Set)templateProps.keySet(), String.class, (boolean)false)) {
            String value = templateProps.getProperty(key);
            try {
                value = fmt.format((Object)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Exception parsing template " + template.getPath() + " on '" + key + '=' + value, e);
            }
            key = fmt.format((Object)key);
            if (!key.startsWith("pp.")) {
                FileObject tplFile = FileUtil.getConfigFile((String)value);
                if (tplFile == null) {
                    throw new IOException("No template named " + value + " in the system FS");
                }
                boolean open = key.endsWith("*");
                if (open) {
                    key = key.substring(0, key.length() - 1);
                }
                this.add(key, null, tplFile, open);
                continue;
            }
            if (key.startsWith("pp")) {
                key = key.substring(3);
                projectProperties.put(key, value);
                continue;
            }
            if (!key.startsWith("pvp")) continue;
            key = key.substring(3);
            privateProperties.put(key, value);
        }
        return new EditableProperties[]{projectProperties, privateProperties};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableProperties loadProperties(FileObject template) throws IOException {
        EditableProperties result = new EditableProperties(true);
        BufferedInputStream in = new BufferedInputStream(template.getInputStream());
        try {
            result.load((InputStream)in);
        }
        finally {
            ((InputStream)in).close();
        }
        return result;
    }

    private static FileObject findPropertiesTemplate() {
        String path = "Templates/Other/properties.properties";
        FileObject result = FileUtil.getConfigFile((String)path);
        if (result == null) {
            throw new IllegalStateException("Could not find properties template in SFS at " + path);
        }
        return result;
    }

    private static class ProjectPropertiesEntry
    extends TemplateBasedFileCreator {
        private final Map<String, String> props;

        ProjectPropertiesEntry(Map<String, String> props) {
            this("nbproject/project.properties", props);
        }

        ProjectPropertiesEntry(String path, Map<String, String> props) {
            super(path, null, ProjectCreator.findPropertiesTemplate(), false);
            this.props = props;
        }

        @Override
        public DataObject create(FileObject project, Map<String, String> params) throws IOException {
            final DataObject result = super.create(project, params);
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void run() throws IOException {
                        EditableProperties ed = new EditableProperties(ProjectPropertiesEntry.this.props);
                        FileObject file = result.getPrimaryFile();
                        FileLock lock = file.lock();
                        try {
                            BufferedOutputStream out = new BufferedOutputStream(file.getOutputStream(lock));
                            try {
                                ed.store((OutputStream)out);
                            }
                            finally {
                                ((OutputStream)out).close();
                            }
                        }
                        finally {
                            lock.releaseLock();
                        }
                        return null;
                    }
                });
            }
            catch (MutexException me) {
                if (me.getException() instanceof IOException) {
                    throw (IOException)me.getException();
                }
                throw new IOException(me);
            }
            return result;
        }
    }

    private static final class PathLengthComparator
    implements Comparator<File> {
        private PathLengthComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            int l2;
            int l1 = o1.getPath().length();
            if (l1 == (l2 = o2.getPath().length())) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
            return l1 > l2 ? 1 : -1;
        }
    }
}

