/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javadoc.AnnotationDescImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.DocImpl;
import java.lang.reflect.Modifier;
import java.text.CollationKey;

public abstract class ProgramElementDocImpl
extends DocImpl
implements ProgramElementDoc {
    private final Symbol sym;
    JCTree tree = null;
    Position.LineMap lineMap = null;
    private int modifiers = -1;

    protected ProgramElementDocImpl(DocEnv env, Symbol sym, TreePath treePath) {
        super(env, treePath);
        this.sym = sym;
        if (treePath != null) {
            this.tree = (JCTree)treePath.getLeaf();
            this.lineMap = ((JCTree.JCCompilationUnit)treePath.getCompilationUnit()).lineMap;
        }
    }

    @Override
    public void setTreePath(TreePath treePath) {
        super.setTreePath(treePath);
        this.tree = (JCTree)treePath.getLeaf();
        this.lineMap = ((JCTree.JCCompilationUnit)treePath.getCompilationUnit()).lineMap;
    }

    protected abstract Symbol.ClassSymbol getContainingClass();

    protected abstract long getFlags();

    protected int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = DocEnv.translateModifiers(this.getFlags());
        }
        return this.modifiers;
    }

    public ClassDoc containingClass() {
        if (this.getContainingClass() == null) {
            return null;
        }
        return this.env.getClassDoc(this.getContainingClass());
    }

    public PackageDoc containingPackage() {
        return this.env.getPackageDoc(this.getContainingClass().packge());
    }

    public int modifierSpecifier() {
        int modifiers = this.getModifiers();
        if (this.isMethod() && this.containingClass().isInterface()) {
            return modifiers & 0xFFFFFBFF;
        }
        return modifiers;
    }

    public String modifiers() {
        int modifiers = this.getModifiers();
        if (this.isAnnotationTypeElement() || this.isMethod() && this.containingClass().isInterface()) {
            return Modifier.toString(modifiers & 0xFFFFFBFF);
        }
        return Modifier.toString(modifiers);
    }

    public AnnotationDesc[] annotations() {
        AnnotationDesc[] res = new AnnotationDesc[this.sym.getRawAttributes().length()];
        int i = 0;
        for (Attribute.Compound a : this.sym.getRawAttributes()) {
            res[i++] = new AnnotationDescImpl(this.env, a);
        }
        return res;
    }

    public boolean isPublic() {
        int modifiers = this.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public boolean isProtected() {
        int modifiers = this.getModifiers();
        return Modifier.isProtected(modifiers);
    }

    public boolean isPrivate() {
        int modifiers = this.getModifiers();
        return Modifier.isPrivate(modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        int modifiers = this.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public boolean isFinal() {
        int modifiers = this.getModifiers();
        return Modifier.isFinal(modifiers);
    }

    @Override
    CollationKey generateKey() {
        String k = this.name();
        return this.env.doclocale.collator.getCollationKey(k);
    }
}

