/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.DebugProjectCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class DebugFileCommand
extends Command
implements Displayable {
    public static final String ID = "debug.single";
    public static final String DISPLAY_NAME = DebugProjectCommand.DISPLAY_NAME;

    public DebugFileCommand(PhpProject project) {
        super(project);
    }

    @Override
    public void invokeActionInternal(Lookup context) {
        FileObject fileObj = CommandUtils.fileForContextOrSelectedNodes(context);
        if (this.isSeleniumFile(fileObj)) {
            ConfigAction.get(ConfigAction.Type.SELENIUM, this.getProject()).debugFile(context);
        } else if (this.isTestFile(fileObj)) {
            ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).debugFile(context);
        } else {
            ConfigAction configAction = this.getConfigAction();
            if (!configAction.isFileValid()) {
                return;
            }
            configAction.debugFile(context);
        }
    }

    @Override
    public boolean isActionEnabledInternal(Lookup context) {
        FileObject fileObj = CommandUtils.fileForContextOrSelectedNodes(context);
        if (this.isSeleniumFile(fileObj)) {
            return ConfigAction.get(ConfigAction.Type.SELENIUM, this.getProject()).isDebugFileEnabled(context);
        }
        if (this.isTestFile(fileObj)) {
            return ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).isDebugFileEnabled(context);
        }
        return this.getConfigAction().isDebugFileEnabled(context);
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

