/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateQueueRequestMarshaller
implements Marshaller<Request<CreateQueueRequest>, CreateQueueRequest> {
    @Override
    public Request<CreateQueueRequest> marshall(CreateQueueRequest createQueueRequest) {
        DefaultRequest<CreateQueueRequest> request = new DefaultRequest<CreateQueueRequest>(createQueueRequest, "AmazonSQS");
        request.addParameter("Action", "CreateQueue");
        request.addParameter("Version", "2009-02-01");
        if (createQueueRequest != null && createQueueRequest.getQueueName() != null) {
            request.addParameter("QueueName", StringUtils.fromString(createQueueRequest.getQueueName()));
        }
        if (createQueueRequest != null && createQueueRequest.getDefaultVisibilityTimeout() != null) {
            request.addParameter("DefaultVisibilityTimeout", StringUtils.fromInteger(createQueueRequest.getDefaultVisibilityTimeout()));
        }
        return request;
    }
}

