/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctional;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmReturnStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.support.CsmTypes;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.cplusplus.CsmFinderFactory;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Pair;

public final class CompletionSupport
implements DocumentListener {
    private final Reference<Document> docRef;
    private static int NOT_INITIALIZED = -1;
    private int lastSeparatorOffset = -1;
    private int contextOffset = NOT_INITIALIZED;
    private static final int MAX_EXPRESSION_LENGTH_TO_REPARSE = 1024;

    private CompletionSupport(Document doc) {
        this.docRef = new WeakReference<Document>(doc);
        doc.addDocumentListener(this);
    }

    public static CompletionSupport get(JTextComponent component) {
        return CompletionSupport.get(component.getDocument());
    }

    public static CompletionSupport get(Document doc) {
        CompletionSupport support = (CompletionSupport)doc.getProperty(CompletionSupport.class);
        if (support == null) {
            boolean valid;
            boolean bl = valid = CndLexerUtilities.getLanguage((Document)doc) != null;
            if (valid) {
                support = new CompletionSupport(doc);
                doc.putProperty(CompletionSupport.class, support);
            }
        }
        return support;
    }

    public final Document getDocument() {
        return this.docRef.get();
    }

    public static boolean isPreprocCompletionEnabled(Document doc, int offset) {
        return CompletionSupport.isIncludeCompletionEnabled(doc, offset) || CompletionSupport.isPreprocessorDirectiveCompletionEnabled(doc, offset);
    }

    private static boolean isPreprocessorDirectiveCompletionEnabledImpl(Document doc, int offset) {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)false, (boolean)true);
        if (ts == null) {
            return false;
        }
        if (ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            TokenSequence embedded = ts.embedded();
            embedded.moveStart();
            embedded.moveNext();
            if (!embedded.moveNext()) {
                return true;
            }
            CndTokenUtilities.shiftToNonWhite((TokenSequence)embedded, (boolean)false);
            return embedded.offset() + embedded.token().length() >= offset;
        }
        return false;
    }

    public static boolean isPreprocessorDirectiveCompletionEnabled(final Document doc, final int offset) {
        final AtomicBoolean out = new AtomicBoolean(false);
        doc.render(new Runnable(){

            @Override
            public void run() {
                out.set(CompletionSupport.isPreprocessorDirectiveCompletionEnabledImpl(doc, offset));
            }
        });
        return out.get();
    }

    public static boolean isIncludeCompletionEnabled(final Document doc, final int offset) {
        final AtomicBoolean out = new AtomicBoolean(false);
        doc.render(new Runnable(){

            @Override
            public void run() {
                out.set(CompletionSupport.isIncludeCompletionEnabledImpl(doc, offset));
            }
        });
        return out.get();
    }

    private static boolean isIncludeCompletionEnabledImpl(Document doc, int offset) {
        TokenId id;
        TokenSequence embedded;
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)false, (boolean)true);
        if (ts == null) {
            return false;
        }
        if (ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE && CndTokenUtilities.moveToPreprocKeyword((TokenSequence)(embedded = ts.embedded())) && (id = embedded.token().id()) instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: {
                    return embedded.offset() + embedded.token().length() <= offset;
                }
            }
        }
        return false;
    }

    public final CsmFinder getFinder() {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)this.getDocument());
        assert (dobj != null);
        FileObject fo = dobj.getPrimaryFile();
        return CsmFinderFactory.getDefault().getFinder(fo);
    }

    public void setContextOffset(int offset) {
        this.contextOffset = offset;
    }

    public int doc2context(int docPos) {
        int offset = this.contextOffset == NOT_INITIALIZED ? docPos : this.contextOffset;
        offset = CsmMacroExpansion.getOffsetInOriginalText((Document)this.getDocument(), (int)offset);
        return offset;
    }

    protected void setLastSeparatorOffset(int lastSeparatorOffset) {
        this.lastSeparatorOffset = lastSeparatorOffset;
    }

    protected int getLastCommandSeparator(CsmFile file, int pos, FileReferencesContext fileReferences) throws BadLocationException {
        if (pos < 0 || pos > this.getDocument().getLength()) {
            throw new BadLocationException("position is out of range[0-" + this.getDocument().getLength() + "]", pos);
        }
        if (pos == 0) {
            return 0;
        }
        int modelSeparator = CompletionSupport.tryGetSeparatorFromModel(file, pos, fileReferences);
        if (modelSeparator >= 0) {
            return modelSeparator;
        }
        int curCachedValue = this.lastSeparatorOffset;
        if (!CndTokenUtilities.isInPreprocessorDirective((Document)this.getDocument(), (int)pos) && !CndTokenUtilities.isInProCDirective((Document)this.getDocument(), (int)pos)) {
            if (curCachedValue >= 0 && curCachedValue < pos && !CndTokenUtilities.isInProCDirective((Document)this.getDocument(), (int)curCachedValue)) {
                return curCachedValue;
            }
            int newLastSeparatorOffset = CndTokenUtilities.getLastCommandSeparator((Document)this.getDocument(), (int)pos);
            if (curCachedValue == this.lastSeparatorOffset) {
                this.lastSeparatorOffset = newLastSeparatorOffset;
            }
            return newLastSeparatorOffset;
        }
        return CndTokenUtilities.getLastCommandSeparator((Document)this.getDocument(), (int)pos);
    }

    public static boolean areTemplatesEnabled(CsmFile csmFile) {
        if (csmFile != null) {
            switch (csmFile.getFileType()) {
                case SOURCE_C_FILE: 
                case SOURCE_FORTRAN_FILE: {
                    return false;
                }
            }
        }
        return true;
    }

    private static int tryGetSeparatorFromModel(CsmFile file, int pos, FileReferencesContext fileReferences) {
        if (CsmFileInfoQuery.getDefault().isCpp11OrLater(file)) {
            int distance;
            CsmOffsetable offs;
            List lambdas;
            CsmExpression expression;
            CsmVariable v;
            CsmExpression initialValue;
            CsmType retType;
            CsmContext context = CsmOffsetResolver.findContext(file, pos, fileReferences);
            CsmObject lastObj = context.getLastObject();
            if (CsmKindUtilities.isLambda((CsmObject)lastObj) && CsmOffsetUtilities.isInObject((CsmObject)(retType = ((CsmFunction)lastObj).getReturnType()), pos)) {
                return retType.getStartOffset();
            }
            if (CsmKindUtilities.isVariable((CsmObject)lastObj) && CsmOffsetUtilities.isInObject((CsmObject)(initialValue = (v = (CsmVariable)lastObj).getInitialValue()), pos)) {
                lastObj = initialValue;
            }
            if (CsmKindUtilities.isExpression((CsmObject)lastObj) && (expression = (CsmExpression)lastObj).getStartOffset() < pos && expression.getEndOffset() > pos && (lambdas = expression.getLambdas()) != null && !lambdas.isEmpty()) {
                return ((CsmOffsetable)lastObj).getStartOffset();
            }
            if (CsmKindUtilities.isOffsetable((Object)lastObj) && (offs = (CsmOffsetable)lastObj).getStartOffset() < pos && offs.getEndOffset() > pos && (distance = pos - offs.getStartOffset()) < 1024) {
                return offs.getStartOffset();
            }
        }
        return -1;
    }

    public static CsmClassifier getClassFromName(CsmFinder finder, String className, boolean searchByName) {
        List<CsmClassifier> clsList;
        CsmClassifier ret = null;
        if (ret == null && searchByName && (clsList = finder.findClasses(null, className, true, false)) != null && clsList.size() > 0 && !clsList.isEmpty()) {
            ret = clsList.get(0);
        }
        return ret;
    }

    public CsmClass getClass(CsmFile file, int docPos) {
        int pos = this.doc2context(docPos);
        return CompletionUtilities.findClassOnPosition(file, this.getDocument(), pos);
    }

    public CsmOffsetableDeclaration getDefinition(CsmFile file, int docPos, FileReferencesContext fileContext) {
        int pos = this.doc2context(docPos);
        return CompletionUtilities.findFunDefinitionOrClassOnPosition(file, this.getDocument(), pos, fileContext);
    }

    public CsmOffsetableDeclaration getDefinition(CsmScope scope) {
        while (CsmKindUtilities.isScopeElement((CsmObject)scope) && !CsmKindUtilities.isClass((CsmObject)scope) && !CsmKindUtilities.isFunction((CsmObject)scope)) {
            scope = ((CsmScopeElement)scope).getScope();
        }
        return CsmKindUtilities.isClass((CsmObject)scope) || CsmKindUtilities.isFunction((CsmObject)scope) ? (CsmOffsetableDeclaration)scope : null;
    }

    public boolean isStaticBlock(int docPos) {
        return false;
    }

    public static boolean isAssignable(CsmType from, CsmType to) {
        return CompletionSupport.isAssignable(null, from, to);
    }

    static boolean isAssignable(CsmCompletionQuery.Context ctx, CsmType origFrom, CsmType origTo) {
        AnalyzedType from = AnalyzedType.create(ctx, origFrom, false, false);
        if (from == null) {
            return false;
        }
        AnalyzedType to = AnalyzedType.create(ctx, origTo, true, true);
        if (to == null) {
            return false;
        }
        if (!CompletionSupport.isAutoConvertible(from.type, from.origType, from.typeInfo, to.type, to.origType, to.typeInfo, from.classifier, to.classifier)) {
            return CompletionSupport.isUserConvertible(from.type, from.origType, from.typeInfo, to.type, to.origType, to.typeInfo, from.classifier, to.classifier);
        }
        return true;
    }

    public static boolean isAutoConvertible(CsmType from, CsmType to) {
        return CompletionSupport.isAutoConvertible(null, from, to);
    }

    static boolean isAutoConvertible(CsmCompletionQuery.Context ctx, CsmType origFrom, CsmType origTo) {
        AnalyzedType from = AnalyzedType.create(ctx, origFrom, false, false);
        if (from == null) {
            return false;
        }
        AnalyzedType to = AnalyzedType.create(ctx, origTo, true, true);
        if (to == null) {
            return false;
        }
        return CompletionSupport.isAutoConvertible(from.type, from.origType, from.typeInfo, to.type, to.origType, to.typeInfo, from.classifier, to.classifier);
    }

    public static boolean isAutoConvertible(CsmType from, CsmType origFrom, CsmUtilities.TypeInfoCollector fromInfo, CsmType to, CsmType origTo, CsmUtilities.TypeInfoCollector toInfo, CsmClassifier fromCls, CsmClassifier toCls) {
        String tto;
        int fromArrayDepth = CsmUtilities.howMany((CsmUtilities.TypeInfoCollector)fromInfo, (CsmUtilities.Qualificator)CsmUtilities.Qualificator.ARRAY);
        int toArrayDepth = CsmUtilities.howMany((CsmUtilities.TypeInfoCollector)toInfo, (CsmUtilities.Qualificator)CsmUtilities.Qualificator.ARRAY);
        int fromPointerDepth = CsmUtilities.howMany((CsmUtilities.TypeInfoCollector)fromInfo, (CsmUtilities.Qualificator)CsmUtilities.Qualificator.POINTER);
        int toPointerDepth = CsmUtilities.howMany((CsmUtilities.TypeInfoCollector)toInfo, (CsmUtilities.Qualificator)CsmUtilities.Qualificator.POINTER);
        if (fromCls.equals(CsmCompletion.NULL_CLASS)) {
            return toArrayDepth > 0 || !CsmCompletion.isPrimitiveClass(toCls);
        }
        if (toCls.equals(CsmCompletion.OBJECT_CLASS)) {
            return fromArrayDepth > toArrayDepth || fromArrayDepth == toArrayDepth && !CsmCompletion.isPrimitiveClass(fromCls);
        }
        if (CompletionSupport.canBePointer(from) && toPointerDepth > 0) {
            return true;
        }
        if (fromPointerDepth > 0 && CompletionSupport.canBePointer(to)) {
            return true;
        }
        if (fromArrayDepth != toArrayDepth || fromPointerDepth != toPointerDepth) {
            return false;
        }
        if (fromCls.equals(toCls)) {
            return true;
        }
        String tfrom = origFrom.getCanonicalText().toString().replaceAll("const", "").trim();
        if (tfrom.equals(tto = origTo.getCanonicalText().toString().replaceAll("const", "").trim())) {
            return true;
        }
        if (CsmCompletion.isPrimitiveClass(fromCls) && CsmCompletion.isPrimitiveClass(toCls)) {
            return true;
        }
        if (CsmKindUtilities.isClass((CsmObject)toCls) && CsmKindUtilities.isClass((CsmObject)fromCls)) {
            return CsmInheritanceUtilities.isAssignableFrom((CsmClass)((CsmClass)fromCls), (CsmClass)((CsmClass)toCls));
        }
        return false;
    }

    public static boolean isUserConvertible(CsmType from, CsmType to) {
        return CompletionSupport.isUserConvertible(null, from, to);
    }

    static boolean isUserConvertible(CsmCompletionQuery.Context ctx, CsmType origFrom, CsmType origTo) {
        AnalyzedType from = AnalyzedType.create(ctx, origFrom, false, false);
        if (from == null) {
            return false;
        }
        AnalyzedType to = AnalyzedType.create(ctx, origTo, true, true);
        if (to == null) {
            return false;
        }
        return CompletionSupport.isUserConvertible(from.type, from.origType, from.typeInfo, to.type, to.origType, to.typeInfo, from.classifier, to.classifier);
    }

    public static boolean isUserConvertible(CsmType from, CsmType origFrom, CsmUtilities.TypeInfoCollector fromInfo, CsmType to, CsmType origTo, CsmUtilities.TypeInfoCollector toInfo, CsmClassifier fromCls, CsmClassifier toCls) {
        int fromArrayDepth = CsmUtilities.howMany((CsmUtilities.TypeInfoCollector)fromInfo, (CsmUtilities.Qualificator)CsmUtilities.Qualificator.ARRAY);
        int toArrayDepth = CsmUtilities.howMany((CsmUtilities.TypeInfoCollector)toInfo, (CsmUtilities.Qualificator)CsmUtilities.Qualificator.ARRAY);
        int fromPointerDepth = CsmUtilities.howMany((CsmUtilities.TypeInfoCollector)fromInfo, (CsmUtilities.Qualificator)CsmUtilities.Qualificator.POINTER);
        int toPointerDepth = CsmUtilities.howMany((CsmUtilities.TypeInfoCollector)toInfo, (CsmUtilities.Qualificator)CsmUtilities.Qualificator.POINTER);
        if (fromArrayDepth == 0 && toArrayDepth == 0 && fromPointerDepth == 0 && toPointerDepth == 0 && CsmKindUtilities.isClass((CsmObject)toCls)) {
            CsmClass clazz = (CsmClass)toCls;
            for (CsmMember member : clazz.getMembers()) {
                CsmConstructor constructor;
                if (!CsmKindUtilities.isConstructor((CsmObject)member) || (constructor = (CsmConstructor)member).getParameters() == null) continue;
                boolean appropriate = true;
                boolean first = true;
                for (CsmParameter param : constructor.getParameters()) {
                    if (first) {
                        first = false;
                        CsmType paramType = param.getType();
                        if (paramType == null || CsmKindUtilities.isTemplateParameterType((CsmObject)paramType)) continue;
                        CsmUtilities.TypeInfoCollector paramInfo = new CsmUtilities.TypeInfoCollector();
                        CsmClassifier paramCls = (paramType = CsmUtilities.iterateTypeChain((CsmType)paramType, (CsmUtilities.Predicate)paramInfo)).getClassifier();
                        if (!CompletionSupport.isViableClassifier(paramCls, true)) {
                            appropriate = false;
                            break;
                        }
                        if (CompletionSupport.isAutoConvertible(from, origFrom, fromInfo, paramType, param.getType(), paramInfo, fromCls, paramCls)) continue;
                        appropriate = false;
                        break;
                    }
                    if (param.getInitialValue() != null) continue;
                    appropriate = false;
                    break;
                }
                if (!appropriate) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isViableClassifier(CsmClassifier cls, boolean checkInstantiationViability) {
        if (cls == null || CsmBaseUtilities.isUnresolved((Object)cls)) {
            return false;
        }
        return !checkInstantiationViability || !CsmKindUtilities.isInstantiation((CsmObject)cls) || CsmInstantiationProvider.getDefault().isViableInstantiation((CsmInstantiation)cls, true);
    }

    CsmType getCommonType(CsmCompletionQuery.Context ctx, CsmType typ1, CsmType typ2, CppTokenId operator) {
        CsmClassifier cls1;
        switch (operator) {
            case AMPAMP: 
            case BARBAR: {
                CsmClassifier cls2;
                cls1 = typ1.getClassifier();
                if (cls1 == null || (cls2 = typ2.getClassifier()) == null || !CndLexerUtilities.isType((String)cls1.getName().toString()) || !CndLexerUtilities.isType((String)cls2.getName().toString())) break;
                return CsmCompletion.BOOLEAN_TYPE;
            }
        }
        if (typ1.equals(typ2)) {
            return typ1;
        }
        switch (operator) {
            case PLUS: {
                CsmClassifier cls2;
                if (CsmBaseUtilities.isPointer((CsmType)typ1)) {
                    if (CsmBaseUtilities.isPointer((CsmType)typ2) || (cls2 = CsmBaseUtilities.getClassifier((CsmType)typ2, (CsmScope)ctx.getLexicalContextScope(), (CsmFile)ctx.getContextFile(), (int)ctx.getEndOffset(), (boolean)true)) == null || !CsmCompletion.isPrimitiveClass(cls2)) break;
                    return typ1;
                }
                if (!CsmBaseUtilities.isPointer((CsmType)typ2) || (cls1 = CsmBaseUtilities.getClassifier((CsmType)typ1, (CsmScope)ctx.getLexicalContextScope(), (CsmFile)ctx.getContextFile(), (int)ctx.getEndOffset(), (boolean)true)) == null || !CsmCompletion.isPrimitiveClass(cls1)) break;
                return typ2;
            }
            case MINUS: {
                CsmClassifier cls2;
                if (CsmBaseUtilities.isPointer((CsmType)typ1)) {
                    if (CsmBaseUtilities.isPointer((CsmType)typ2)) {
                        return CsmCompletion.INT_TYPE;
                    }
                    cls2 = CsmBaseUtilities.getClassifier((CsmType)typ2, (CsmScope)ctx.getLexicalContextScope(), (CsmFile)ctx.getContextFile(), (int)ctx.getEndOffset(), (boolean)true);
                    if (cls2 == null || !CsmCompletion.isPrimitiveClass(cls2)) break;
                    return typ1;
                }
                if (!CsmBaseUtilities.isPointer((CsmType)typ2) || (cls1 = CsmBaseUtilities.getClassifier((CsmType)typ1, (CsmScope)ctx.getLexicalContextScope(), (CsmFile)ctx.getContextFile(), (int)ctx.getEndOffset(), (boolean)true)) == null || !CsmCompletion.isPrimitiveClass(cls1)) break;
                return typ2;
            }
        }
        return this.getCommonType(typ1, typ2);
    }

    public CsmType getCommonType(CsmType typ1, CsmType typ2) {
        CsmClassifier cls2;
        if (typ1.equals(typ2)) {
            return typ1;
        }
        CsmClassifier cls1 = typ1.getClassifier();
        if (cls1 != null && (cls2 = typ2.getClassifier()) != null) {
            boolean secondIsPurePrimitive;
            boolean firstIsPrimitiveClassifier = CndLexerUtilities.isType((String)cls1.getName().toString());
            boolean secondIsPrimitiveClassifier = CndLexerUtilities.isType((String)cls2.getName().toString());
            if (!firstIsPrimitiveClassifier && !secondIsPrimitiveClassifier) {
                if (CompletionSupport.isAutoConvertible(typ1, typ2)) {
                    return typ1;
                }
                if (CompletionSupport.isAutoConvertible(typ2, typ1)) {
                    return typ2;
                }
                return null;
            }
            boolean firstIsPurePrimitive = firstIsPrimitiveClassifier && !CsmBaseUtilities.isPointer((CsmType)typ1) && typ1.getArrayDepth() == 0;
            boolean bl = secondIsPurePrimitive = secondIsPrimitiveClassifier && !CsmBaseUtilities.isPointer((CsmType)typ2) && typ2.getArrayDepth() == 0;
            if (firstIsPurePrimitive && secondIsPurePrimitive) {
                return CompletionSupport.applyArithmeticConversion(typ1, cls1, typ2, cls2);
            }
            if (secondIsPrimitiveClassifier) {
                if (CompletionSupport.isAutoConvertible(typ2, typ1)) {
                    return typ1;
                }
                if (CompletionSupport.isAutoConvertible(typ1, typ2)) {
                    return typ2;
                }
            } else if (firstIsPrimitiveClassifier) {
                if (CompletionSupport.isAutoConvertible(typ1, typ2)) {
                    return typ2;
                }
                if (CompletionSupport.isAutoConvertible(typ2, typ1)) {
                    return typ1;
                }
            }
        }
        return null;
    }

    private static CsmType applyArithmeticConversion(CsmType type1, CsmClassifier cls1, CsmType type2, CsmClassifier cls2) {
        CharSequence name1 = cls1.getName();
        CharSequence name2 = cls2.getName();
        if (CompletionSupport.isSpecifiedClass(name1, CsmCompletion.LONG_DOUBLE_CLASS)) {
            return type1;
        }
        if (CompletionSupport.isSpecifiedClass(name2, CsmCompletion.LONG_DOUBLE_CLASS)) {
            return type2;
        }
        if (CompletionSupport.isSpecifiedClass(name1, CsmCompletion.DOUBLE_CLASS)) {
            return type1;
        }
        if (CompletionSupport.isSpecifiedClass(name2, CsmCompletion.DOUBLE_CLASS)) {
            return type2;
        }
        if (CompletionSupport.isSpecifiedClass(name1, CsmCompletion.FLOAT_CLASS)) {
            return type1;
        }
        if (CompletionSupport.isSpecifiedClass(name2, CsmCompletion.FLOAT_CLASS)) {
            return type2;
        }
        if (CompletionSupport.isEitherOfSpecifiedClass(name1, name2, CsmCompletion.UNSIGNED_LONG_LONG_CLASS)) {
            return CompletionSupport.isSpecifiedClass(name1, CsmCompletion.UNSIGNED_LONG_LONG_CLASS) ? type1 : type2;
        }
        if (CompletionSupport.isEitherOfSpecifiedClass(name1, name2, CsmCompletion.LONG_LONG_CLASS)) {
            return CompletionSupport.isSpecifiedClass(name1, CsmCompletion.LONG_LONG_CLASS) ? type1 : type2;
        }
        if (CompletionSupport.isEitherOfSpecifiedClass(name1, name2, CsmCompletion.UNSIGNED_LONG_CLASS)) {
            return CompletionSupport.isSpecifiedClass(name1, CsmCompletion.UNSIGNED_LONG_CLASS) ? type1 : type2;
        }
        if (CompletionSupport.isEitherOfSpecifiedClass(name1, name2, CsmCompletion.LONG_CLASS)) {
            return CompletionSupport.isSpecifiedClass(name1, CsmCompletion.LONG_CLASS) ? type1 : type2;
        }
        if (CompletionSupport.isEitherOfSpecifiedClass(name1, name2, CsmCompletion.UNSIGNED_INT_CLASS)) {
            return CompletionSupport.isSpecifiedClass(name1, CsmCompletion.UNSIGNED_INT_CLASS) ? type1 : type2;
        }
        return CsmCompletion.INT_TYPE;
    }

    private static boolean isSpecifiedClass(CharSequence clsName, CsmCompletion.SimpleClass cls) {
        return CharSequenceUtilities.equals((CharSequence)clsName, (Object)cls.getName());
    }

    private static boolean isEitherOfSpecifiedClass(CharSequence clsName1, CharSequence clsName2, CsmCompletion.SimpleClass cls) {
        return CompletionSupport.isSpecifiedClass(clsName1, cls) || CompletionSupport.isSpecifiedClass(clsName2, cls);
    }

    private static boolean canBePointer(CsmType type) {
        if (type instanceof CsmCompletion.OffsetableType) {
            CsmClassifier typeCls = type.getClassifier();
            if (CsmCompletion.NULLPTR_CLASS.getName().equals(typeCls.getName())) {
                return true;
            }
            if (CsmCompletion.isPrimitiveClass(typeCls) && CsmCompletion.INT_CLASS.getName().equals(typeCls.getName()) && ((CsmCompletion.OffsetableType)type).isZeroConst()) {
                return true;
            }
        }
        return false;
    }

    public static <T extends CsmObject> T getFirstVisible(List<T> objects, CsmFile contextFile) {
        if (objects != null && !objects.isEmpty()) {
            if (objects.size() > 1) {
                for (CsmObject element : objects) {
                    if (!CsmIncludeResolver.getDefault().isObjectVisible(contextFile, element)) continue;
                    return (T)element;
                }
            }
            return (T)((CsmObject)objects.get(0));
        }
        return null;
    }

    public static <T extends CsmObject> List<T> filterByVisibility(List<T> objects, CsmFile contextFile) {
        List filtered;
        if (objects != null && objects.size() > 1 && !(filtered = objects.stream().filter(obj -> CsmIncludeResolver.getDefault().isObjectVisible(contextFile, obj)).collect(Collectors.toList())).isEmpty()) {
            return filtered;
        }
        return objects;
    }

    public static <T extends CsmFunctional> Collection<T> filterMethods(CsmCompletionQuery.Context ctx, Collection<T> methodList, CsmCompletionExpression exp, List<CsmType> parmTypeList, boolean acceptMoreParameters, boolean acceptIfSameNumberParams) {
        IdentityHashMap<CsmFunctional, List<CsmType>> paramsPerMethod = null;
        if (parmTypeList != null) {
            paramsPerMethod = new IdentityHashMap<CsmFunctional, List<CsmType>>();
            for (CsmFunctional mtd : methodList) {
                paramsPerMethod.put(mtd, parmTypeList);
            }
        }
        return CompletionSupport.filterMethods(ctx, methodList, paramsPerMethod, exp, acceptMoreParameters, acceptIfSameNumberParams);
    }

    public static <T extends CsmFunctional> Collection<T> filterMethods(CsmCompletionQuery.Context ctx, Collection<T> methodList, Map<T, List<CsmType>> paramsPerMethod, CsmCompletionExpression exp, boolean acceptMoreParameters, boolean acceptIfSameNumberParams) {
        boolean mustBeTemplate = exp != null ? exp.getExpID() == 17 : false;
        Collection<T> result = CompletionSupport.filterOverloadedOperators(ctx, methodList, paramsPerMethod);
        result = CompletionSupport.filterMethods(ctx, result, paramsPerMethod, mustBeTemplate, acceptMoreParameters, acceptIfSameNumberParams, false);
        if (result.size() > 1) {
            result = CompletionSupport.filterMethods(ctx, result, paramsPerMethod, mustBeTemplate, acceptMoreParameters, acceptIfSameNumberParams, true);
            if (!acceptMoreParameters && acceptIfSameNumberParams) {
                result = CompletionSupport.accurateFilterMethods(ctx, result, exp, paramsPerMethod);
            }
        }
        return result;
    }

    private static <T extends CsmFunctional> Collection<T> filterOverloadedOperators(CsmCompletionQuery.Context ctx, Collection<T> methodList, Map<T, List<CsmType>> paramTypesPerMethod) {
        ArrayList<CsmFunctional> filteredOut = null;
        IdentityHashMap<CsmType, CsmClassifier> typesMap = new IdentityHashMap<CsmType, CsmClassifier>();
        for (CsmFunctional m : methodList) {
            CsmFunction func;
            if (!(m instanceof CsmFunction) || !(func = (CsmFunction)m).isOperator()) continue;
            switch (func.getOperatorKind()) {
                case PLUS: 
                case MINUS: 
                case DIV: 
                case MUL: 
                case MOD: 
                case PLUS_PLUS: 
                case MINUS_MINUS: {
                    List<CsmType> paramTypeList = paramTypesPerMethod.get(m);
                    boolean allParamsArePrimitive = !paramTypeList.isEmpty();
                    for (CsmType paramType : paramTypeList) {
                        if (paramType != null) {
                            CsmClassifier classifier = (CsmClassifier)typesMap.get(paramType);
                            if (classifier == null && (classifier = ctx != null ? CsmBaseUtilities.getClassifier((CsmType)paramType, (CsmScope)ctx.getLexicalContextScope(), (CsmFile)ctx.getContextFile(), (int)ctx.getEndOffset(), (boolean)true) : paramType.getClassifier()) != null) {
                                typesMap.put(paramType, classifier);
                            }
                            allParamsArePrimitive &= CsmCompletion.safeIsPrimitiveClass(paramType, classifier) || CsmBaseUtilities.isPointer((CsmType)paramType);
                            continue;
                        }
                        allParamsArePrimitive = false;
                        break;
                    }
                    if (!allParamsArePrimitive) break;
                    if (filteredOut == null) {
                        filteredOut = new ArrayList<CsmFunctional>();
                    }
                    filteredOut.add(m);
                }
            }
        }
        if (filteredOut != null) {
            ArrayList<T> result = new ArrayList<T>(methodList);
            result.removeAll(filteredOut);
            return result;
        }
        return methodList;
    }

    private static <T extends CsmFunctional> Collection<T> filterMethods(CsmCompletionQuery.Context ctx, Collection<T> methodList, Map<T, List<CsmType>> paramTypesPerMethod, boolean mustBeTemplate, boolean acceptMoreParameters, boolean acceptIfSameNumberParams, boolean ignoreConstAndRef) {
        assert (methodList != null);
        if (paramTypesPerMethod == null) {
            return methodList;
        }
        ArrayList<CsmFunctional> ret = new ArrayList<CsmFunctional>();
        int maxMatched = acceptIfSameNumberParams ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (CsmFunctional m : methodList) {
            CsmType t;
            List<CsmType> parmTypeList = paramTypesPerMethod.get(m);
            int parmTypeCnt = parmTypeList.size();
            CsmParameter[] methodParms = m.getParameters().toArray(new CsmParameter[m.getParameters().size()]);
            int minParamLenght = 0;
            for (CsmParameter parameter : methodParms) {
                CsmType paramType;
                if (parameter.getInitialValue() != null || (paramType = parameter.getType()) == null || paramType.isPackExpansion()) continue;
                ++minParamLenght;
            }
            if (methodParms.length >= parmTypeCnt && minParamLenght <= parmTypeCnt || acceptMoreParameters && methodParms.length >= parmTypeCnt) {
                boolean accept = true;
                boolean bestMatch = !acceptMoreParameters && CompletionSupport.canBeBestMatch(m, mustBeTemplate);
                int matched = 0;
                for (int j = 0; accept && j < parmTypeCnt; ++j) {
                    if (methodParms[j] == null) {
                        System.err.println("Null parameter " + j + " in function " + UIDs.get((Object)m));
                        bestMatch = false;
                        continue;
                    }
                    CsmType mpt = methodParms[j].getType();
                    CsmType t2 = parmTypeList.get(j);
                    if (t2 != null) {
                        if (!methodParms[j].isVarArgs() && !CompletionSupport.equalTypes(t2, mpt, ignoreConstAndRef)) {
                            bestMatch = false;
                            if (!CompletionSupport.isAssignable(ctx, t2, mpt)) {
                                if (CsmKindUtilities.isTemplateParameterType((CsmObject)mpt)) {
                                    if (mpt.getArrayDepth() + mpt.getPointerDepth() <= t2.getArrayDepth() + t2.getPointerDepth()) {
                                        ++matched;
                                        continue;
                                    }
                                    accept = false;
                                    continue;
                                }
                                accept = false;
                                continue;
                            }
                            ++matched;
                            continue;
                        }
                        if (methodParms[j].isVarArgs()) {
                            bestMatch = false;
                        }
                        ++matched;
                        continue;
                    }
                    bestMatch = false;
                }
                if (accept) {
                    if (bestMatch) {
                        ret.clear();
                    } else if (matched > maxMatched) {
                        maxMatched = matched;
                        ret.clear();
                    }
                    ret.add(m);
                    if (!bestMatch) continue;
                    break;
                }
                if (matched <= maxMatched) continue;
                maxMatched = matched;
                ret.clear();
                ret.add(m);
                continue;
            }
            if (methodParms.length != 0 || parmTypeCnt != 1 || (t = parmTypeList.get(0)) == null || !"void".equals(t.getText())) continue;
            ret.clear();
            ret.add(m);
        }
        return ret;
    }

    private static boolean canBeBestMatch(CsmFunctional fun, boolean mustBeTemplate) {
        if (mustBeTemplate) {
            return false;
        }
        return !CompletionSupport.isTemplateFunction(fun);
    }

    private static <T extends CsmFunctional> Collection<T> accurateFilterMethods(CsmCompletionQuery.Context ctx, Collection<T> methods, CsmCompletionExpression exp, Map<T, List<CsmType>> paramTypesPerMethod) {
        if (methods.size() <= 1) {
            return methods;
        }
        ArrayList<OverloadingCandidate<CsmFunctional>> candidates = new ArrayList<OverloadingCandidate<CsmFunctional>>();
        for (CsmFunctional m : methods) {
            List<CsmType> paramTypes = paramTypesPerMethod.get(m);
            int n = paramTypes.size();
            CsmParameter[] methodParams = m.getParameters().toArray(new CsmParameter[m.getParameters().size()]);
            int minParamLenght = 0;
            for (CsmParameter parameter : methodParams) {
                CsmType paramType;
                if (parameter.getInitialValue() != null || (paramType = parameter.getType()) == null || paramType.isPackExpansion()) continue;
                ++minParamLenght;
            }
            if (methodParams.length < n || minParamLenght > n) continue;
            ArrayList<Conversion> conversions = new ArrayList<Conversion>(methodParams.length);
            for (int j = 0; j < n; ++j) {
                CsmType methodParamType = methodParams[j].getType();
                CsmType paramType = paramTypes.get(j);
                if (paramType != null && methodParamType != null) {
                    conversions.add(new Conversion(ctx, paramType, methodParamType));
                    continue;
                }
                if (paramType == null || methodParamType != null) continue;
                conversions.add(new Conversion(paramType, methodParamType, ConversionCategory.VarArgConversion));
            }
            if (!CompletionSupport.checkTemplateAcceptable(m, conversions)) {
                for (int i = 0; i < conversions.size(); ++i) {
                    Conversion conversion = (Conversion)conversions.get(i);
                    if (!ConversionCategory.Template.equals((Object)conversion.category)) continue;
                    conversions.set(i, new Conversion(conversion.from, conversion.to, ConversionCategory.NotConvertable));
                }
            }
            Collections.sort(conversions);
            candidates.add(new OverloadingCandidate<CsmFunctional>(m, conversions));
        }
        Collections.sort(candidates, new OverloadingCandidatesComparator());
        ArrayList<T> result = new ArrayList<T>();
        OverloadingCandidate prev = null;
        for (OverloadingCandidate overloadingCandidate : candidates) {
            if (prev != null && overloadingCandidate.compareTo(prev) != 0) break;
            boolean validCandidate = true;
            if (ctx != null && CsmKindUtilities.isTemplate(overloadingCandidate.function)) {
                List<CsmType> paramTypes = paramTypesPerMethod.get(overloadingCandidate.function);
                CsmType retType = CompletionSupport.extractFunctionType(ctx, Arrays.asList(overloadingCandidate.function), exp, paramTypes);
                CsmClassifier cls = retType != null ? CsmBaseUtilities.getClassifier((CsmType)retType, (CsmScope)ctx.getLexicalContextScope(), (CsmFile)ctx.getContextFile(), (int)ctx.getEndOffset(), (boolean)true) : null;
                boolean bl = validCandidate = cls != null && cls.isValid();
            }
            if (!validCandidate) continue;
            prev = overloadingCandidate;
            result.add(overloadingCandidate.function);
        }
        return result.isEmpty() ? methods : result;
    }

    private static boolean checkTemplateAcceptable(CsmFunctional function, List<Conversion> conversions) {
        if (CsmKindUtilities.isTemplate((CsmObject)function)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Conversion conversion : conversions) {
                if (!ConversionCategory.Template.equals((Object)conversion.category)) continue;
                String paramCanonicalText = conversion.to.getCanonicalText().toString();
                if (map.containsKey(paramCanonicalText)) {
                    String valueText = conversion.from.getCanonicalText().toString();
                    if (valueText.equals(map.get(paramCanonicalText))) continue;
                    return false;
                }
                map.put(paramCanonicalText, conversion.from.getCanonicalText().toString());
            }
        }
        return true;
    }

    private static boolean isTemplateFunction(CsmFunctional fun) {
        if (CsmKindUtilities.isTemplate((CsmObject)fun)) {
            List templateParameters = ((CsmTemplate)fun).getTemplateParameters();
            return templateParameters != null && !templateParameters.isEmpty();
        }
        return false;
    }

    public static boolean isCompletionEnabled(Document doc, int offset) {
        return CompletionSupport.isCompletionEnabled(doc, offset, -1);
    }

    public static boolean isCompletionEnabled(final Document doc, final int offset, final int queryType) {
        final AtomicBoolean out = new AtomicBoolean(false);
        doc.render(new Runnable(){

            @Override
            public void run() {
                out.set(CompletionSupport.isCompletionEnabledImpl(doc, offset, queryType));
            }
        });
        return out.get();
    }

    private static boolean isCompletionEnabledImpl(Document doc, int offset, int queryType) {
        TokenId id;
        if (doc.getLength() == 0) {
            return true;
        }
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (offset > 0 ? 1 : 0) != 0);
        if (ts == null) {
            return false;
        }
        if (ts.offset() < offset && offset <= ts.offset() + ts.token().length() && (id = ts.token().id()) instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case RPAREN: {
                    if (queryType <= 0) break;
                    return false;
                }
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case RAW_STRING_LITERAL: 
                case PREPROCESSOR_USER_INCLUDE: 
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_DEFINED: {
                    return false;
                }
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: {
                    return offset == ts.offset() + ts.token().length();
                }
            }
            if ("preprocessor-keyword-directive".equals(ts.token().id().primaryCategory())) {
                return false;
            }
            if (queryType != 4 && "number".equals(ts.token().id().primaryCategory())) {
                return false;
            }
        }
        return true;
    }

    public static boolean needShowCompletionOnTextLite(JTextComponent target, String typedText, String[] triggers) {
        char typedChar = typedText.charAt(typedText.length() - 1);
        for (String pattern : triggers) {
            if (pattern.length() <= 0 || pattern.charAt(pattern.length() - 1) != typedChar) continue;
            return true;
        }
        return false;
    }

    public static boolean needShowCompletionOnText(JTextComponent target, String typedText, String[] triggers) {
        if (CompletionSupport.needShowCompletionOnTextLite(target, typedText, triggers)) {
            int dotPos = target.getCaret().getDot();
            Document doc = target.getDocument();
            for (String pattern : triggers) {
                if (pattern.isEmpty() || dotPos < pattern.length()) continue;
                try {
                    String text = doc.getText(dotPos - pattern.length(), pattern.length());
                    if (!pattern.equals(text)) continue;
                    if (dotPos > pattern.length()) {
                        char prev = doc.getText(dotPos - pattern.length() - 1, 1).charAt(0);
                        char first = pattern.charAt(0);
                        if (Character.isJavaIdentifierPart(first)) {
                            if (Character.isJavaIdentifierPart(prev)) continue;
                            return true;
                        }
                        return true;
                    }
                    return true;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static boolean equalTypes(CsmType t, CsmType mpt, boolean ignoreConstAndRef) {
        assert (t != null);
        if (t.equals(mpt)) {
            return true;
        }
        if (mpt != null) {
            String t1 = t.getCanonicalText().toString();
            String canonicalText = mpt.getCanonicalText().toString().trim();
            if (ignoreConstAndRef) {
                if (canonicalText.endsWith("&")) {
                    canonicalText = canonicalText.substring(0, canonicalText.length() - 1);
                }
                if (canonicalText.startsWith("const") && canonicalText.length() > 5 && Character.isWhitespace(canonicalText.charAt(5))) {
                    canonicalText = canonicalText.substring(6);
                }
            }
            return t1.equals(canonicalText);
        }
        return false;
    }

    static CsmType extractFunctionType(CsmCompletionQuery.Context context, Collection<? extends CsmFunctional> mtdList, CsmCompletionExpression genericNameExp, List<CsmType> typeList) {
        CsmType out = null;
        if (mtdList.isEmpty()) {
            return null;
        }
        for (CsmFunctional csmFunctional : mtdList) {
            CsmFunctional entity = csmFunctional;
            if (CsmKindUtilities.isConstructor((CsmObject)entity)) {
                entity = ((CsmConstructor)entity).getContainingClass();
            }
            if (CsmKindUtilities.isFunctional((CsmObject)entity)) {
                out = entity.getReturnType();
            } else if (CsmKindUtilities.isClassifier((CsmObject)entity)) {
                out = CsmCompletion.createType((CsmClassifier)entity, 0, 0, 0, false, false);
            }
            if (out == null) continue;
            break;
        }
        return out;
    }

    static CsmObject createInstantiation(CsmCompletionQuery.Context context, CsmTemplate template, CsmCompletionExpression exp, List<CsmType> typeList) {
        if (exp != null || !typeList.isEmpty() || context.getContextInstantiations() != null) {
            List<CsmInstantiation> contextInstantiations;
            CsmObject instantiation;
            CsmInstantiationProvider ip = CsmInstantiationProvider.getDefault();
            ArrayList<CsmSpecializationParameter> params = new ArrayList<CsmSpecializationParameter>();
            params.addAll(CompletionSupport.collectInstantiationParameters(context, template, ip, exp));
            if (CsmKindUtilities.isFunction((CsmObject)template)) {
                params.addAll(CompletionSupport.collectInstantiationParameters(context, ip, (CsmFunction)template, params.size(), typeList));
            }
            if (CsmKindUtilities.isTemplate((CsmObject)(instantiation = ip.instantiate(template, params))) && (contextInstantiations = context.getContextInstantiations()) != null && !contextInstantiations.isEmpty()) {
                ListIterator<CsmInstantiation> iter = contextInstantiations.listIterator(contextInstantiations.size());
                while (iter.hasPrevious()) {
                    instantiation = ip.instantiate((CsmTemplate)instantiation, iter.previous());
                }
            }
            return instantiation;
        }
        return null;
    }

    static List<CsmSpecializationParameter> collectInstantiationParameters(CsmCompletionQuery.Context context, CsmTemplate template, CsmInstantiationProvider ip, CsmCompletionExpression exp) {
        if (exp != null) {
            Iterator tplParamIter;
            ArrayList<CsmSpecializationParameter> params = new ArrayList<CsmSpecializationParameter>();
            if (exp.getExpID() == 17 && (tplParamIter = template.getTemplateParameters().iterator()).hasNext()) {
                CsmTemplateParameter tplParam = null;
                int paramsNumber = exp.getParameterCount() - 1;
                block3: for (int i = 0; i < paramsNumber; ++i) {
                    if (tplParamIter.hasNext()) {
                        tplParam = (CsmTemplateParameter)tplParamIter.next();
                    } else if (tplParam == null || !tplParam.isVarArgs()) break;
                    CsmCompletionExpression paramInst = exp.getParameter(i + 1);
                    if (paramInst == null) break;
                    switch (paramInst.getExpID()) {
                        case 0: {
                            params.add((CsmSpecializationParameter)ip.createExpressionBasedSpecializationParameter(paramInst.getTokenText(0), CompletionSupport.getContextScope(context), context.getContextFile(), paramInst.getTokenOffset(0), paramInst.getTokenOffset(0) + paramInst.getTokenLength(0)));
                            continue block3;
                        }
                        default: {
                            RenderedExpression renderedExpression;
                            CsmResultItem resItem;
                            List<? extends CompletionItem> candidates;
                            CsmType type = null;
                            if (tplParam.isTypeBased() && CompletionSupport.canBeFunctionType(paramInst)) {
                                Pair aptLangFlavor = CsmFileInfoQuery.getDefault().getAPTLanguageFlavor(CsmFileInfoQuery.getDefault().getFileLanguageFlavor(context.getContextFile()));
                                RenderedExpression renderedExpression2 = CompletionSupport.renderExpression(paramInst, new ExpressionBuilderImpl.Creator());
                                type = CsmTypes.createType((CharSequence)renderedExpression2.text, (CsmScope)context.getLexicalContextScope(), (CsmTypes.SequenceDescriptor)new CsmTypes.SequenceDescriptor((String)aptLangFlavor.first(), (String)aptLangFlavor.second(), false, true, false, new CsmTypes.OffsetDescriptor(context.getContextFile(), renderedExpression2.startOffset, renderedExpression2.endOffset)));
                            } else if (!CompletionSupport.canBeExpression(paramInst) && (type = context.resolveType(paramInst)) != null && (candidates = context.resolveObj(paramInst)) != null && !candidates.isEmpty() && candidates.get(0) instanceof CsmResultItem && CsmKindUtilities.isCsmObject((Object)(resItem = (CsmResultItem)candidates.get(0)).getAssociatedObject()) && CsmKindUtilities.isVariable((CsmObject)((CsmObject)resItem.getAssociatedObject()))) {
                                type = null;
                            }
                            if (type != null) {
                                renderedExpression = CompletionSupport.renderExpression(paramInst, new MockExpressionBuilderImpl.Creator());
                                params.add((CsmSpecializationParameter)ip.createTypeBasedSpecializationParameter(type, CompletionSupport.getContextScope(context), context.getContextFile(), renderedExpression.startOffset, renderedExpression.endOffset));
                                continue block3;
                            }
                            renderedExpression = CompletionSupport.renderExpression(paramInst, new ExpressionBuilderImpl.Creator());
                            params.add((CsmSpecializationParameter)ip.createExpressionBasedSpecializationParameter(renderedExpression.text, CompletionSupport.getContextScope(context), context.getContextFile(), renderedExpression.startOffset, renderedExpression.endOffset));
                        }
                    }
                }
            }
            return params;
        }
        return Collections.emptyList();
    }

    static List<CsmSpecializationParameter> collectInstantiationParameters(CsmCompletionQuery.Context context, CsmInstantiationProvider ip, CsmFunction function, int explicitelyMappedSize, List<CsmType> typeList) {
        if (CsmKindUtilities.isTemplate((CsmObject)function)) {
            ArrayList<CsmSpecializationParameter> result = new ArrayList<CsmSpecializationParameter>();
            CsmTemplate template = (CsmTemplate)function;
            List templateParams = template.getTemplateParameters();
            if (templateParams.size() > explicitelyMappedSize) {
                Map<CsmTemplateParameter, CsmType[]> paramsMap = CompletionSupport.gatherTemplateParamsMap(function, typeList);
                for (int i = explicitelyMappedSize; i < templateParams.size(); ++i) {
                    CsmTemplateParameter param = (CsmTemplateParameter)templateParams.get(i);
                    CsmType[] mappedTypes = paramsMap.get(param);
                    if (mappedTypes != null && mappedTypes.length > 0) {
                        if (!param.isVarArgs()) {
                            result.add((CsmSpecializationParameter)ip.createTypeBasedSpecializationParameter(mappedTypes[0], CompletionSupport.getContextScope(context)));
                            continue;
                        }
                        for (CsmType mappedType : mappedTypes) {
                            result.add((CsmSpecializationParameter)ip.createTypeBasedSpecializationParameter(mappedType, CompletionSupport.getContextScope(context)));
                        }
                        continue;
                    }
                    return result;
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    static Map<CsmTemplateParameter, CsmType[]> gatherTemplateParamsMap(CsmFunction function, List<CsmType> typeList) {
        assert (CsmKindUtilities.isTemplate((CsmObject)function)) : "Attempt to gather template parameters map from non-template function";
        CsmTemplate template = (CsmTemplate)function;
        HashMap<CsmTemplateParameter, CsmType[]> map = new HashMap<CsmTemplateParameter, CsmType[]>();
        block0: for (CsmTemplateParameter templateParam : template.getTemplateParameters()) {
            int paramIndex = 0;
            Collection funParams = function.getParameters();
            for (CsmParameter param : funParams) {
                if (paramIndex >= typeList.size()) continue block0;
                CsmType paramType = param.getType();
                CsmInstantiationProvider.DefaultDeduceTemplateTypeStrategy calcStrategy = new CsmInstantiationProvider.DefaultDeduceTemplateTypeStrategy(new CsmInstantiationProvider.DeduceTemplateTypeStrategy.Error[]{CsmInstantiationProvider.DeduceTemplateTypeStrategy.Error.MatchQualsError});
                if (CsmKindUtilities.isTemplateParameterType((CsmObject)paramType) && paramIndex == funParams.size() - 1 && templateParam.equals(((CsmTemplateParameterType)paramType).getParameter()) && templateParam.isVarArgs()) {
                    ArrayList<CsmType> varArgs = new ArrayList<CsmType>();
                    for (int argIndex = paramIndex; argIndex < typeList.size(); ++argIndex) {
                        CsmType[] calculatedTypes = CsmInstantiationProvider.getDefault().deduceTemplateType(templateParam, paramType, typeList.get(argIndex), (CsmInstantiationProvider.DeduceTemplateTypeStrategy)calcStrategy);
                        if (calculatedTypes == null || calculatedTypes.length <= 0) continue;
                        varArgs.addAll(Arrays.asList(calculatedTypes));
                    }
                    map.put(templateParam, varArgs.toArray(new CsmType[varArgs.size()]));
                    continue block0;
                }
                CsmType[] calculatedTypes = CsmInstantiationProvider.getDefault().deduceTemplateType(templateParam, paramType, typeList.get(paramIndex), (CsmInstantiationProvider.DeduceTemplateTypeStrategy)calcStrategy);
                if (calculatedTypes != null && calculatedTypes.length > 0) {
                    map.put(templateParam, calculatedTypes);
                    continue block0;
                }
                ++paramIndex;
            }
        }
        return map;
    }

    static RenderedExpression renderExpression(CsmCompletionExpression expr, ExpressionBuilderCreator creator) {
        if (expr == null) {
            return null;
        }
        boolean allowSimilarEntities = true;
        switch (expr.getExpID()) {
            case 17: {
                int startExpOffset;
                ExpressionBuilder eb = creator.create();
                int endExpOffset = startExpOffset = expr.getTokenOffset(0);
                for (int paramIndex = 0; paramIndex < expr.getParameterCount(); ++paramIndex) {
                    RenderedExpression current = CompletionSupport.renderExpression(expr.getParameter(paramIndex), creator);
                    eb.append(current.text);
                    if (paramIndex > 0) {
                        if (paramIndex < expr.getParameterCount() - 1) {
                            eb.append(",");
                        } else {
                            eb.append("> ");
                        }
                        ++endExpOffset;
                    } else {
                        eb.append(expr.getTokenText(0));
                    }
                    endExpOffset = current.endOffset;
                }
                return new RenderedExpression(eb.toString(), startExpOffset, endExpOffset);
            }
            case 2: 
            case 3: 
            case 27: {
                allowSimilarEntities = false;
            }
            case 9: 
            case 11: 
            case 13: {
                ExpressionBuilder eb = creator.create();
                int startExpOffset = -1;
                int endExprOffset = -1;
                int paramCount = expr.getParameterCount();
                int tokenCount = expr.getTokenCount();
                int paramIndex = 0;
                int tokenIndex = 0;
                RenderedExpression renderedParam = null;
                RenderedExpression renderedToken = null;
                boolean lastWasParam = false;
                boolean lastWasToken = false;
                boolean entityChanged = true;
                while (entityChanged || allowSimilarEntities) {
                    entityChanged = false;
                    if (renderedParam == null && paramIndex < paramCount) {
                        renderedParam = CompletionSupport.renderExpression(expr.getParameter(paramIndex), creator);
                        ++paramIndex;
                    }
                    if (renderedToken == null && tokenIndex < tokenCount) {
                        ExpressionBuilder tokenExprBuilder = creator.create();
                        tokenExprBuilder.append(expr.getTokenText(tokenIndex));
                        renderedToken = new RenderedExpression(tokenExprBuilder.toString(), expr.getTokenOffset(tokenIndex), expr.getTokenOffset(tokenIndex) + expr.getTokenLength(tokenIndex));
                        ++tokenIndex;
                    }
                    if (renderedToken == null && renderedParam == null) break;
                    RenderedExpression chosenExpression = renderedParam != null && renderedToken != null ? (renderedParam.startOffset < renderedToken.startOffset ? renderedParam : (renderedParam.startOffset == renderedToken.startOffset ? (renderedParam.endOffset < renderedToken.endOffset ? renderedParam : renderedToken) : renderedToken)) : (renderedToken == null ? renderedParam : renderedToken);
                    if (chosenExpression == null) continue;
                    if (chosenExpression == renderedParam) {
                        renderedParam = null;
                        entityChanged = !lastWasParam;
                        lastWasParam = true;
                        lastWasToken = false;
                    } else {
                        renderedToken = null;
                        entityChanged = !lastWasToken;
                        lastWasToken = true;
                        lastWasParam = false;
                    }
                    if (!entityChanged && !allowSimilarEntities) continue;
                    eb.append(chosenExpression.text);
                    if (startExpOffset == -1) {
                        startExpOffset = chosenExpression.startOffset;
                    }
                    endExprOffset = chosenExpression.endOffset;
                }
                return new RenderedExpression(eb.toString(), startExpOffset, endExprOffset);
            }
        }
        if (expr.getTokenCount() > 0) {
            ExpressionBuilder eb = creator.create();
            eb.append(expr.getTokenText(0));
            return new RenderedExpression(eb.toString(), expr.getTokenOffset(0), expr.getTokenOffset(0) + expr.getTokenLength(0));
        }
        return new RenderedExpression("", 0, 0);
    }

    CsmType findExactVarType(CsmFile file, String var, int docPos, FileReferencesContext refContext) {
        if (file == null) {
            return null;
        }
        int pos = this.doc2context(docPos);
        CsmContext context = CsmOffsetResolver.findContext(file, pos, refContext);
        if (var.length() == 0 && CsmKindUtilities.isVariable((CsmObject)context.getLastObject()) && ((CsmVariable)context.getLastObject()).getInitialValue() != null) {
            CsmClass contextClass;
            CsmVariable varObj = (CsmVariable)context.getLastObject();
            CsmClassifier varCls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)varObj.getType().getClassifier(), (CsmFile)file);
            if (varCls != null && (contextClass = CsmContextUtilities.getContextClassInInitializer(varObj, varCls, pos, this.getFinder())) != null) {
                return CsmCompletion.createType((CsmClassifier)contextClass, 0, 0, 0, false, false);
            }
            if (CsmOffsetUtilities.isInObject((CsmObject)varObj.getInitialValue(), pos)) {
                CsmClassifier cls;
                CsmType type = varObj.getType();
                if (type.getArrayDepth() > 0 && (cls = type.getClassifier()) != null) {
                    type = CsmCompletion.createType(cls, 0, 0, 0, false, false);
                }
                return type;
            }
        }
        if (var.length() == 0 && CsmKindUtilities.isStatement((CsmObject)context.getLastObject())) {
            CsmStatement stmt = (CsmStatement)context.getLastObject();
            if (stmt.getKind() == CsmStatement.Kind.RETURN) {
                CsmReturnStatement ret = (CsmReturnStatement)stmt;
                try {
                    String e = this.getDocument().getText(ret.getStartOffset(), ret.getEndOffset() - ret.getStartOffset());
                    String typeName = e.replaceAll("((\\W|\n)*)return((\\W|\n|&)*)\\((.*)\\)((\\W|\n)*)\\{((.|\n)*)\\}((.|\n)*)", "$5");
                    CsmClassifier cls = CompletionSupport.getClassFromName(this.getFinder(), typeName, true);
                    if (cls != null) {
                        CsmType type = CsmCompletion.createType(cls, 0, 0, 0, false, false);
                        return type;
                    }
                }
                catch (BadLocationException e) {}
            } else if (stmt.getKind() == CsmStatement.Kind.EXPRESSION) {
                try {
                    String e = this.getDocument().getText(stmt.getStartOffset(), stmt.getEndOffset() - stmt.getStartOffset());
                    String typeName = e.replaceAll("((.|\n)*)=((\\W|\n|&)*)\\((.*)\\)((\\W|\n)*)\\{((.|\n)*)\\}((.|\n)*)", "$5");
                    CsmClassifier cls = CompletionSupport.getClassFromName(this.getFinder(), typeName, true);
                    if (cls != null) {
                        CsmType type = CsmCompletion.createType(cls, 0, 0, 0, false, false);
                        return type;
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
        for (CsmDeclaration decl : CsmContextUtilities.findFunctionLocalVariables(context)) {
            CsmVariable v;
            if (!CsmKindUtilities.isVariable((CsmObject)decl) || !(v = (CsmVariable)decl).getName().toString().equals(var)) continue;
            return v.getType();
        }
        return null;
    }

    private static boolean canBeFunctionType(CsmCompletionExpression expression) {
        if (expression.getExpID() == 11) {
            return true;
        }
        return expression.getExpID() == 9 && expression.getParameterCount() > 0 && expression.getParameter(0).getExpID() == 13;
    }

    private static boolean canBeExpression(CsmCompletionExpression expression) {
        return expression.getExpID() == 2 || expression.getExpID() == 3 || expression.getExpID() == 0 || expression.getExpID() == 11;
    }

    private static CsmScope getContextScope(CsmCompletionQuery.Context context) {
        if (context != null) {
            if (context.getLexicalContextScope() != null) {
                return context.getLexicalContextScope();
            }
            CsmOffsetableDeclaration contextElement = context.getContextElement();
            if (CsmKindUtilities.isScope((CsmObject)contextElement)) {
                return (CsmScope)contextElement;
            }
            if (CsmKindUtilities.isScopeElement((CsmObject)contextElement)) {
                return contextElement.getScope();
            }
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.lastSeparatorOffset = -1;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.lastSeparatorOffset = -1;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.lastSeparatorOffset = -1;
    }

    private static class AnalyzedType {
        public final CsmType type;
        public final CsmType origType;
        public final CsmUtilities.TypeInfoCollector typeInfo;
        public final CsmClassifier classifier;

        public static AnalyzedType create(CsmCompletionQuery.Context ctx, CsmType toAnalyze, boolean deepResolving, boolean checkInstantiationViability) {
            CsmUtilities.TypeInfoCollector typeInfo = new CsmUtilities.TypeInfoCollector();
            CsmType type = CsmUtilities.iterateTypeChain((CsmType)toAnalyze, (CsmUtilities.Predicate)typeInfo);
            CsmClassifier cls = type.getClassifier();
            if (deepResolving && (cls == null || CsmBaseUtilities.isUnresolved((Object)cls)) && ctx != null && CsmExpressionResolver.shouldResolveAsMacroType((CsmType)type, (CsmScope)ctx.getLexicalContextScope())) {
                List instantiations = CsmInstantiationProvider.getDefault().getInstantiatedTypeInstantiations(type);
                CsmClassifier csmClassifier = cls = (type = CsmExpressionResolver.resolveMacroType((CsmType)type, (CsmScope)ctx.getLexicalContextScope(), (List)instantiations, (CsmExpressionResolver.ResolvedTypeHandler)new ResolvedTypeInfoCollector(typeInfo))) != null ? type.getClassifier() : null;
            }
            if (!CompletionSupport.isViableClassifier(cls, checkInstantiationViability)) {
                return null;
            }
            return new AnalyzedType(type, toAnalyze, typeInfo, cls);
        }

        private AnalyzedType(CsmType type, CsmType origType, CsmUtilities.TypeInfoCollector typeInfo, CsmClassifier classifier) {
            this.type = type;
            this.origType = origType;
            this.typeInfo = typeInfo;
            this.classifier = classifier;
        }
    }

    private static class ResolvedTypeInfoCollector
    implements CsmExpressionResolver.ResolvedTypeHandler {
        private final CsmUtilities.TypeInfoCollector collector;

        public ResolvedTypeInfoCollector(CsmUtilities.TypeInfoCollector collector) {
            this.collector = collector;
        }

        public void process(CsmType resolvedType) {
            if (resolvedType != null) {
                this.collector.check(resolvedType);
            }
        }
    }

    private static class MockExpressionBuilderImpl
    implements ExpressionBuilder {
        private MockExpressionBuilderImpl() {
        }

        @Override
        public ExpressionBuilder append(String str) {
            return this;
        }

        @Override
        public String toString() {
            return "";
        }

        public static class Creator
        implements ExpressionBuilderCreator {
            private final MockExpressionBuilderImpl instance = new MockExpressionBuilderImpl();

            @Override
            public ExpressionBuilder create() {
                return this.instance;
            }
        }
    }

    private static class ExpressionBuilderImpl
    implements ExpressionBuilder {
        private final StringBuilder sb = new StringBuilder();

        private ExpressionBuilderImpl() {
        }

        @Override
        public ExpressionBuilder append(String str) {
            this.sb.append(str);
            return this;
        }

        @Override
        public String toString() {
            return this.sb.toString();
        }

        public static class Creator
        implements ExpressionBuilderCreator {
            @Override
            public ExpressionBuilder create() {
                return new ExpressionBuilderImpl();
            }
        }
    }

    static interface ExpressionBuilderCreator {
        public ExpressionBuilder create();
    }

    static interface ExpressionBuilder {
        public ExpressionBuilder append(String var1);

        public String toString();
    }

    static class RenderedExpression {
        public final String text;
        public final int startOffset;
        public final int endOffset;

        public RenderedExpression(String text, int startOffset, int endOffset) {
            this.text = text;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public String toString() {
            return this.text + "[" + this.startOffset + "," + this.endOffset + "]";
        }
    }

    private static final class InstantiatedClassifiersEqualizer
    implements CsmUtilities.ClassifiersEqualizer {
        private InstantiatedClassifiersEqualizer() {
        }

        public boolean areClassifiersEqual(CsmType type1, CsmClassifier cls1, CsmType type2, CsmClassifier cls2) {
            if (CsmKindUtilities.isInstantiation((CsmObject)cls1) && CsmKindUtilities.isInstantiation((CsmObject)cls2)) {
                if (CharSequenceUtilities.textEquals((CharSequence)cls1.getQualifiedName(), (CharSequence)cls2.getQualifiedName())) {
                    CharSequence instText1 = CsmInstantiationProvider.getDefault().getInstantiatedText(type1);
                    int lt1 = CharSequenceUtilities.indexOf((CharSequence)instText1, (CharSequence)CppTokenId.LT.fixedText());
                    int gt1 = CharSequenceUtilities.lastIndexOf((CharSequence)instText1, (CharSequence)CppTokenId.GT.fixedText());
                    CharSequence instText2 = CsmInstantiationProvider.getDefault().getInstantiatedText(type2);
                    int lt2 = CharSequenceUtilities.indexOf((CharSequence)instText2, (CharSequence)CppTokenId.LT.fixedText());
                    int gt2 = CharSequenceUtilities.lastIndexOf((CharSequence)instText2, (CharSequence)CppTokenId.GT.fixedText());
                    if (lt1 >= 0 && gt1 >= lt1 && lt2 >= 0 && gt2 >= lt2 && gt1 - lt1 == gt2 - lt2) {
                        for (int i = 0; i < gt1 - lt1; ++i) {
                            if (instText1.charAt(lt1 + i) == instText2.charAt(lt2 + i)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
            return CharSequenceUtilities.textEquals((CharSequence)cls1.getQualifiedName(), (CharSequence)cls2.getQualifiedName());
        }
    }

    private static final class OverloadingCandidatesComparator<T extends CsmFunctional>
    implements Comparator<OverloadingCandidate<T>> {
        private OverloadingCandidatesComparator() {
        }

        @Override
        public int compare(OverloadingCandidate<T> o1, OverloadingCandidate<T> o2) {
            int comparison = o1.compareTo(o2);
            if (comparison == 0) {
                return this.howManyQualConversions(o1) - this.howManyQualConversions(o2);
            }
            return comparison;
        }

        private int howManyQualConversions(OverloadingCandidate<T> candidate) {
            int qualConversions = 0;
            for (Conversion conversion : candidate.conversions) {
                if (!ConversionCategory.Qualification.equals((Object)conversion.category)) continue;
                ++qualConversions;
            }
            return qualConversions;
        }
    }

    private static class OverloadingCandidate<T extends CsmFunctional>
    implements Comparable<OverloadingCandidate<T>> {
        public final T function;
        public final List<Conversion> conversions;

        public OverloadingCandidate(T function, List<Conversion> conversions) {
            this.function = function;
            this.conversions = conversions;
        }

        @Override
        public int compareTo(OverloadingCandidate<T> o) {
            Conversion theirConversion;
            if (this.conversions.isEmpty() && o.conversions.isEmpty()) {
                return 0;
            }
            if (o.conversions.isEmpty()) {
                return -1;
            }
            if (this.conversions.isEmpty()) {
                return 1;
            }
            int ourWorst = 0;
            int theirWorst = 0;
            while ((ourWorst != this.conversions.size() - 1 || theirWorst != o.conversions.size() - 1) && this.conversions.get(ourWorst).isEqual(o.conversions.get(theirWorst))) {
                ourWorst = this.findNextWorstConversion(this.conversions, ourWorst);
                theirWorst = this.findNextWorstConversion(o.conversions, theirWorst);
            }
            Conversion ourConversion = this.conversions.get(ourWorst);
            if (!ourConversion.isEqual(theirConversion = o.conversions.get(theirWorst))) {
                return ourConversion.category.getRank() - theirConversion.category.getRank();
            }
            if (CsmKindUtilities.isTemplate(this.function) != CsmKindUtilities.isTemplate(o.function)) {
                if (CsmKindUtilities.isTemplate(o.function)) {
                    return -1;
                }
                return 1;
            }
            if (!CsmKindUtilities.isTemplate(this.function)) {
                return 0;
            }
            return this.calcTemplateScore((CsmTemplate)o.function, o.conversions) - this.calcTemplateScore((CsmTemplate)this.function, this.conversions);
        }

        private int findNextWorstConversion(List<Conversion> conversions, int from) {
            int index = from;
            Conversion current = conversions.get(index);
            while (++index < conversions.size() && conversions.get(index).isEqual(current)) {
            }
            return index < conversions.size() ? index : index - 1;
        }

        private int calcTemplateScore(CsmTemplate template, List<Conversion> conversions) {
            int score = 0;
            for (Conversion conversion : conversions) {
                score += conversion.templateScore;
            }
            return score - template.getTemplateParameters().size();
        }
    }

    private static enum ConversionCategory {
        Identity(1),
        Qualification(1),
        Template(1),
        Promotion(3),
        StandardConversion(4),
        UserDefinedConversion(5),
        VarArgConversion(6),
        NotConvertable(100);

        private final int rank;

        public int getRank() {
            return this.rank;
        }

        public static ConversionCategory getWorstConversion(CsmCompletionQuery.Context ctx, CsmType from, CsmType to) {
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)to)) {
                return Template;
            }
            InstantiatedClassifiersEqualizer clsEqualizer = new InstantiatedClassifiersEqualizer();
            CsmUtilities.ExactMatchQualsEqualizer strongQualsEqualizer = new CsmUtilities.ExactMatchQualsEqualizer();
            CsmUtilities.AssignableQualsEqualizer softQualsEqualizer = new CsmUtilities.AssignableQualsEqualizer();
            CsmUtilities.EqualResult res = CsmUtilities.checkTypesEqual((CsmType)from, (CsmFile)from.getContainingFile(), (CsmType)to, (CsmFile)to.getContainingFile(), (CsmUtilities.ClassifiersEqualizer)clsEqualizer, (CsmUtilities.QualifiersEqualizer)strongQualsEqualizer, (boolean)true);
            if (res == CsmUtilities.EqualResult.EQUAL) {
                return Identity;
            }
            if (res == CsmUtilities.EqualResult.QUALS_NOT_EQUAL && (res = CsmUtilities.checkTypesEqual((CsmType)from, (CsmFile)from.getContainingFile(), (CsmType)to, (CsmFile)to.getContainingFile(), (CsmUtilities.ClassifiersEqualizer)clsEqualizer, (CsmUtilities.QualifiersEqualizer)softQualsEqualizer, (boolean)true)) == CsmUtilities.EqualResult.EQUAL) {
                return Qualification;
            }
            if (CompletionSupport.isAssignable(ctx, from, to)) {
                CsmClassifier fromCls = from.getClassifier();
                CsmClassifier toCls = to.getClassifier();
                if (CsmCompletion.isPrimitiveClass(toCls) && CsmCompletion.isPrimitiveClass(fromCls)) {
                    if (ConversionCategory.isPromotion(from.getClassifierText().toString(), to.getClassifierText().toString())) {
                        return Promotion;
                    }
                    return StandardConversion;
                }
                return UserDefinedConversion;
            }
            return NotConvertable;
        }

        private ConversionCategory(int rank) {
            this.rank = rank;
        }

        private static boolean isPromotion(String from, String to) {
            return to.equals("int") && (from.equals("char") || from.equals("unsigned char") || from.equals("short")) || to.equals("double") && from.equals("float") || to.equals("int") && from.equals("bool");
        }
    }

    private static class Conversion
    implements Comparable<Conversion> {
        public final CsmType from;
        public final CsmType to;
        public final ConversionCategory category;
        public final int templateScore;

        public Conversion(CsmCompletionQuery.Context ctx, CsmType from, CsmType to) {
            this.from = from;
            this.to = to;
            this.category = ConversionCategory.getWorstConversion(ctx, from, to);
            this.templateScore = this.calcTemplateScore(from, to, this.category);
        }

        public Conversion(CsmType from, CsmType to, ConversionCategory category) {
            this.from = from;
            this.to = to;
            this.category = category;
            this.templateScore = 0;
        }

        public boolean isBetter(Conversion other) {
            return this.category.rank < other.category.rank;
        }

        public boolean isEqual(Conversion other) {
            return this.category.rank == other.category.rank;
        }

        public boolean isWorse(Conversion other) {
            return this.category.rank > other.category.rank;
        }

        @Override
        public int compareTo(Conversion o) {
            return this.category.getRank() - o.category.getRank();
        }

        private int calcTemplateScore(CsmType from, CsmType to, ConversionCategory category) {
            CsmType origToType;
            if (ConversionCategory.Template.equals((Object)category) && (origToType = CsmInstantiationProvider.getDefault().getOriginalType(to)) != null) {
                int score = 0;
                if (from.isConst() && origToType.isConst()) {
                    ++score;
                }
                if (from.isPointer() && origToType.isPointer()) {
                    ++score;
                }
                return score;
            }
            return 0;
        }
    }
}

