/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner.actions;

import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;
import org.openide.util.NbBundle;

public class DeleteRowAction
extends AbstractGridAction {
    private String name = NbBundle.getMessage(DeleteRowAction.class, (String)"DeleteRowAction_Name");

    @Override
    public Object getValue(String key) {
        return key.equals("Name") ? this.name : null;
    }

    @Override
    public boolean isEnabled(DesignerContext context) {
        return context.getFocusedRow() != -1 && context.getGridInfo().getRowCount() > 1;
    }

    @Override
    public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
        int[] rowBounds;
        GridInfoProvider gridInfo = gridManager.getGridInfo();
        boolean gapSupport = gridInfo.hasGaps();
        int[] originalColumnBounds = gridInfo.getColumnBounds();
        int[] originalRowBounds = gridInfo.getRowBounds();
        int row = context.getFocusedRow();
        GridUtils.removePaddingComponents(gridManager);
        gridManager.deleteRow(row);
        GridUtils.addPaddingComponents(gridManager, originalColumnBounds.length - 1, originalRowBounds.length - 1 - (gapSupport ? 2 : 1));
        GridUtils.revalidateGrid(gridManager);
        int[] newRowBounds = gridInfo.getRowBounds();
        int[] newColumnBounds = gridInfo.getColumnBounds();
        if (row == originalRowBounds.length - 2) {
            rowBounds = newRowBounds;
        } else {
            rowBounds = new int[newRowBounds.length + (gapSupport ? 2 : 1)];
            if (gapSupport) {
                System.arraycopy(newRowBounds, 0, rowBounds, 0, row + 1);
                rowBounds[row + 1] = rowBounds[row];
                rowBounds[row + 2] = rowBounds[row];
                System.arraycopy(newRowBounds, row + 1, rowBounds, row + 3, newRowBounds.length - row - 1);
            } else {
                System.arraycopy(newRowBounds, 0, rowBounds, 0, row + 1);
                rowBounds[row + 1] = rowBounds[row];
                System.arraycopy(newRowBounds, row + 1, rowBounds, row + 2, newRowBounds.length - row - 1);
            }
        }
        return new GridBoundsChange(originalColumnBounds, originalRowBounds, newColumnBounds, rowBounds);
    }
}

