/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectOptionsFormat;
import org.openide.util.NbBundle;

public class CCCompilerConfiguration
extends CCCCompilerConfiguration
implements Cloneable {
    public static final int STANDARD_DEFAULT = 0;
    public static final int STANDARD_CPP98 = 1;
    public static final int STANDARD_CPP11 = 2;
    public static final int STANDARD_CPP14 = 3;
    public static final int STANDARD_INHERITED = 4;
    private static final String[] STANDARD_NAMES = new String[]{CCCompilerConfiguration.getString("STANDARD_DEFAULT"), CCCompilerConfiguration.getString("STANDARD_CPP98"), CCCompilerConfiguration.getString("STANDARD_CPP11"), CCCompilerConfiguration.getString("STANDARD_CPP14"), CCCompilerConfiguration.getString("STANDARD_INHERITED")};
    private static final String[] STANDARD_NAMES_ROOT = new String[]{CCCompilerConfiguration.getString("STANDARD_DEFAULT"), CCCompilerConfiguration.getString("STANDARD_CPP98"), CCCompilerConfiguration.getString("STANDARD_CPP11"), CCCompilerConfiguration.getString("STANDARD_CPP14")};
    private IntConfiguration cppStandard;

    public CCCompilerConfiguration(String baseDir, CCCompilerConfiguration master, MakeConfiguration owner) {
        super(baseDir, master, owner);
        this.cppStandard = master != null ? new IntConfiguration(null, 4, STANDARD_NAMES, null) : new IntConfiguration(null, 0, STANDARD_NAMES_ROOT, null);
    }

    public void fixupMasterLinks(CCCompilerConfiguration compilerConfiguration) {
        super.fixupMasterLinks(compilerConfiguration);
        this.getCppStandard().setMaster(compilerConfiguration.getCppStandard());
    }

    public IntConfiguration getCppStandard() {
        return this.cppStandard;
    }

    public int getCppStandardExternal() {
        switch (this.getCppStandard().getValue()) {
            case 0: {
                return NativeFileItem.LanguageFlavor.DEFAULT.toExternal();
            }
            case 1: {
                return NativeFileItem.LanguageFlavor.CPP.toExternal();
            }
            case 2: {
                return NativeFileItem.LanguageFlavor.CPP11.toExternal();
            }
            case 3: {
                return NativeFileItem.LanguageFlavor.CPP14.toExternal();
            }
            case 4: {
                return NativeFileItem.LanguageFlavor.UNKNOWN.toExternal();
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN.toExternal();
    }

    public void setCppStandard(IntConfiguration cppStandard) {
        this.cppStandard = cppStandard;
    }

    public void setCppStandardExternal(int cppStandard) {
        if (cppStandard == NativeFileItem.LanguageFlavor.DEFAULT.toExternal()) {
            this.cppStandard.setValue(0);
        } else if (cppStandard == NativeFileItem.LanguageFlavor.CPP.toExternal()) {
            this.cppStandard.setValue(1);
        } else if (cppStandard == NativeFileItem.LanguageFlavor.CPP11.toExternal()) {
            this.cppStandard.setValue(2);
        } else if (cppStandard == NativeFileItem.LanguageFlavor.CPP14.toExternal()) {
            this.cppStandard.setValue(3);
        } else if (cppStandard == NativeFileItem.LanguageFlavor.UNKNOWN.toExternal()) {
            this.cppStandard.setValue(4);
        }
    }

    public void assign(CCCompilerConfiguration conf) {
        super.assign(conf);
        this.getCppStandard().assign(conf.getCppStandard());
    }

    @Override
    public boolean getModified() {
        return super.getModified() || this.getCppStandard().getModified();
    }

    public boolean isCppStandardChanged() {
        return this.getCppStandard().getDirty() && this.getCppStandard().getPreviousValue() != this.getInheritedCppStandard();
    }

    public CCCompilerConfiguration clone() {
        CCCompilerConfiguration clone = new CCCompilerConfiguration(this.getBaseDir(), (CCCompilerConfiguration)this.getMaster(), this.getOwner());
        clone.setDevelopmentMode(this.getDevelopmentMode().clone());
        clone.setWarningLevel(this.getWarningLevel().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setSixtyfourBits(this.getSixtyfourBits().clone());
        clone.setStrip(this.getStrip().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setTool(this.getTool().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setLibraryLevel(this.getLibraryLevel().clone());
        clone.setStandardsEvolution(this.getStandardsEvolution().clone());
        clone.setLanguageExt(this.getLanguageExt().clone());
        clone.setIncludeDirectories((VectorConfiguration<String>)this.getIncludeDirectories().clone());
        clone.setInheritIncludes(this.getInheritIncludes().clone());
        clone.setIncludeFiles((VectorConfiguration<String>)this.getIncludeFiles().clone());
        clone.setInheritFiles(this.getInheritFiles().clone());
        clone.setPreprocessorConfiguration((VectorConfiguration<String>)this.getPreprocessorConfiguration().clone());
        clone.setInheritPreprocessor(this.getInheritPreprocessor().clone());
        clone.setUndefinedPreprocessorConfiguration((VectorConfiguration<String>)this.getUndefinedPreprocessorConfiguration().clone());
        clone.setInheritUndefinedPreprocessor(this.getInheritUndefinedPreprocessor().clone());
        clone.setUseLinkerLibraries(this.getUseLinkerLibraries().clone());
        clone.setImportantFlags(this.getImportantFlags().clone());
        clone.setCppStandard(this.getCppStandard().clone());
        return clone;
    }

    @Override
    public String getOptions(AbstractCompiler compiler) {
        StringBuilder options = new StringBuilder("$(COMPILE.cc) ");
        options.append(this.getAllOptions2(compiler)).append(' ');
        options.append(this.getCommandLineOptions(true));
        return MakeProjectOptionsFormat.reformatWhitespaces(options.toString());
    }

    public String getCCFlagsBasic(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getMTLevelOptions(this.getMTLevel().getValue()) + " ";
        options = options + compiler.getLibraryLevelOptions(this.getLibraryLevel().getValue()) + " ";
        options = options + compiler.getStandardEvaluationOptions(this.getStandardsEvolution().getValue()) + " ";
        options = options + compiler.getLanguageExtOptions(this.getLanguageExt().getValue()) + " ";
        options = options + compiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            options = options + compiler.getDevelopmentModeOptions(3);
        }
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    public String getCCFlags(AbstractCompiler compiler) {
        String options = this.getCCFlagsBasic(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        if (!(tool instanceof AbstractCompiler)) {
            return "";
        }
        AbstractCompiler compiler = (AbstractCompiler)tool;
        StringBuilder options = new StringBuilder();
        options.append(this.getCCFlagsBasic(compiler)).append(" ");
        this.getMasters(true).forEach(master -> options.append(master.getCommandLineConfiguration().getValue()).append(" "));
        options.append(this.getAllOptions2(compiler)).append(" ");
        return MakeProjectOptionsFormat.reformatWhitespaces(options.toString());
    }

    public String getAllOptions2(AbstractCompiler compiler) {
        String options = "";
        if (this.getDevelopmentMode().getValue() != 3) {
            options = options + compiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        }
        options = options + compiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        options = options + compiler.getStripOption(this.getStrip().getValue()) + " ";
        options = options + this.getPreprocessorOptions(compiler.getCompilerSet());
        options = options + this.getIncludeDirectoriesOptions(compiler.getCompilerSet());
        options = options + this.getLibrariesFlags();
        options = options + compiler.getCppStandardOptions(this.getInheritedCppStandard());
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    public int getInheritedCppStandard() {
        for (BasicCompilerConfiguration master : this.getMasters(true)) {
            if (((CCCompilerConfiguration)master).getCppStandard().getValue() == 4) continue;
            return ((CCCompilerConfiguration)master).getCppStandard().getValue();
        }
        return 2;
    }

    public String getPreprocessorOptions(CompilerSet cs) {
        ArrayList<CCCompilerConfiguration> list = new ArrayList<CCCompilerConfiguration>();
        for (BasicCompilerConfiguration master : this.getMasters(true)) {
            list.add((CCCompilerConfiguration)master);
            if (((CCCompilerConfiguration)master).getInheritPreprocessor().getValue()) continue;
            break;
        }
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(null, this.getUserMacroFlag(cs));
        StringBuilder options = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            options.append(((CCCCompilerConfiguration)list.get(i)).getPreprocessorConfiguration().toString(visitor)).append(' ');
        }
        return options.toString();
    }

    public String getIncludeDirectoriesOptions(CompilerSet cs) {
        ArrayList<CCCCompilerConfiguration> list = new ArrayList<CCCCompilerConfiguration>();
        for (BasicCompilerConfiguration master : this.getMasters(true)) {
            list.add((CCCCompilerConfiguration)master);
            if (((CCCCompilerConfiguration)master).getInheritIncludes().getValue()) continue;
            break;
        }
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(cs, this.getUserIncludeFlag(cs));
        StringBuilder options = new StringBuilder(this.getIncludeDirectories().toString(visitor)).append(' ');
        for (int i = list.size() - 1; i > 0; --i) {
            options.append(((CCCCompilerConfiguration)list.get(i)).getIncludeDirectories().toString(visitor)).append(' ');
        }
        String includeFilesOptions = this.getIncludeFilesOptions(cs);
        if (includeFilesOptions.isEmpty()) {
            return options.toString();
        }
        return options.toString() + " " + includeFilesOptions;
    }

    private String getIncludeFilesOptions(CompilerSet cs) {
        ArrayList<CCCCompilerConfiguration> list = new ArrayList<CCCCompilerConfiguration>();
        for (BasicCompilerConfiguration master : this.getMasters(true)) {
            list.add((CCCCompilerConfiguration)master);
            if (((CCCCompilerConfiguration)master).getInheritFiles().getValue()) continue;
            break;
        }
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(cs, this.getUserFileFlag(cs));
        StringBuilder options = new StringBuilder(this.getIncludeFiles().toString(visitor)).append(' ');
        for (int i = list.size() - 1; i > 0; --i) {
            options.append(((CCCCompilerConfiguration)list.get(i)).getIncludeFiles().toString(visitor)).append(' ');
        }
        return options.toString();
    }

    @Override
    protected ToolchainManager.CompilerDescriptor getCompilerDescriptor(CompilerSet cs) {
        return cs.getCompilerFlavor().getToolchainDescriptor().getCpp();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCCompilerConfiguration.class, (String)s);
    }
}

