/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.ErrorCheckingSupport;
import org.netbeans.modules.javascript2.editor.hints.JsAstRule;
import org.netbeans.modules.javascript2.editor.hints.JsConventionRule;
import org.netbeans.modules.javascript2.editor.hints.JsFunctionDocumentationRule;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.Lines;
import org.openide.filesystems.FileObject;

public class JsHintsProvider
implements HintsProvider {
    private static final Logger LOGGER = Logger.getLogger(JsHintsProvider.class.getName());
    private volatile boolean cancel = false;

    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
        List otherHints;
        this.resume();
        Map allHints = manager.getHints(false, context);
        List conventionHints = (List)allHints.get("jsconvention.option.hints");
        boolean countConventionHints = false;
        if (conventionHints != null) {
            for (Rule.AstRule astRule : conventionHints) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                countConventionHints = true;
            }
        }
        if (countConventionHints && !this.cancel) {
            JsConventionRule rule = new JsConventionRule();
            this.invokeHint(rule, manager, context, hints, -1);
        }
        List documentationRules = (List)allHints.get("jsdocumentation.option.hints");
        boolean documentationHints = false;
        if (documentationRules != null) {
            for (Rule.AstRule astRule : documentationRules) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                documentationHints = true;
            }
        }
        if (documentationHints && !this.cancel) {
            JsFunctionDocumentationRule rule = new JsFunctionDocumentationRule();
            this.invokeHint(rule, manager, context, hints, -1);
        }
        if ((otherHints = (List)allHints.get("js.other.hints")) != null && !this.cancel) {
            for (Rule.AstRule astRule : otherHints) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                JsAstRule rule = (JsAstRule)astRule;
                this.invokeHint(rule, manager, context, hints, -1);
            }
        }
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
        this.resume();
        Map allSuggestions = manager.getHints(true, context);
        List otherHints = (List)allSuggestions.get("js.other.hints");
        if (otherHints != null && !this.cancel) {
            for (Rule.AstRule astRule : otherHints) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                JsAstRule rule = (JsAstRule)astRule;
                this.invokeHint(rule, manager, context, suggestions, caretOffset);
            }
        }
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        this.resume();
        JsParserResult parserResult = (JsParserResult)context.parserResult;
        List<? extends FilterableError> errors = parserResult.getDiagnostics();
        if (parserResult.isEmbedded()) {
            FileObject fileObject;
            String mimeType = ErrorCheckingSupport.getMimeType((Parser.Result)parserResult);
            ArrayList<HintFix> defaultFixes = new ArrayList<HintFix>(2);
            if (!ErrorCheckingSupport.isErrorCheckingEnabledForFile((Parser.Result)parserResult)) {
                defaultFixes.add(ErrorCheckingSupport.createErrorFixForFile(parserResult.getSnapshot(), true));
            }
            if (!ErrorCheckingSupport.isErrorCheckingEnabledForMimetype(mimeType)) {
                defaultFixes.add(ErrorCheckingSupport.createErrorFixForMimeType(parserResult.getSnapshot(), mimeType, true));
            }
            if (!errors.isEmpty() && ErrorCheckingSupport.isErrorCheckingEnabled((Parser.Result)parserResult, mimeType)) {
                ArrayList arrayList = new ArrayList(2);
                if (ErrorCheckingSupport.isErrorCheckingEnabledForFile((Parser.Result)parserResult)) {
                    arrayList.add(ErrorCheckingSupport.createErrorFixForFile(parserResult.getSnapshot(), false));
                }
                if (ErrorCheckingSupport.isErrorCheckingEnabledForMimetype(mimeType)) {
                    arrayList.add(ErrorCheckingSupport.createErrorFixForMimeType(parserResult.getSnapshot(), mimeType, false));
                }
                Snapshot snapshot = parserResult.getSnapshot();
                Lines lines = new Lines(snapshot.getText());
                HashSet<Integer> linesWithHints = new HashSet<Integer>();
                for (Error error : errors) {
                    FileObject fo2 = error.getFile();
                    if (fo2 == null) continue;
                    boolean contains = false;
                    try {
                        int line = lines.getLineIndex(error.getStartPosition());
                        contains = !linesWithHints.add(line);
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                    int start = snapshot.getOriginalOffset(error.getStartPosition());
                    int end = snapshot.getOriginalOffset(error.getEndPosition());
                    if (start <= -1 || end <= -1 || start > end) continue;
                    Hint h = new Hint((Rule)new JsErrorRule(), error.getDisplayName(), fo2, new OffsetRange(start, end), contains ? Collections.emptyList() : arrayList, 100);
                    hints.add(h);
                }
            }
            if ((fileObject = parserResult.getSnapshot().getSource().getFileObject()) != null && !defaultFixes.isEmpty()) {
                Hint h = new Hint((Rule)new JsSwitchRule(), Bundle.MSG_HINT_ENABLE_ERROR_CHECKS_FILE_DESCR(), fileObject, new OffsetRange(0, 0), defaultFixes, 50);
                hints.add(h);
            }
        } else {
            HashSet<String> disableFixActionNames = new HashSet<String>();
            for (FilterableError filterableError : parserResult.getErrors(true)) {
                if (filterableError.isFiltered()) {
                    FilterableError.SetFilterAction disableFilterAction = filterableError.getDisableFilterAction();
                    if (disableFixActionNames.contains(disableFilterAction.getDisplayName())) continue;
                    disableFixActionNames.add(disableFilterAction.getDisplayName());
                    hints.add(new Hint((Rule)new JsSwitchRule(), disableFilterAction.getDisplayName(), parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(0, 0), Collections.singletonList(new ErrorCheckFix(disableFilterAction)), 10));
                    continue;
                }
                Collection enableFilterActions = filterableError.getEnableFilterActions();
                ArrayList<ErrorCheckFix> fixes = new ArrayList<ErrorCheckFix>();
                for (FilterableError.SetFilterAction action : enableFilterActions) {
                    fixes.add(new ErrorCheckFix(action));
                }
                int astFrom = filterableError.getStartPosition();
                int astTo = filterableError.getEndPosition();
                Snapshot snapshot = context.parserResult.getSnapshot();
                int docFrom = snapshot.getOriginalOffset(astFrom);
                int docTo = snapshot.getOriginalOffset(astTo);
                if (docTo == -1 && astTo > snapshot.getText().length() && docFrom + 1 == astTo) {
                    docTo = snapshot.getText().length();
                    docFrom = docTo - 1;
                }
                if (docFrom == -1 || docTo == -1) continue;
                Hint h = new Hint((Rule)new JsErrorRule(), filterableError.getDescription(), filterableError.getFile(), new OffsetRange(docFrom, docTo), fixes, 10);
                hints.add(h);
            }
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    private void resume() {
        this.cancel = false;
    }

    public List<Rule> getBuiltinRules() {
        return Collections.emptyList();
    }

    public RuleContext createRuleContext() {
        return new JsRuleContext();
    }

    private void invokeHint(JsAstRule rule, HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
        try {
            rule.computeHints((JsRuleContext)context, suggestions, caretOffset, manager);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static final class ErrorCheckFix
    implements HintFix {
        private final FilterableError.SetFilterAction action;

        public ErrorCheckFix(FilterableError.SetFilterAction action) {
            this.action = action;
        }

        public String getDescription() {
            return this.action.getDisplayName();
        }

        public void implement() throws Exception {
            this.action.run();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class JsErrorRule
    implements Rule {
        private JsErrorRule() {
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return Bundle.JsErrorRule_displayName();
        }

        public boolean showInTasklist() {
            return true;
        }

        public HintSeverity getDefaultSeverity() {
            return HintSeverity.ERROR;
        }
    }

    private static class JsSwitchRule
    implements Rule.ErrorRule {
        private JsSwitchRule() {
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return Bundle.JsSwitchRule_displayName();
        }

        public boolean showInTasklist() {
            return false;
        }

        public HintSeverity getDefaultSeverity() {
            return HintSeverity.INFO;
        }
    }

    public class JsRuleContext
    extends RuleContext {
        private JsParserResult jsParserResult = null;

        public JsParserResult getJsParserResult() {
            if (this.jsParserResult == null) {
                this.jsParserResult = (JsParserResult)this.parserResult;
            }
            return this.jsParserResult;
        }

        public boolean isCancelled() {
            return JsHintsProvider.this.cancel;
        }
    }
}

