/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.json.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javascript2.json.parser.JsonBaseVisitor;
import org.netbeans.modules.javascript2.json.parser.JsonLexer;
import org.netbeans.modules.javascript2.json.parser.JsonParser;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParseTreeToXml
extends JsonBaseVisitor<Document> {
    private final JsonLexer lexer;
    private final JsonParser parser;
    private Document doc;
    private final Deque<Element> currentNode;

    public ParseTreeToXml(@NonNull JsonLexer lexer, @NonNull JsonParser parser) {
        Parameters.notNull((CharSequence)"lexer", (Object)((Object)lexer));
        Parameters.notNull((CharSequence)"parser", (Object)((Object)parser));
        this.lexer = lexer;
        this.parser = parser;
        this.currentNode = new ArrayDeque<Element>();
    }

    @Override
    public Document visitJson(JsonParser.JsonContext ctx) {
        Element e = ParseTreeToXml.copyAttrs(this.getRuleContextElement(ctx.getRuleIndex()), ctx);
        this.currentNode.addLast(e);
        super.visitJson(ctx);
        this.currentNode.removeLast();
        return this.doc;
    }

    @Override
    public Document visitObject(JsonParser.ObjectContext ctx) {
        Element e = ParseTreeToXml.copyAttrs(this.getRuleContextElement(ctx.getRuleIndex()), ctx);
        this.currentNode.addLast(e);
        super.visitObject(ctx);
        this.currentNode.removeLast();
        return this.doc;
    }

    @Override
    public Document visitArray(JsonParser.ArrayContext ctx) {
        Element e = ParseTreeToXml.copyAttrs(this.getRuleContextElement(ctx.getRuleIndex()), ctx);
        this.currentNode.addLast(e);
        super.visitArray(ctx);
        this.currentNode.removeLast();
        return this.doc;
    }

    @Override
    public Document visitKey(JsonParser.KeyContext ctx) {
        Element e = ParseTreeToXml.copyAttrs(this.getRuleContextElement(ctx.getRuleIndex()), ctx);
        this.currentNode.addLast(e);
        super.visitKey(ctx);
        this.currentNode.removeLast();
        return this.doc;
    }

    @Override
    public Document visitValue(JsonParser.ValueContext ctx) {
        Element e = ParseTreeToXml.copyAttrs(this.getRuleContextElement(ctx.getRuleIndex()), ctx);
        this.currentNode.addLast(e);
        super.visitValue(ctx);
        this.currentNode.removeLast();
        return this.doc;
    }

    @Override
    public Document visitPair(JsonParser.PairContext ctx) {
        Element e = ParseTreeToXml.copyAttrs(this.getRuleContextElement(ctx.getRuleIndex()), ctx);
        this.currentNode.addLast(e);
        super.visitPair(ctx);
        this.currentNode.removeLast();
        return this.doc;
    }

    public Document visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() != -1) {
            ParseTreeToXml.copyAttrs(this.getTerminalNodeElement(node), node);
        }
        super.visitTerminal(node);
        return this.doc;
    }

    @NonNull
    public static String stringify(@NonNull Document doc) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF-8");
        return new String(out.toByteArray(), "UTF-8");
    }

    private static Element copyAttrs(@NonNull Element e, @NonNull ParserRuleContext ctx) {
        e.setAttribute("start", Integer.toString(ctx.start.getStartIndex()));
        e.setAttribute("stop", Integer.toString(ctx.stop.getStopIndex()));
        return e;
    }

    private static Element copyAttrs(@NonNull Element e, @NonNull TerminalNode ctx) {
        e.setAttribute("start", Integer.toString(ctx.getSymbol().getStartIndex()));
        e.setAttribute("stop", Integer.toString(ctx.getSymbol().getStopIndex()));
        e.setAttribute("text", ctx.getSymbol().getText());
        return e;
    }

    @NonNull
    private Element getRuleContextElement(int ruleIndex) {
        return this.getParseTreeElement(this.parser.getRuleNames()[ruleIndex]);
    }

    @NonNull
    private Element getTerminalNodeElement(@NonNull TerminalNode node) {
        return this.getParseTreeElement(this.lexer.getVocabulary().getSymbolicName(node.getSymbol().getType()));
    }

    @NonNull
    private Element getParseTreeElement(@NonNull String name) {
        if (!this.currentNode.isEmpty()) {
            Element parent = this.currentNode.peekLast();
            Element me = this.doc.createElement(name);
            parent.appendChild(me);
            return me;
        }
        if (this.doc != null) {
            Element parent = this.doc.getDocumentElement();
            Element me = this.doc.createElement(name);
            parent.appendChild(me);
            return me;
        }
        this.doc = XMLUtil.createDocument((String)name, null, null, null);
        return this.doc.getDocumentElement();
    }
}

