/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.ui.libraries;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.bower.exec.BowerExecutable;
import org.netbeans.modules.javascript.bower.file.BowerJson;
import org.netbeans.modules.javascript.bower.ui.libraries.Bundle;
import org.netbeans.modules.javascript.bower.ui.libraries.DependenciesPanel;
import org.netbeans.modules.javascript.bower.ui.libraries.Dependency;
import org.netbeans.modules.javascript.bower.ui.libraries.Library;
import org.netbeans.modules.javascript.bower.ui.libraries.LibraryProvider;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class LibrariesPanel
extends JPanel
implements HelpCtx.Provider {
    private static final RequestProcessor RP = new RequestProcessor(LibrariesPanel.class);
    private final Project project;
    private Map<String, String> installedLibraries;
    private DependenciesPanel[] dependencyPanels;
    private ProgressHandle progressHandle;
    private boolean logLibraryUsage;
    private static final UsageLogger USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.javascript.bower").message(LibrariesPanel.class, "USG_BOWER_LIBRARY_EDIT").create();
    private JLabel bowerJsonProblemLabel;
    private JLabel bowerProblemLabel;
    private JPanel bowerProblemPanel;
    private JPanel buttonPanel;
    private JButton configureButton;
    private DependenciesPanel developmentPanel;
    private JLabel loadingLabel;
    private DependenciesPanel regularPanel;
    private JButton retryButton;
    private JTabbedPane tabbedPane;

    public LibrariesPanel(Project project) {
        this.project = project;
        this.initComponents();
        BowerJson bowerJson = this.getBowerJson();
        if (bowerJson.exists()) {
            this.dependencyPanels = new DependenciesPanel[]{this.regularPanel, this.developmentPanel};
            this.regularPanel.setDependencyType(Dependency.Type.REGULAR);
            this.developmentPanel.setDependencyType(Dependency.Type.DEVELOPMENT);
            BowerJson.BowerDependencies bowerDependencies = bowerJson.getDependencies();
            DependenciesPanel.Dependencies dependencies = new DependenciesPanel.Dependencies(bowerDependencies);
            for (DependenciesPanel dependencyPanel : this.dependencyPanels) {
                dependencyPanel.setProject(project);
                dependencyPanel.setDependencies(dependencies);
            }
            this.loadInstalledLibraries();
        } else {
            this.show(this.bowerJsonProblemLabel);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.bower.ui.libraries.LibrariesPanel");
    }

    private void show(Component component) {
        assert (EventQueue.isDispatchThread());
        GroupLayout layout = (GroupLayout)this.getLayout();
        Component currentComponent = this.getComponent(0);
        layout.replace(currentComponent, component);
    }

    ActionListener createStoreListener() {
        return new StoreListener();
    }

    private BowerJson getBowerJson() {
        return new BowerJson(this.project.getProjectDirectory());
    }

    static List<Library.Version> toLibraries(Map<String, String> map) {
        ArrayList<Library.Version> libraries = new ArrayList<Library.Version>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Library library = new Library(entry.getKey());
            Library.Version version = new Library.Version(library, entry.getValue());
            libraries.add(version);
        }
        return libraries;
    }

    private void loadInstalledLibraries() {
        this.show(this.loadingLabel);
        RP.post(new Runnable(){

            @Override
            public void run() {
                LibraryProvider provider = LibraryProvider.forProject(LibrariesPanel.this.project);
                LibrariesPanel.this.installedLibraries = provider.installedLibraries();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LibrariesPanel.this.installedLibraries == null) {
                            LibrariesPanel.this.show(LibrariesPanel.this.bowerProblemPanel);
                        } else {
                            LibrariesPanel.this.regularPanel.setInstalledLibraries(LibrariesPanel.this.installedLibraries);
                            LibrariesPanel.this.developmentPanel.setInstalledLibraries(LibrariesPanel.this.installedLibraries);
                            LibrariesPanel.this.show(LibrariesPanel.this.tabbedPane);
                        }
                    }
                });
            }
        });
    }

    void storeChanges() {
        if (this.installedLibraries == null) {
            return;
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LibrariesPanel.this.progressHandle = ProgressHandle.createHandle((String)Bundle.LibrariesPanel_updatingPackages());
                LibrariesPanel.this.progressHandle.start();
                LibrariesPanel.this.logLibraryUsage = false;
                try {
                    BowerJson bowerJson = LibrariesPanel.this.getBowerJson();
                    if (bowerJson.exists()) {
                        Dependency.Type dependencyType;
                        BowerJson.BowerDependencies dependencies = bowerJson.getDependencies();
                        ArrayList errors = new ArrayList();
                        for (DependenciesPanel dependencyPanel : LibrariesPanel.this.dependencyPanels) {
                            dependencyType = dependencyPanel.getDependencyType();
                            LibrariesPanel.this.uninstallDependencies(LibrariesPanel.this.getBowerJsonDependencies(dependencies, dependencyType), dependencyPanel.getSelectedDependencies(), dependencyType, errors);
                        }
                        for (DependenciesPanel dependencyPanel : LibrariesPanel.this.dependencyPanels) {
                            dependencyType = dependencyPanel.getDependencyType();
                            LibrariesPanel.this.installDependencies(dependencyPanel.getSelectedDependencies(), dependencyType, errors);
                        }
                        LibrariesPanel.this.progressHandle.progress(Bundle.LibrariesPanel_updatingBowerJson());
                        bowerJson.refresh();
                        for (DependenciesPanel dependencyPanel : LibrariesPanel.this.dependencyPanels) {
                            dependencyType = dependencyPanel.getDependencyType();
                            LibrariesPanel.this.updateBowerJson(dependencyPanel.getSelectedDependencies(), dependencyType, errors);
                        }
                        LibrariesPanel.this.reportErrors(errors);
                        if (LibrariesPanel.this.logLibraryUsage) {
                            LibrariesPanel.this.logLibraryUsage();
                        }
                    }
                }
                finally {
                    LibrariesPanel.this.progressHandle.finish();
                    LibrariesPanel.this.progressHandle = null;
                }
            }
        });
    }

    private Map<String, String> getBowerJsonDependencies(BowerJson.BowerDependencies dependencies, Dependency.Type dependencyType) {
        Map<String, String> map;
        switch (dependencyType) {
            case REGULAR: {
                map = dependencies.dependencies;
                break;
            }
            case DEVELOPMENT: {
                map = dependencies.devDependencies;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return map;
    }

    private String getSaveParameter(Dependency.Type dependencyType) {
        String saveParameter;
        switch (dependencyType) {
            case REGULAR: {
                saveParameter = "--save";
                break;
            }
            case DEVELOPMENT: {
                saveParameter = "--save-dev";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return saveParameter;
    }

    private String getBowerJsonSection(Dependency.Type dependencyType) {
        String section;
        switch (dependencyType) {
            case REGULAR: {
                section = "dependencies";
                break;
            }
            case DEVELOPMENT: {
                section = "devDependencies";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return section;
    }

    private void reportErrors(List<String> errors) {
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (String error : errors) {
                if (message.length() != 0) {
                    message.append('\n');
                }
                message.append(error);
            }
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message.toString(), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
        }
    }

    private void uninstallDependencies(Map<String, String> originalDependencies, List<Dependency> selectedDependencies, Dependency.Type dependencyType, List<String> errors) {
        BowerExecutable executable = BowerExecutable.getDefault(this.project, false);
        if (executable != null) {
            HashMap<String, String> selectedMap = new HashMap<String, String>();
            for (Dependency dependency : selectedDependencies) {
                selectedMap.put(dependency.getName(), dependency.getInstalledVersion());
            }
            String saveParameter = this.getSaveParameter(dependencyType);
            for (String name : originalDependencies.keySet()) {
                if (selectedMap.containsKey(name) && (!this.installedLibraries.containsKey(name) || ((String)selectedMap.get(name)).equals(this.installedLibraries.get(name)))) continue;
                this.progressHandle.progress(Bundle.LibrariesPanel_uninstallingPackage(name));
                this.installedLibraries.remove(name);
                Integer result = null;
                try {
                    Future<Integer> future = executable.uninstall(saveParameter, name);
                    if (future != null) {
                        result = future.get();
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    Logger.getLogger(LibrariesPanel.class.getName()).log(Level.INFO, null, ex);
                }
                if (result == null || result != 0) {
                    errors.add(Bundle.LibrariesPanel_uninstallationFailed(name));
                }
                this.logLibraryUsage = true;
            }
        }
    }

    private void installDependencies(List<Dependency> selectedDependencies, Dependency.Type dependencyType, List<String> errors) {
        BowerExecutable executable = BowerExecutable.getDefault(this.project, false);
        if (executable != null) {
            for (Dependency dependency : selectedDependencies) {
                String name = dependency.getName();
                String versionToInstall = dependency.getInstalledVersion();
                String installedVersion = this.installedLibraries.get(name);
                if (versionToInstall == null || versionToInstall.equals(installedVersion)) continue;
                this.progressHandle.progress(Bundle.LibrariesPanel_installingPackage(name, versionToInstall));
                Integer result = null;
                try {
                    String saveParameter = this.getSaveParameter(dependencyType);
                    String versionParameter = "\t".equals(versionToInstall) ? name : name + "#" + versionToInstall;
                    Future<Integer> future = executable.install(true, saveParameter, versionParameter);
                    if (future != null) {
                        result = future.get();
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    Logger.getLogger(LibrariesPanel.class.getName()).log(Level.INFO, null, ex);
                }
                if (result == null || result != 0) {
                    errors.add(Bundle.LibrariesPanel_installationFailed(name, versionToInstall));
                }
                this.logLibraryUsage = true;
            }
        }
    }

    private void updateBowerJson(List<Dependency> selectedDependencies, Dependency.Type dependencyType, List<String> errors) {
        BowerJson bowerJson = this.getBowerJson();
        if (bowerJson.exists()) {
            String section = this.getBowerJsonSection(dependencyType);
            Map<String, String> currentDependencies = this.getBowerJsonDependencies(bowerJson.getDependencies(), dependencyType);
            for (Dependency dependency : selectedDependencies) {
                String name = dependency.getName();
                String currentRequiredVersion = currentDependencies.get(name);
                String newRequiredVersion = dependency.getRequiredVersion();
                if (newRequiredVersion.equals(currentRequiredVersion)) continue;
                try {
                    bowerJson.setContent(Arrays.asList(section, name), newRequiredVersion);
                }
                catch (IOException ioex) {
                    Logger.getLogger(LibrariesPanel.class.getName()).log(Level.INFO, null, ioex);
                    errors.add(Bundle.LibrariesPanel_dependencyNotSet(name, newRequiredVersion));
                }
                this.logLibraryUsage = true;
            }
        }
    }

    private void logLibraryUsage() {
        USAGE_LOGGER.log(new Object[0]);
    }

    private void initComponents() {
        this.bowerJsonProblemLabel = new JLabel();
        this.bowerProblemPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.configureButton = new JButton();
        this.retryButton = new JButton();
        this.bowerProblemLabel = new JLabel();
        this.loadingLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.regularPanel = new DependenciesPanel();
        this.developmentPanel = new DependenciesPanel();
        this.bowerJsonProblemLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.bowerJsonProblemLabel, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.bowerJsonProblemLabel.text"));
        this.bowerJsonProblemLabel.setEnabled(false);
        this.bowerJsonProblemLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.configureButton, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.configureButton.text"));
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesPanel.this.configureButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.retryButton, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.retryButton.text"));
        this.retryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesPanel.this.retryButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addComponent(this.configureButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.retryButton)));
        buttonPanelLayout.linkSize(0, this.configureButton, this.retryButton);
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configureButton).addComponent(this.retryButton)));
        Mnemonics.setLocalizedText((JLabel)this.bowerProblemLabel, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.bowerProblemLabel.text"));
        GroupLayout bowerProblemPanelLayout = new GroupLayout(this.bowerProblemPanel);
        this.bowerProblemPanel.setLayout(bowerProblemPanelLayout);
        bowerProblemPanelLayout.setHorizontalGroup(bowerProblemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bowerProblemPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(bowerProblemPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.bowerProblemLabel).addComponent(this.buttonPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        bowerProblemPanelLayout.setVerticalGroup(bowerProblemPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bowerProblemPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.bowerProblemLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.loadingLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.loadingLabel, (String)NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.loadingLabel.text"));
        this.loadingLabel.setEnabled(false);
        this.loadingLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.tabbedPane.addTab(NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.regularPanel.TabConstraints.tabTitle"), this.regularPanel);
        this.tabbedPane.addTab(NbBundle.getMessage(LibrariesPanel.class, (String)"LibrariesPanel.developmentPanel.TabConstraints.tabTitle"), this.developmentPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, GroupLayout.Alignment.TRAILING));
    }

    private void configureButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Html5/Bower");
    }

    private void retryButtonActionPerformed(ActionEvent evt) {
        this.loadInstalledLibraries();
    }

    private class StoreListener
    implements ActionListener {
        private StoreListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibrariesPanel.this.storeChanges();
        }
    }
}

