/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;
import org.llvm.adt.iterator_range;
import org.llvm.support.OnDiskChainedHashTable;
import org.llvm.support.llvm;

public class OnDiskIterableChainedHashTable<external_key_type, internal_key_type, data_type>
extends OnDiskChainedHashTable<external_key_type, internal_key_type, data_type> {
    private char.ptr Payload;
    private static final key_iterator KEY_END = new key_iterator();
    private static final data_iterator DATA_END = new data_iterator();

    public OnDiskIterableChainedHashTable(int NumBuckets, int NumEntries, char.ptr Buckets, char.ptr Payload, char.ptr Base, OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
        super(NumBuckets, NumEntries, Buckets, Base, InfoObj);
        this.Payload = Native.$toConst((char.ptr)Payload);
    }

    public key_iterator key_begin() {
        return new key_iterator(this.Payload, 0, this.getNumEntries(), this.getInfoObj());
    }

    public key_iterator key_end() {
        return KEY_END;
    }

    public iterator_range keys() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public data_iterator data_begin() {
        return new data_iterator(this.Payload, 0, this.getNumEntries(), this.getInfoObj());
    }

    public data_iterator data_end() {
        return DATA_END;
    }

    public iterator_range data() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <Info extends OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type>, external_key_type, internal_key_type, data_type> OnDiskIterableChainedHashTable<external_key_type, internal_key_type, data_type> Create(char.ptr Buckets, char.ptr Payload, char.ptr Base, Info InfoObj) {
        assert (Buckets.$greater((Object)Base)) : Buckets.$index() + " vs. " + Base.$index() + ":" + Base;
        assert ((Buckets.$index() & 3) == 0) : "buckets should be 4-byte aligned. " + Buckets.$index();
        int NumBuckets = llvm.support.endian.readNext_uint32(Buckets, llvm.support.endianness.little, 0);
        int NumEntries = llvm.support.endian.readNext_uint32(Buckets, llvm.support.endianness.little, 0);
        return new OnDiskIterableChainedHashTable<external_key_type, internal_key_type, data_type>(NumBuckets, NumEntries, Native.$noClone((char.ptr)Buckets), Native.$noClone((char.ptr)Payload), Native.$noClone((char.ptr)Base), InfoObj);
    }

    @Override
    public String toString() {
        return "Payload=" + this.Payload + super.toString();
    }

    public static final class data_iterator<external_key_type, internal_key_type, data_type>
    implements Native.NativeComparable<data_iterator> {
        private final char.ptr $Ptr;
        private int Ptr;
        private int NumItemsInBucketLeft;
        private int NumEntriesLeft;
        private final OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;

        public data_iterator(char.ptr Ptr, int $PtrOffset, int NumEntries, OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.$Ptr = Native.$toConst((char.ptr)Ptr);
            this.Ptr = $PtrOffset;
            this.NumItemsInBucketLeft = 0;
            this.NumEntriesLeft = NumEntries;
            this.InfoObj = InfoObj;
        }

        public data_iterator() {
            this.$Ptr = null;
            this.Ptr = 0;
            this.NumItemsInBucketLeft = 0;
            this.NumEntriesLeft = 0;
            this.InfoObj = null;
        }

        public boolean $eq(data_iterator X) {
            return Native.$eq((int)X.NumEntriesLeft, (int)this.NumEntriesLeft);
        }

        public boolean $noteq(data_iterator X) {
            return Native.$noteq((int)X.NumEntriesLeft, (int)this.NumEntriesLeft);
        }

        public data_iterator $preInc() {
            if (this.NumItemsInBucketLeft == 0) {
                this.NumItemsInBucketLeft = llvm.support.endian.read_uint16(this.$Ptr, this.Ptr, llvm.support.endianness.little, 1);
                this.Ptr += NativeType.sizeof$uint16();
            }
            this.Ptr += NativeType.sizeof$uint32();
            long L = this.InfoObj.ReadKeyDataLength(this.$Ptr, this.Ptr);
            this.Ptr += this.InfoObj.getReadKeyDataLengthBytes();
            this.Ptr += std_pair.$first_int((long)L) + std_pair.$second_int((long)L);
            assert (this.NumItemsInBucketLeft != 0);
            --this.NumItemsInBucketLeft;
            assert (this.NumEntriesLeft != 0);
            --this.NumEntriesLeft;
            return this;
        }

        public data_iterator $postInc(int $Prm0) {
            data_iterator tmp = this.clone();
            this.$preInc();
            return tmp;
        }

        public data_type $star() {
            int LocalPtr = this.Ptr;
            if (this.NumItemsInBucketLeft == 0) {
                LocalPtr += 2;
            }
            long L = this.InfoObj.ReadKeyDataLength(this.$Ptr, LocalPtr += NativeType.sizeof$uint32());
            internal_key_type Key = this.InfoObj.ReadKey(this.$Ptr, LocalPtr += this.InfoObj.getReadKeyDataLengthBytes(), std_pair.$first_int((long)L));
            return this.InfoObj.ReadData(Key, this.$Ptr, LocalPtr + std_pair.$first_int((long)L), std_pair.$second_int((long)L));
        }

        public String toString() {
            if (this.$Ptr == null) {
                return "<DATA_END>";
            }
            return "Ptr=" + this.$Ptr.$add(this.Ptr) + ", NumItemsInBucketLeft=" + this.NumItemsInBucketLeft + ", NumEntriesLeft=" + this.NumEntriesLeft + ", InfoObj=" + this.InfoObj;
        }

        public data_iterator clone() {
            try {
                assert (false) : "check deep copy or create new real copy";
                return (data_iterator)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static final class key_iterator<external_key_type, internal_key_type, data_type> {
        private final char.ptr $Ptr;
        private int Ptr;
        private int NumItemsInBucketLeft;
        private int NumEntriesLeft;
        private final OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type> InfoObj;

        public key_iterator(char.ptr Ptr, int $PtrOffset, int NumEntries, OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
            this.$Ptr = Native.$toConst((char.ptr)Ptr);
            this.Ptr = $PtrOffset;
            this.NumItemsInBucketLeft = 0;
            this.NumEntriesLeft = NumEntries;
            this.InfoObj = InfoObj;
        }

        public key_iterator() {
            this.$Ptr = null;
            this.Ptr = 0;
            this.NumItemsInBucketLeft = 0;
            this.NumEntriesLeft = 0;
            this.InfoObj = null;
        }

        public static boolean $eq_key_iterator(key_iterator X, key_iterator Y) {
            return X.NumEntriesLeft == Y.NumEntriesLeft;
        }

        public static boolean $noteq_key_iterator(key_iterator X, key_iterator Y) {
            return X.NumEntriesLeft != Y.NumEntriesLeft;
        }

        public key_iterator $preInc() {
            if (this.NumItemsInBucketLeft == 0) {
                this.NumItemsInBucketLeft = llvm.support.endian.read_uint16(this.$Ptr, this.Ptr, llvm.support.endianness.little, 1);
                this.Ptr += NativeType.sizeof$uint16();
            }
            this.Ptr += NativeType.sizeof$uint32();
            long L = this.InfoObj.ReadKeyDataLength(this.$Ptr, this.Ptr);
            this.Ptr += this.InfoObj.getReadKeyDataLengthBytes();
            this.Ptr += std_pair.$first_int((long)L) + std_pair.$second_int((long)L);
            assert (this.NumItemsInBucketLeft != 0);
            --this.NumItemsInBucketLeft;
            assert (this.NumEntriesLeft != 0);
            --this.NumEntriesLeft;
            return this;
        }

        public key_iterator $postInc(int $Prm0) {
            key_iterator tmp = this.clone();
            this.$preInc();
            return tmp;
        }

        public external_key_type $star() {
            int LocalPtr = this.Ptr;
            if (this.NumItemsInBucketLeft == 0) {
                LocalPtr += 2;
            }
            long L = this.InfoObj.ReadKeyDataLength(this.$Ptr, LocalPtr += NativeType.sizeof$uint32());
            internal_key_type Key = this.InfoObj.ReadKey(this.$Ptr, LocalPtr += this.InfoObj.getReadKeyDataLengthBytes(), std_pair.$first_int((long)L));
            return this.InfoObj.GetExternalKey(Key);
        }

        public String toString() {
            if (this.$Ptr == null) {
                return "<KEY_END>";
            }
            return "Ptr=" + this.$Ptr.$add(this.Ptr) + ", NumItemsInBucketLeft=" + this.NumItemsInBucketLeft + ", NumEntriesLeft=" + this.NumEntriesLeft + ", InfoObj=" + this.InfoObj;
        }

        public key_iterator clone() {
            try {
                assert (false) : "check deep copy or create new real copy";
                return (key_iterator)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

