/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.endian;

import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class Writer {
    public final raw_ostream OS;
    public final llvm.support.endianness endian;

    public Writer(llvm.support.endianness endian2, raw_ostream OS) {
        this.OS = OS;
        assert (endian2 == llvm.support.endianness.little) : "only little is supported " + (Object)((Object)endian2);
        this.endian = endian2;
    }

    public <value_type> void write(value_type Val) {
        throw new UnsupportedOperationException("use specialization " + Val.getClass());
    }

    public void write_uint8(int Val) {
        assert (Val <= 255) : "bigger that one byte " + Val;
        this.OS.$out_uchar((byte)Val);
    }

    public void write_uint16(int Val) {
        assert (Val <= 65535) : "bigger that two bytes " + Val;
        this.OS.$out_uchar((byte)Val);
        this.OS.$out_uchar((byte)(Val >> 8));
    }

    public void write_uint32(int Val) {
        this.OS.$out_uchar((byte)Val);
        this.OS.$out_uchar((byte)(Val >>>= 8));
        this.OS.$out_uchar((byte)(Val >>>= 8));
        this.OS.$out_uchar((byte)(Val >>>= 8));
    }

    public void write_uint64(long Val) {
        this.OS.$out_uchar((byte)Val);
        this.OS.$out_uchar((byte)(Val >>>= 8));
        this.OS.$out_uchar((byte)(Val >>>= 8));
        this.OS.$out_uchar((byte)(Val >>>= 8));
        this.OS.$out_uchar((byte)(Val >>>= 8));
        this.OS.$out_uchar((byte)(Val >>>= 8));
        this.OS.$out_uchar((byte)(Val >>>= 8));
        this.OS.$out_uchar((byte)(Val >>>= 8));
    }

    public String toString() {
        return "OS=" + this.OS;
    }
}

