/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.j2ee.persistence.editor.CompletionContext;
import org.netbeans.modules.j2ee.persistence.editor.ContextUtilities;
import org.netbeans.modules.j2ee.persistence.editor.DocumentContext;
import org.netbeans.modules.j2ee.persistence.editor.JPAEditorUtil;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACompletionItem;
import org.netbeans.modules.j2ee.persistence.editor.completion.PUCompletor;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceCfgProperties;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class PUCompletionManager {
    private static Map<String, PUCompletor> completors = new HashMap<String, PUCompletor>();
    private static PUCompletionManager INSTANCE = new PUCompletionManager();

    private PUCompletionManager() {
        this.setupCompletors();
    }

    private void setupCompletors() {
        PUCompletor.PersistencePropertyNameCompletor propertyNamesCompletor = new PUCompletor.PersistencePropertyNameCompletor(PersistenceCfgProperties.getAllKeyAndValues());
        this.registerCompletor("property", "name", propertyNamesCompletor);
        PUCompletor.PersistencePropertyValueCompletor propertyValuesCompletor = new PUCompletor.PersistencePropertyValueCompletor(PersistenceCfgProperties.getAllKeyAndValues());
        this.registerCompletor("property", "value", propertyValuesCompletor);
        PUCompletor.PersistenceMappingFileCompletor mappingFilesCompletor = new PUCompletor.PersistenceMappingFileCompletor();
        this.registerCompletor("mapping-file", null, mappingFilesCompletor);
        PUCompletor.EntityClassCompletor javaClassCompletor = new PUCompletor.EntityClassCompletor();
        this.registerCompletor("class", null, javaClassCompletor);
        PUCompletor.ProviderCompletor providerCompletor = new PUCompletor.ProviderCompletor();
        this.registerCompletor("provider", null, providerCompletor);
        PUCompletor.ExUnlistedClassesCompletor exClassesCompletor = new PUCompletor.ExUnlistedClassesCompletor();
        this.registerCompletor("exclude-unlisted-classes", null, exClassesCompletor);
        PUCompletor.JtaDatasourceCompletor jtaDatasourceCompletor = new PUCompletor.JtaDatasourceCompletor();
        this.registerCompletor("jta-data-source", null, jtaDatasourceCompletor);
    }

    public static PUCompletionManager getDefault() {
        return INSTANCE;
    }

    public int completeAttributeValues(CompletionContext context, List<JPACompletionItem> valueItems) {
        TokenItem attrib;
        String attribName;
        int anchorOffset = -1;
        if (context.getTag() == null) {
            return anchorOffset;
        }
        String tagName = context.getTag().getNodeName();
        PUCompletor completor = this.locateCompletor(tagName, attribName = (attrib = ContextUtilities.getAttributeToken(context.getCurrentToken())) != null ? attrib.getImage() : null);
        if (completor != null) {
            valueItems.addAll(completor.doCompletion(context));
            if (completor.getAnchorOffset() != -1) {
                anchorOffset = completor.getAnchorOffset();
            }
        }
        return anchorOffset;
    }

    public int completeValues(CompletionContext context, List<JPACompletionItem> valueItems) {
        int anchorOffset = -1;
        DocumentContext docContext = context.getDocumentContext();
        SyntaxElement curElem = docContext.getCurrentElement();
        SyntaxElement prevElem = docContext.getCurrentElement().getPrevious();
        String tagName = curElem instanceof StartTag ? ((StartTag)curElem).getTagName() : (prevElem instanceof StartTag ? ((StartTag)prevElem).getTagName() : null);
        PUCompletor completor = this.locateCompletor(tagName, null);
        if (completor != null) {
            valueItems.addAll(completor.doCompletion(context));
            if (completor.getAnchorOffset() != -1) {
                anchorOffset = completor.getAnchorOffset();
            }
        } else {
            StartTag propTag;
            if (curElem instanceof StartTag && ((StartTag)curElem).getTagName().equalsIgnoreCase("property")) {
                propTag = (StartTag)curElem;
            } else if (curElem instanceof Text && prevElem instanceof StartTag && ((StartTag)prevElem).getTagName().equalsIgnoreCase("property")) {
                propTag = (StartTag)prevElem;
            } else {
                return anchorOffset;
            }
            String propName = JPAEditorUtil.getPersistencePropertyName((Node)propTag);
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            Object possibleValue = PersistenceCfgProperties.getPossiblePropertyValue(null, propName);
            if (possibleValue instanceof String[]) {
                String[] values = (String[])possibleValue;
                for (int i = 0; i < values.length; ++i) {
                    if (!values[i].startsWith(typedChars.trim()) && !values[i].startsWith("org.hibernate.dialect." + typedChars.trim())) continue;
                    JPACompletionItem item = JPACompletionItem.createHbPropertyValueItem(caretOffset - typedChars.length(), values[i]);
                    valueItems.add(item);
                }
                anchorOffset = context.getCurrentToken().getPrevious().getOffset() + 1;
            }
        }
        return anchorOffset;
    }

    public int completeAttributes(CompletionContext context, List<JPACompletionItem> attributeItems) {
        return -1;
    }

    public int completeElements(CompletionContext context, List<JPACompletionItem> elementItems) {
        return -1;
    }

    private void registerCompletor(String tagName, String attribName, PUCompletor completor) {
        completors.put(PUCompletionManager.createRegisteredName(tagName, attribName), completor);
    }

    private static String createRegisteredName(String nodeName, String attributeName) {
        StringBuilder builder = new StringBuilder();
        if (nodeName != null && nodeName.trim().length() > 0) {
            builder.append("/nodeName=");
            builder.append(nodeName);
        } else {
            builder.append("/nodeName=");
            builder.append("*");
        }
        if (attributeName != null && attributeName.trim().length() > 0) {
            builder.append("/attribute=");
            builder.append(attributeName);
        }
        return builder.toString();
    }

    private PUCompletor locateCompletor(String nodeName, String attributeName) {
        String key = PUCompletionManager.createRegisteredName(nodeName, attributeName);
        if (completors.containsKey(key)) {
            return completors.get(key);
        }
        key = PUCompletionManager.createRegisteredName("*", attributeName);
        if (completors.containsKey(key)) {
            return completors.get(key);
        }
        return null;
    }
}

